/*
 * Decompiled with CFR 0.152.
 */
package mod.lwhrvw.astrocraft.overlays;

import mod.lwhrvw.astrocraft.Astrocraft;
import mod.lwhrvw.astrocraft.MathFuncs;
import mod.lwhrvw.astrocraft.overlays.Line;
import net.minecraft.class_287;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class GridRenderer
extends MathFuncs {
    public void legacy(class_287 bb, Matrix4f matrix4f2) {
        double ra;
        if (Astrocraft.CONFIG.showEcliptic) {
            for (ra = 0.0; ra < 360.0; ra += 1.0) {
                double sra = ra - Astrocraft.getTropicalAngle();
                double sde = -Astrocraft.getEclipticDeclination(ra);
                double dra = ra + 1.0 - Astrocraft.getTropicalAngle();
                double dde = -Astrocraft.getEclipticDeclination(ra + 1.0);
                new Line(sra, sde, dra, dde).render(bb, matrix4f2, new Vector4f(1.0f, 1.0f, 0.0f, 0.35f));
            }
        }
        if (Astrocraft.CONFIG.showEquator) {
            for (ra = 0.0; ra < 360.0; ra += 1.0) {
                new Line(ra, 0.0, ra + 1.0, 0.0).render(bb, matrix4f2, new Vector4f(0.0f, 1.0f, 0.0f, 0.35f));
            }
        }
    }

    public static void renderHorizontal(class_287 bb, Matrix4f matrix4f2, double al, Vector4f color) {
        for (double ra = 0.0; ra < 360.0; ra += Astrocraft.CONFIG.gridStep) {
            new Line(ra, -al, ra + Astrocraft.CONFIG.gridStep, -al).render(bb, matrix4f2, color);
        }
    }

    public static void renderVertical(class_287 bb, Matrix4f matrix4f2, double az, Vector4f color) {
        GridRenderer.renderVertical(bb, matrix4f2, az, color, -90.0, 90.0);
    }

    public static void renderVertical(class_287 bb, Matrix4f matrix4f2, double az, Vector4f color, double start, double end) {
        for (double de = start; de < end; de += Astrocraft.CONFIG.gridStep) {
            new Line(180.0 + az, de, 180.0 + az, de + Astrocraft.CONFIG.gridStep).render(bb, matrix4f2, color);
        }
    }

    public static void renderGrid(class_287 bb, Matrix4f matrix4f2, Vector4f color) {
        double j;
        double i;
        double MAJOR_INTERVAL = 10.0;
        double MINOR_INTERVAL = 1.0;
        Vector4f majorColor = new Vector4f((Vector4fc)color).mul(1.0f, 1.0f, 1.0f, 0.15f);
        Vector4f minorColor = new Vector4f((Vector4fc)color).mul(1.0f, 1.0f, 1.0f, 0.05f);
        for (i = -90.0; i < 90.0; i += 10.0) {
            GridRenderer.renderHorizontal(bb, matrix4f2, i, majorColor);
            if (!Astrocraft.isUsingSpyglass()) continue;
            for (j = 1.0; j < 10.0; j += 1.0) {
                GridRenderer.renderHorizontal(bb, matrix4f2, i + j, minorColor);
            }
        }
        for (i = 0.0; i < 360.0; i += 10.0) {
            GridRenderer.renderVertical(bb, matrix4f2, i, majorColor);
            if (!Astrocraft.isUsingSpyglass()) continue;
            for (j = 1.0; j < 10.0; j += 1.0) {
                GridRenderer.renderVertical(bb, matrix4f2, i + j, minorColor);
            }
        }
    }

    public static void renderEquatorialGrid(class_287 bb, Matrix4f matrix4f2) {
        GridRenderer.renderGrid(bb, matrix4f2, new Vector4f(0.0f, 1.0f, 0.0f, 1.0f));
    }

    public static void renderEquator(class_287 bb, Matrix4f matrix4f2) {
        GridRenderer.renderHorizontal(bb, matrix4f2, 0.0, new Vector4f(0.0f, 1.0f, 0.0f, 0.35f));
    }

    private static Matrix4f getEclipticMatrix(Matrix4f matrix4f2) {
        return new Matrix4f((Matrix4fc)matrix4f2).rotate((Quaternionfc)class_7833.field_40714.rotationDegrees((float)Astrocraft.getTropicalAngle())).rotate((Quaternionfc)class_7833.field_40716.rotationDegrees((float)Astrocraft.getObliquity())).rotate((Quaternionfc)class_7833.field_40713.rotationDegrees((float)Astrocraft.getTropicalAngle()));
    }

    public static void renderEcliptic(class_287 bb, Matrix4f matrix4f2) {
        GridRenderer.renderHorizontal(bb, GridRenderer.getEclipticMatrix(matrix4f2), 0.0, new Vector4f(1.0f, 1.0f, 0.0f, 0.35f));
    }

    public static void renderZodiac(class_287 bb, Matrix4f matrix4f2) {
        int i = 0;
        while ((double)i < 360.0) {
            GridRenderer.renderVertical(bb, GridRenderer.getEclipticMatrix(matrix4f2), i, new Vector4f(1.0f, 1.0f, 0.0f, 0.2f), -8.0, 8.0);
            i = (int)((double)i + 30.0);
        }
    }
}

