/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.fast_buffer_upload;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import net.minecraft.class_291;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import org.lwjgl.opengl.GL15C;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_291.class}, priority=500)
public abstract class MixinVertexBuffer {
    @Unique
    private int immediatelyFast$vertexBufferSize;
    @Unique
    private int immediatelyFast$indexBufferSize;

    @Redirect(method={"uploadVertexBuffer"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;glBufferData(ILjava/nio/ByteBuffer;I)V"))
    private void optimizeVertexDataUploading(int target, ByteBuffer data, int usage) {
        if (!ImmediatelyFast.runtimeConfig.fast_buffer_upload || data.remaining() > this.immediatelyFast$vertexBufferSize) {
            this.immediatelyFast$vertexBufferSize = data.remaining();
            RenderSystem.glBufferData((int)target, (ByteBuffer)data, (int)usage);
        } else {
            GL15C.glBufferSubData((int)target, (long)0L, (ByteBuffer)data);
        }
    }

    @Redirect(method={"uploadIndexBuffer(Lnet/minecraft/client/util/BufferAllocator$CloseableBuffer;)V", "uploadIndexBuffer(Lnet/minecraft/client/render/BuiltBuffer$DrawParameters;Ljava/nio/ByteBuffer;)Lcom/mojang/blaze3d/systems/RenderSystem$ShapeIndexBuffer;"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;glBufferData(ILjava/nio/ByteBuffer;I)V"))
    private void optimizeIndexDataUploading(int target, ByteBuffer data, int usage) {
        if (!ImmediatelyFast.runtimeConfig.fast_buffer_upload || data.remaining() > this.immediatelyFast$indexBufferSize) {
            this.immediatelyFast$indexBufferSize = data.remaining();
            RenderSystem.glBufferData((int)target, (ByteBuffer)data, (int)usage);
        } else {
            GL15C.glBufferSubData((int)target, (long)0L, (ByteBuffer)data);
        }
    }
}

