/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.collection;

import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.elements.AbstractElement;
import eu.pb4.polymer.virtualentity.api.elements.DisplayElement;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2739;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_8042;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BlockCollection
extends AbstractElement
implements class_1922 {
    private final DisplayElement main = ItemDisplayElementUtil.createSimple((class_1799)class_1799.field_8037, (int)4);
    private final int[] blockId;
    private final IntList blockIdList = new IntArrayList();
    private final IntList allIdList = new IntArrayList();
    private final class_2680[] states;
    private final class_2586[] blockEntities;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private Quaternionf quaternion = class_2350.field_11036.method_23224();
    private boolean quaternionDirty = false;

    public BlockCollection(int x, int y, int z) {
        int size = x * y * z;
        this.states = new class_2680[size];
        this.blockEntities = new class_2586[size];
        this.blockId = new int[size];
        Arrays.fill(this.blockId, -1);
        this.sizeX = x;
        this.sizeY = y;
        this.sizeZ = z;
        this.allIdList.add(this.main.getEntityId());
    }

    public void startWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
        this.main.startWatching(player, packetConsumer);
        class_243 pos = this.getHolder().getPos();
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    int i = this.index(x, y, z);
                    int id = this.blockId[i];
                    if (id == -1) continue;
                    packetConsumer.accept((class_2596<class_2602>)new class_2604(id, UUID.randomUUID(), pos.field_1352, pos.field_1351, pos.field_1350, 0.0f, 0.0f, class_1299.field_42460, 0, class_243.field_1353, 0.0));
                    packetConsumer.accept((class_2596<class_2602>)new class_2739(id, List.of(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.INTERPOLATION_DURATION, (Object)1), class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.Block.BLOCK_STATE, (Object)this.states[i]), class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.TRANSLATION, (Object)new Vector3f((float)x - 0.5f, (float)y - 0.5f, (float)z - 0.5f).rotate((Quaternionfc)this.quaternion)), class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.LEFT_ROTATION, (Object)this.quaternion))));
                }
            }
        }
        packetConsumer.accept((class_2596<class_2602>)VirtualEntityUtils.createRidePacket((int)this.main.getEntityId(), (IntList)this.blockIdList));
    }

    public void setQuaternion(Quaternionf quaternion) {
        this.quaternion = quaternion;
        this.quaternionDirty = true;
    }

    public void setBlockState(int x, int y, int z, class_2680 state, @Nullable class_2586 blockEntity) {
        int i = this.index(x, y, z);
        this.states[i] = state;
        this.blockEntities[i] = blockEntity;
        if (this.blockId[i] == -1 && !state.method_26215()) {
            int e;
            this.blockId[i] = e = VirtualEntityUtils.requestEntityId();
            this.blockIdList.add(e);
            this.allIdList.add(e);
        }
    }

    @Nullable
    public class_2586 method_8321(class_2338 pos) {
        int i = this.index(pos.method_10263(), pos.method_10264(), pos.method_10260());
        return i != -1 ? this.blockEntities[i] : null;
    }

    public class_2680 method_8320(class_2338 pos) {
        return this.getBlockState(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public class_2680 getBlockState(int x, int y, int z) {
        int i = this.index(x, y, z);
        return i != -1 ? this.states[i] : class_2246.field_10243.method_9564();
    }

    public class_3610 method_8316(class_2338 pos) {
        return this.method_8320(pos).method_26227();
    }

    private int index(int x, int y, int z) {
        return x >= 0 && y >= 0 && z >= 0 && x < this.sizeX && y < this.sizeY && z < this.sizeZ ? (x + y * this.sizeX) * this.sizeZ + z : -1;
    }

    public int method_31605() {
        return 0;
    }

    public int method_31607() {
        return 0;
    }

    public IntList getEntityIds() {
        return this.allIdList;
    }

    public void stopWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
        this.main.stopWatching(player, packetConsumer);
    }

    public void notifyMove(class_243 oldPos, class_243 currentPos, class_243 delta) {
        this.main.notifyMove(oldPos, currentPos, delta);
    }

    public void tick() {
        if (this.quaternionDirty) {
            ArrayList<class_2739> b = new ArrayList<class_2739>();
            for (int x = 0; x < this.sizeX; ++x) {
                for (int y = 0; y < this.sizeY; ++y) {
                    for (int z = 0; z < this.sizeZ; ++z) {
                        int i = this.index(x, y, z);
                        int id = this.blockId[i];
                        if (id == -1) continue;
                        b.add(new class_2739(id, List.of(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.TRANSLATION, (Object)new Vector3f((float)x - 0.5f, (float)y - 0.5f, (float)z - 0.5f).rotate((Quaternionfc)this.quaternion)), class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.LEFT_ROTATION, (Object)this.quaternion), class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.START_INTERPOLATION, (Object)0))));
                    }
                }
            }
            if (this.getHolder() != null) {
                this.getHolder().sendPacket((class_2596)new class_8042(b));
            }
        }
        this.main.tick();
    }

    public void setHolder(ElementHolder holder) {
        super.setHolder(holder);
        this.main.setHolder(holder);
    }

    public void setInitialPosition(class_243 newPos) {
        super.setInitialPosition(newPos);
        this.main.setInitialPosition(newPos);
    }

    public void setOffset(class_243 offset) {
        super.setOffset(offset);
        this.main.setOffset(offset);
    }
}

