/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.data;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.data.CableConnectable;
import eu.pb4.polyfactory.block.network.NetworkBlock;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.block.property.FactoryProperties;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.util.ColoredItem;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.nodes.data.DataStorage;
import eu.pb4.polyfactory.nodes.generic.SelectiveSideNode;
import eu.pb4.polyfactory.util.ColorProvider;
import eu.pb4.polyfactory.util.DyeColorExtra;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCableBlock
extends NetworkBlock
implements class_2343,
CableConnectable,
NetworkComponent.Data,
NetworkComponent.Energy {
    public static final int DEFAULT_COLOR = 0xBBBBBB;
    public static final class_2746 HAS_CABLE = class_2746.method_11825((String)"has_cable");
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 DOWN = class_2741.field_12546;
    public static final Map<class_2350, class_2746> FACING_PROPERTIES = FactoryProperties.DIRECTIONS;

    public AbstractCableBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1268 hand = class_1268.field_5808;
        if (player.method_5998(hand).method_31573(ConventionalItemTags.DYES) && this.setColor(state, world, pos, FactoryItems.CABLE.downSampleColor(DyeColorExtra.getColor(player.method_5998(hand))))) {
            if (!player.method_7337()) {
                player.method_5998(hand).method_7934(1);
            }
            world.method_45447(null, pos, class_3417.field_28391, class_3419.field_15245);
            return class_1269.field_5812;
        }
        if (player.method_5998(hand).method_31574(FactoryItems.TREATED_DRIED_KELP) && this.setColor(state, world, pos, 0xBBBBBB)) {
            world.method_45447(null, pos, class_3417.field_28391, class_3419.field_15245);
            return class_1269.field_5812;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        ColorProvider be;
        class_1799 stack = super.method_9574(world, pos, state);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider && !(be = (ColorProvider)class_25862).isDefaultColor()) {
            ColoredItem.setColor(stack, be.getColor());
        }
        return stack;
    }

    public boolean setColor(class_2680 state, class_1937 world, class_2338 pos, int color) {
        ColorProvider provider;
        color = FactoryItems.CABLE.downSampleColor(color);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider && (provider = (ColorProvider)class_25862).getColor() != color) {
            provider.setColor(color);
            class_2680 newState = state;
            for (class_2350 dir : class_2350.values()) {
                class_2338 newPos = pos.method_10093(dir);
                class_2680 block = world.method_8320(newPos);
                newState = (class_2680)newState.method_11657((class_2769)FACING_PROPERTIES.get(dir), (Comparable)Boolean.valueOf(!this.isDirectionBlocked(state, dir) && this.canConnectTo((class_1936)world, provider.getColor(), newPos, block, dir.method_10153())));
            }
            if (state != newState) {
                world.method_8501(pos, newState);
            }
            return true;
        }
        return false;
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        boolean hasReceivers = false;
        boolean hasProviders = false;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider) {
            ColorProvider be = (ColorProvider)class_25862;
            if (itemStack.method_7909() instanceof ColoredItem) {
                be.setColor(FactoryItems.CABLE.getItemColor(itemStack));
            }
            class_2680 newState = state;
            for (class_2350 dir : class_2350.values()) {
                class_2338 newPos = pos.method_10093(dir);
                class_2680 block = world.method_8320(newPos);
                if (this.isDirectionBlocked(state, dir) || !this.canConnectTo((class_1936)world, be.getColor(), newPos, block, dir.method_10153())) continue;
                newState = (class_2680)newState.method_11657((class_2769)FACING_PROPERTIES.get(dir), (Comparable)Boolean.valueOf(true));
                if (!(placer instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)placer;
                if (hasReceivers && hasProviders) continue;
                DataStorage net = NetworkComponent.Data.getLogic(serverPlayer.method_51469(), newPos);
                if (net.hasReceivers()) {
                    hasReceivers = true;
                }
                if (!net.hasProviders()) continue;
                hasProviders = true;
            }
            if (state != newState) {
                world.method_8501(pos, newState);
            }
        }
        if (hasReceivers && hasProviders) {
            TriggerCriterion.trigger((class_3222)((class_3222)placer), (class_2960)FactoryTriggers.CABLE_CONNECT);
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    @Override
    protected void updateNetworkAt(class_1936 world, class_2338 pos) {
        NetworkComponent.Data.updateDataAt(world, pos);
        NetworkComponent.Energy.updateEnergyAt(world, pos);
    }

    @Override
    protected boolean isSameNetworkType(class_2248 block) {
        return block instanceof NetworkComponent.Data || block instanceof NetworkComponent.Energy;
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return this.isDirectionBlocked(state, direction) ? state : (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(direction), (Comparable)Boolean.valueOf(this.canConnectTo(world, AbstractCableBlock.getColor(world, pos), neighborPos, neighborState, direction.method_10153())));
    }

    public static int getColor(class_1936 world, class_2338 pos) {
        int n;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider) {
            ColorProvider be = (ColorProvider)class_25862;
            n = be.getColor();
        } else {
            n = 0xBBBBBB;
        }
        return n;
    }

    protected boolean canConnectTo(class_1936 world, int ownColor, class_2338 neighborPos, class_2680 neighborState, class_2350 direction) {
        CableConnectable connectable;
        class_2248 class_22482 = neighborState.method_26204();
        return class_22482 instanceof CableConnectable && (connectable = (CableConnectable)class_22482).canCableConnect(world, ownColor, neighborPos, neighborState, direction);
    }

    @Override
    public Collection<BlockNode> createDataNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new SelectiveSideNode(this.getDirections(state)));
    }

    @Override
    public Collection<BlockNode> createEnergyNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new SelectiveSideNode(this.getDirections(state)));
    }

    public EnumSet<class_2350> getDirections(class_2680 state) {
        ArrayList<class_2350> list = new ArrayList<class_2350>(6);
        for (class_2350 dir : class_2350.values()) {
            if (!((Boolean)state.method_11654((class_2769)FACING_PROPERTIES.get(dir))).booleanValue() || this.isDirectionBlocked(state, dir)) continue;
            list.add(dir);
        }
        return list.isEmpty() ? EnumSet.noneOf(class_2350.class) : EnumSet.copyOf(list);
    }

    protected boolean isDirectionBlocked(class_2680 state, class_2350 direction) {
        return false;
    }

    @Override
    public boolean canCableConnect(class_1936 world, int cableColor, class_2338 pos, class_2680 state, class_2350 dir) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider) {
            ColorProvider be = (ColorProvider)class_25862;
            return be.getColor() == cableColor || be.isDefaultColor() || cableColor == 0xBBBBBB;
        }
        return true;
    }

    public boolean hasCable(class_2680 state) {
        return true;
    }

    private static boolean checkModelDirection(class_2680 state, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)FACING_PROPERTIES.get(direction));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.rotate(state, NORTH, SOUTH, EAST, WEST, rotation);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return FactoryUtil.mirror(state, NORTH, SOUTH, EAST, WEST, mirror);
    }

    public static class BaseCableModel
    extends BlockModel {
        private final ItemDisplayElement cable = ItemDisplayElementUtil.createSimple();
        private int color = 0xBBBBBB;
        private class_2680 state;

        public BaseCableModel(class_2680 state) {
            this.cable.setViewRange(0.5f);
            this.state = state;
            this.updateModel();
            if (((AbstractCableBlock)state.method_26204()).hasCable(state)) {
                this.addElement((VirtualElement)this.cable);
            }
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockAwareAttachment.BLOCK_STATE_UPDATE) {
                this.setState(this.blockState());
            }
        }

        protected void setState(class_2680 blockState) {
            this.state = blockState;
            if (this.hasCable(this.state)) {
                this.addElement((VirtualElement)this.cable);
            } else {
                this.removeElement((VirtualElement)this.cable);
            }
            this.updateModel();
        }

        protected final boolean hasCable(class_2680 state) {
            return ((AbstractCableBlock)state.method_26204()).hasCable(state);
        }

        protected void updateModel() {
            class_1799 stack = this.getModel(this.state, AbstractCableBlock::checkModelDirection);
            stack.method_57379(class_9334.field_49644, (Object)new class_9282(this.color, false));
            this.cable.setItem(stack);
            if (this.cable.getHolder() == this && this.color >= 0) {
                this.cable.tick();
            }
        }

        public void setColor(int color) {
            this.color = color;
            this.updateModel();
        }

        public class_1799 getModel(class_2680 state, BiPredicate<class_2680, class_2350> directionPredicate) {
            return FactoryModels.COLORED_CABLE.get(state, directionPredicate).method_7972();
        }
    }
}

