/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.data.output;

import eu.pb4.factorytools.api.block.BarrierBasedWaterloggable;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.polyfactory.block.FactoryBlocks;
import eu.pb4.polyfactory.block.data.output.NixieTubeBlockEntity;
import eu.pb4.polyfactory.block.property.FactoryProperties;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.wrench.WrenchAction;
import eu.pb4.polyfactory.item.wrench.WrenchableBlock;
import eu.pb4.polyfactory.util.DyeColorExtra;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.TextDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_8104;
import net.minecraft.class_811;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class NixieTubeBlock
extends class_2248
implements FactoryBlock,
class_2343,
WrenchableBlock,
BarrierBasedWaterloggable {
    public static class_2769<class_2350.class_2351> AXIS = class_2741.field_12529;
    public static class_2746 POSITIVE_CONNECTED = FactoryProperties.POSITIVE_CONNECTED;
    public static class_2746 NEGATIVE_CONNECTED = FactoryProperties.NEGATIVE_CONNECTED;
    public static class_2754<class_2760> HALF = class_2741.field_12518;
    public static final WrenchAction AXIS_ACTION = WrenchAction.of("axis", AXIS);

    public NixieTubeBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AXIS, HALF, POSITIVE_CONNECTED, NEGATIVE_CONNECTED, WATERLOGGED});
    }

    @Override
    public List<WrenchAction> getWrenchActions() {
        return List.of(AXIS_ACTION, WrenchAction.HALF);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        NixieTubeBlockEntity be;
        int color;
        class_2586 class_25862;
        if (!player.method_7294()) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(class_1268.field_5808);
        if (stack.method_31574(class_1802.field_8448)) {
            String name = stack.method_57826(class_9334.field_49631) ? stack.method_7964().getString() : "";
            class_25862 = world.method_8321(pos);
            if (class_25862 instanceof NixieTubeBlockEntity) {
                NixieTubeBlockEntity be2 = (NixieTubeBlockEntity)class_25862;
                be2.pushText(name, ' ');
                return class_1269.field_5812;
            }
        }
        if ((color = DyeColorExtra.getColor(stack)) != -1 && (class_25862 = world.method_8321(pos)) instanceof NixieTubeBlockEntity && (be = (NixieTubeBlockEntity)class_25862).setColor(color)) {
            be.updateTextDisplay();
            if (!player.method_7337()) {
                stack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return this.waterLog(ctx, (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)POSITIVE_CONNECTED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)NEGATIVE_CONNECTED, (Comparable)Boolean.valueOf(false))).method_11657(AXIS, (Comparable)ctx.method_8042().method_10170().method_10166())).method_11657(HALF, (Comparable)(ctx.method_8038().method_10166() == class_2350.class_2351.field_11052 && ctx.method_8038() == class_2350.field_11033 || ctx.method_8038().method_10166() != class_2350.class_2351.field_11052 && ctx.method_17698().field_1351 - (double)ctx.method_8037().method_10264() > 0.5 ? class_2760.field_12619 : class_2760.field_12617)));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        this.tickWater(state, world, pos);
        if (state.method_11654(AXIS) != direction.method_10166()) {
            return state;
        }
        return (class_2680)state.method_11657((class_2769)(direction.method_10171() == class_2350.class_2352.field_11056 ? POSITIVE_CONNECTED : NEGATIVE_CONNECTED), (Comparable)Boolean.valueOf(neighborState.method_27852((class_2248)FactoryBlocks.NIXIE_TUBE) && neighborState.method_11654(AXIS) == state.method_11654(AXIS) && neighborState.method_11654(HALF) == state.method_11654(HALF)));
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 class_25862;
        if (newState.method_27852((class_2248)this) && (class_25862 = world.method_8321(pos)) instanceof NixieTubeBlockEntity) {
            NixieTubeBlockEntity be = (NixieTubeBlockEntity)class_25862;
            be.updatePositions(world, pos, newState);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(AXIS, (Comparable)rotation.method_10503(class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)((class_2350.class_2351)state.method_11654(AXIS)))).method_10166());
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(world, pos, initialBlockState);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new NixieTubeBlockEntity(pos, state);
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, class_3222 player) {
        return class_2246.field_10033.method_9564();
    }

    public static final class Model
    extends BlockModel {
        private static final class_8104 MAX_BRIGHTNESS = new class_8104(15, 15);
        private final Matrix4fStack mat = new Matrix4fStack(2);
        private final ItemDisplayElement mainElement;
        private final TextDisplayElement[] display = new TextDisplayElement[4];
        private char positiveFirst = (char)32;
        private char positiveSecond = (char)32;
        private char negativeFirst = (char)32;
        private char negativeSecond = (char)32;
        private int color;

        private Model(class_3218 world, class_2338 pos, class_2680 state) {
            int i;
            this.mainElement = new ItemDisplayElement(FactoryItems.NIXIE_TUBE);
            this.mainElement.setDisplaySize(1.0f, 1.0f);
            this.mainElement.setModelTransformation(class_811.field_4319);
            this.mainElement.setInvisible(true);
            this.mainElement.setViewRange(0.8f);
            for (i = 0; i < 4; ++i) {
                TextDisplayElement e = new TextDisplayElement();
                e.setBackground(0);
                e.setShadow(true);
                e.setDisplaySize(1.0f, 1.0f);
                e.setInvisible(true);
                e.setViewRange(0.4f);
                e.setBrightness(MAX_BRIGHTNESS);
                this.display[i] = e;
            }
            this.updateFacing(state);
            this.addElement((VirtualElement)this.mainElement);
            for (i = 0; i < 4; ++i) {
                this.addElement((VirtualElement)this.display[i]);
            }
        }

        public void setColor(int color) {
            if (this.color == color) {
                return;
            }
            this.positiveFirst = '\u0000';
            this.positiveSecond = '\u0000';
            this.negativeFirst = '\u0000';
            this.negativeSecond = '\u0000';
            this.color = color;
        }

        public void setText(char positiveFirst, char positiveSecond, char negativeFirst, char negativeSecond) {
            boolean dirty = false;
            if (this.positiveFirst != positiveFirst) {
                this.display[2].setText(this.asText(Character.toString(positiveFirst)));
                this.positiveFirst = positiveFirst;
                dirty = true;
            }
            if (this.positiveSecond != positiveSecond) {
                this.display[0].setText(this.asText(Character.toString(positiveSecond)));
                this.positiveSecond = positiveSecond;
                dirty = true;
            }
            if (this.negativeFirst != negativeFirst) {
                this.display[3].setText(this.asText(Character.toString(negativeFirst)));
                this.negativeFirst = negativeFirst;
                dirty = true;
            }
            if (this.negativeSecond != negativeSecond) {
                this.display[1].setText(this.asText(Character.toString(negativeSecond)));
                this.negativeSecond = negativeSecond;
                dirty = true;
            }
            if (dirty) {
                this.tick();
            }
        }

        private class_2561 asText(String text) {
            return class_2561.method_43470((String)text).method_10862(class_2583.field_24360.method_36139(this.color));
        }

        public boolean startWatching(class_3244 player) {
            return super.startWatching(player);
        }

        public void update() {
            this.updateFacing(this.blockState());
            this.tick();
        }

        private void updateFacing(class_2680 facing) {
            Quaternionf rot = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)((class_2350.class_2351)facing.method_11654(AXIS))).method_10170().method_23224().mul((Quaternionfc)class_2350.field_11043.method_23224());
            boolean up = facing.method_11654(HALF) == class_2760.field_12619;
            this.mat.clear();
            this.mat.rotate((Quaternionfc)rot);
            this.mat.pushMatrix();
            this.mat.rotateY((float)Math.PI);
            if (up) {
                this.mat.rotateZ((float)Math.PI);
            }
            this.mat.scale(2.0f);
            this.mainElement.setTransformation((Matrix4f)this.mat);
            this.mat.popMatrix();
            float yPos = up ? -0.2f : -0.4f;
            this.mat.pushMatrix();
            this.mat.translate(-0.21875f, yPos, 0.0f);
            this.mat.scale(1.7f);
            this.mat.rotateY((float)Math.PI);
            this.display[0].setTransformation((Matrix4f)this.mat);
            this.mat.popMatrix();
            this.mat.pushMatrix();
            this.mat.translate(0.28125f, yPos, 0.0f);
            this.mat.scale(1.7f);
            this.mat.rotateY((float)Math.PI);
            this.display[2].setTransformation((Matrix4f)this.mat);
            this.mat.popMatrix();
            this.mat.pushMatrix();
            this.mat.translate(-0.28125f, yPos, 0.0f);
            this.mat.scale(1.7f);
            this.display[3].setTransformation((Matrix4f)this.mat);
            this.mat.popMatrix();
            this.mat.pushMatrix();
            this.mat.translate(0.21875f, yPos, 0.0f);
            this.mat.scale(1.7f);
            this.display[1].setTransformation((Matrix4f)this.mat);
            this.mat.popMatrix();
            this.tick();
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateFacing(this.blockState());
            }
        }
    }
}

