/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.data.output;

import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.data.output.NixieTubeBlock;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;

public class NixieTubeBlockEntity
extends class_2586
implements BlockEntityExtraListener {
    private String value = "";
    private char padding = (char)32;
    private int positiveIndex = 0;
    private int negativeIndex = 0;
    private int connectionSize = 1;
    private int color = 16739865;
    private NixieTubeBlock.Model model;

    public NixieTubeBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.NIXIE_TUBE, pos, state);
    }

    public int connectionSize() {
        return this.connectionSize;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        nbt.method_10582("Text", this.value);
        nbt.method_10569("PIndex", this.positiveIndex);
        nbt.method_10569("NIndex", this.negativeIndex);
        nbt.method_10569("ConnSize", this.connectionSize);
        nbt.method_10569("Color", this.color);
        nbt.method_10569("Padding", (int)this.padding);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        this.value = nbt.method_10558("Text");
        this.positiveIndex = nbt.method_10550("PIndex");
        this.negativeIndex = nbt.method_10550("NIndex");
        this.color = nbt.method_10550("Color");
        this.connectionSize = nbt.method_10550("ConnSize");
        this.padding = (char)nbt.method_10550("Padding");
        this.updateTextDisplay();
    }

    public boolean setIndex(int positive, int negative) {
        if (this.positiveIndex == positive && this.negativeIndex == negative) {
            return false;
        }
        this.positiveIndex = positive;
        this.negativeIndex = negative;
        this.method_5431();
        return true;
    }

    public boolean setText(String value) {
        if (!this.value.equals(value)) {
            this.value = value;
            this.method_5431();
            return true;
        }
        return false;
    }

    public void onListenerUpdate(class_2818 chunk) {
        NixieTubeBlock.Model model;
        ElementHolder elementHolder = BlockBoundAttachment.get((class_2818)chunk, (class_2338)this.method_11016()).holder();
        this.model = elementHolder instanceof NixieTubeBlock.Model ? (model = (NixieTubeBlock.Model)elementHolder) : null;
        this.updateTextDisplay();
    }

    public void pushText(String string, char padding) {
        String finalString = string;
        this.pushUpdate(tube -> {
            boolean b = tube.setText(finalString);
            if (b) {
                tube.padding = padding;
                tube.updateTextDisplay();
            }
            return b;
        });
    }

    public void pushUpdate(Predicate<NixieTubeBlockEntity> modifierAndPredicate) {
        NixieTubeBlockEntity tube;
        class_2586 class_25862;
        class_2350.class_2351 axis = (class_2350.class_2351)this.method_11010().method_11654(NixieTubeBlock.AXIS);
        class_2350 dir = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11060, (class_2350.class_2351)axis);
        if (!modifierAndPredicate.test(this)) {
            return;
        }
        this.updateTextDisplay();
        class_2338.class_2339 mut = this.field_11867.method_25503();
        if (((Boolean)this.method_11010().method_11654((class_2769)NixieTubeBlock.NEGATIVE_CONNECTED)).booleanValue()) {
            do {
                assert (this.field_11863 != null);
            } while ((class_25862 = this.field_11863.method_8321((class_2338)mut.method_10098(dir))) instanceof NixieTubeBlockEntity && (tube = (NixieTubeBlockEntity)class_25862).method_11010().method_11654(NixieTubeBlock.AXIS) == axis && ((Boolean)tube.method_11010().method_11654((class_2769)NixieTubeBlock.POSITIVE_CONNECTED)).booleanValue() && modifierAndPredicate.test(tube) && ((Boolean)tube.method_11010().method_11654((class_2769)NixieTubeBlock.NEGATIVE_CONNECTED)).booleanValue());
            mut.method_10101((class_2382)this.field_11867);
        }
        dir = dir.method_10153();
        if (((Boolean)this.method_11010().method_11654((class_2769)NixieTubeBlock.POSITIVE_CONNECTED)).booleanValue()) {
            do {
                assert (this.field_11863 != null);
            } while ((class_25862 = this.field_11863.method_8321((class_2338)mut.method_10098(dir))) instanceof NixieTubeBlockEntity && (tube = (NixieTubeBlockEntity)class_25862).method_11010().method_11654(NixieTubeBlock.AXIS) == axis && ((Boolean)tube.method_11010().method_11654((class_2769)NixieTubeBlock.NEGATIVE_CONNECTED)).booleanValue() && modifierAndPredicate.test(tube) && ((Boolean)tube.method_11010().method_11654((class_2769)NixieTubeBlock.POSITIVE_CONNECTED)).booleanValue());
        }
    }

    public void updateTextDisplay() {
        if (this.model == null) {
            return;
        }
        this.model.setColor(this.color);
        this.model.setText(this.getCharSafe(this.positiveIndex * 2), this.getCharSafe(this.positiveIndex * 2 + 1), this.getCharSafe(this.negativeIndex * 2), this.getCharSafe(this.negativeIndex * 2 + 1));
    }

    public boolean setColor(int color) {
        if (this.color == color) {
            return false;
        }
        this.color = color;
        return true;
    }

    private char getCharSafe(int i) {
        return i >= 0 && i < this.value.length() ? this.value.charAt(i) : this.padding;
    }

    public void updatePositions(class_1937 world, class_2338 pos, class_2680 newState) {
        class_1657 class_16572;
        NixieTubeBlockEntity tube;
        class_2586 class_25862;
        ArrayList<NixieTubeBlockEntity> list = new ArrayList<NixieTubeBlockEntity>();
        class_2338.class_2339 mut = pos.method_25503();
        list.add(this);
        class_2350.class_2351 axis = (class_2350.class_2351)newState.method_11654(NixieTubeBlock.AXIS);
        class_2760 half = (class_2760)newState.method_11654(NixieTubeBlock.HALF);
        class_2350 dir = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11060, (class_2350.class_2351)axis);
        int max = 64;
        while ((class_25862 = world.method_8321((class_2338)mut.method_10098(dir))) instanceof NixieTubeBlockEntity && (tube = (NixieTubeBlockEntity)class_25862).method_11010().method_11654(NixieTubeBlock.AXIS) == axis && tube.method_11010().method_11654(NixieTubeBlock.HALF) == half) {
            list.add(0, tube);
            if (max-- != 0) continue;
            return;
        }
        mut.method_10101((class_2382)pos);
        dir = dir.method_10153();
        max = 64;
        while ((class_25862 = world.method_8321((class_2338)mut.method_10098(dir))) instanceof NixieTubeBlockEntity && (tube = (NixieTubeBlockEntity)class_25862).method_11010().method_11654(NixieTubeBlock.AXIS) == axis && tube.method_11010().method_11654(NixieTubeBlock.HALF) == half) {
            list.add(tube);
            if (max-- != 0) continue;
            return;
        }
        int positive = 0;
        int negative = list.size() - 1;
        for (NixieTubeBlockEntity entry : list) {
            boolean dirty = false;
            dirty |= entry.setIndex(positive++, negative--);
            entry.connectionSize = list.size();
            if (!(dirty |= entry.setText(this.value))) continue;
            entry.updateTextDisplay();
        }
        if (list.size() >= 3 && (class_16572 = FactoryUtil.getClosestPlayer(world, pos, 32.0)) instanceof class_3222) {
            class_3222 player = (class_3222)class_16572;
            TriggerCriterion.trigger((class_3222)player, (class_2960)FactoryTriggers.NIXIE_TUBE_CONNECTED_3_OR_MORE);
        }
    }
}

