/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.electric;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.block.ItemUseLimiter;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.block.data.CableConnectable;
import eu.pb4.polyfactory.block.electric.ElectricMotorBlockEntity;
import eu.pb4.polyfactory.block.electric.EnergyUser;
import eu.pb4.polyfactory.block.mechanical.AxleBlock;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.network.NetworkBlock;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.item.wrench.WrenchAction;
import eu.pb4.polyfactory.item.wrench.WrenchableBlock;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.nodes.electric.EnergyData;
import eu.pb4.polyfactory.nodes.generic.FunctionalDirectionNode;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ElectricMotorBlock
extends NetworkBlock
implements FactoryBlock,
class_2343,
CableConnectable,
RotationUser,
EnergyUser,
WrenchableBlock,
ItemUseLimiter.All {
    public static final class_2753 FACING = class_2741.field_12525;

    public ElectricMotorBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @Override
    protected void updateNetworkAt(class_1936 world, class_2338 pos) {
        NetworkComponent.Rotational.updateRotationalAt(world, pos);
        NetworkComponent.Energy.updateEnergyAt(world, pos);
    }

    @Override
    protected boolean isSameNetworkType(class_2248 block) {
        return block instanceof NetworkComponent.Rotational || block instanceof NetworkComponent.Energy;
    }

    @Override
    public void updateRotationalData(RotationData.State modifier, class_2680 state, class_3218 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ElectricMotorBlockEntity) {
            ElectricMotorBlockEntity be = (ElectricMotorBlockEntity)class_25862;
            be.updateRotationalData(modifier, state, world, pos);
        }
    }

    @Override
    public void updateEnergyData(EnergyData.State modifier, class_2680 state, class_3218 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ElectricMotorBlockEntity) {
            ElectricMotorBlockEntity be = (ElectricMotorBlockEntity)class_25862;
            be.updateEnergyData(modifier, state, world, pos);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)(ctx.method_8036() != null && ctx.method_8036().method_5715() ? ctx.method_8038() : ctx.method_8038().method_10153()));
    }

    public class_2680 getPolymerBlockState(class_2680 state) {
        return class_2246.field_10499.method_9564();
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, class_3222 player) {
        return class_2246.field_10085.method_9564();
    }

    @Override
    public Collection<BlockNode> createRotationalNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new FunctionalDirectionNode((class_2350)state.method_11654((class_2769)FACING)));
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState);
    }

    public boolean tickElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return true;
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        return class_1269.field_5811;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ElectricMotorBlockEntity(pos, state);
    }

    @Override
    public Collection<BlockNode> createEnergyNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new FunctionalDirectionNode(((class_2350)state.method_11654((class_2769)FACING)).method_10153()));
    }

    @Override
    public boolean canCableConnect(class_1936 world, int cableColor, class_2338 pos, class_2680 state, class_2350 dir) {
        return state.method_11654((class_2769)FACING) == dir.method_10153();
    }

    @Override
    public List<WrenchAction> getWrenchActions() {
        return List.of(WrenchAction.FACING);
    }

    public static final class Model
    extends RotationAwareModel {
        private final ItemDisplayElement axle = LodItemDisplayElement.createSimple((class_1799)AxleBlock.Model.ITEM_MODEL_SHORT, (int)this.getUpdateRate(), (float)0.3f, (float)0.6f);
        private final ItemDisplayElement base;

        public Model(class_2680 state) {
            this.base = ItemDisplayElementUtil.createSimple((class_1792)state.method_26204().method_8389());
            this.base.setScale((Vector3fc)new Vector3f(2.0f));
            this.updateStatePos(state);
            this.updateAnimation(0.0f, (class_2350)state.method_11654((class_2769)FACING));
            this.addElement((VirtualElement)this.axle);
            this.addElement((VirtualElement)this.base);
        }

        private void updateAnimation(float speed, class_2350 facing) {
            mat.identity();
            mat.rotate((Quaternionfc)facing.method_10153().method_23224());
            mat.rotateY(facing.method_10171() == class_2350.class_2352.field_11060 ? speed : -speed);
            mat.scale(2.0f);
            this.axle.setTransformation(mat);
        }

        protected void onTick() {
            long tick = this.getAttachment().getWorld().method_8510();
            if (tick % (long)this.getUpdateRate() == 0L) {
                class_2350 facing = (class_2350)this.blockState().method_11654((class_2769)FACING);
                this.updateAnimation(this.getRotation(), facing);
                if (this.axle.isDirty()) {
                    this.axle.startInterpolation();
                }
            }
        }

        private void updateStatePos(class_2680 state) {
            class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
            float p = -90.0f;
            float y = 0.0f;
            if (dir.method_10166() != class_2350.class_2351.field_11052) {
                p = 0.0f;
                y = dir.method_10144();
            } else if (dir == class_2350.field_11033) {
                p = 90.0f;
            }
            this.base.setYaw(y);
            this.base.setPitch(p);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
            }
        }
    }
}

