/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids;

import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.block.ItemUseLimiter;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.fluids.DrainBlockEntity;
import eu.pb4.polyfactory.block.fluids.PipeConnectable;
import eu.pb4.polyfactory.block.other.FilledStateProvider;
import eu.pb4.polyfactory.fluid.FactoryFluids;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.item.FactoryItemTags;
import eu.pb4.polyfactory.mixin.ExperienceOrbEntityAccessor;
import eu.pb4.polyfactory.models.fluid.TopFluidViewModel;
import eu.pb4.polyfactory.recipe.FactoryRecipeTypes;
import eu.pb4.polyfactory.recipe.drain.DrainRecipe;
import eu.pb4.polyfactory.recipe.input.DrainInput;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DrainBlock
extends class_2248
implements FactoryBlock,
PipeConnectable,
class_2343,
ItemUseLimiter.All {
    public DrainBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @Override
    public boolean canPipeConnect(class_1936 world, class_2338 pos, class_2680 state, class_2350 dir) {
        return dir != class_2350.field_11036;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof FilledStateProvider) {
            FilledStateProvider be = (FilledStateProvider)class_25862;
            return (int)(be.getFilledAmount() * 15L / be.getFillCapacity());
        }
        return 0;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1799 stack = player.method_5998(class_1268.field_5808);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof DrainBlockEntity) {
            DrainBlockEntity be = (DrainBlockEntity)class_25862;
            if ((stack.method_7960() || class_1799.method_31577((class_1799)stack, (class_1799)be.catalyst()) && stack.method_7947() < stack.method_7914()) && hit.method_17780() == class_2350.field_11036 && !be.catalyst().method_7960()) {
                if (stack.method_7960()) {
                    player.method_6122(class_1268.field_5808, be.catalyst());
                } else {
                    stack.method_7933(1);
                }
                be.setCatalyst(class_1799.field_8037);
                return class_1269.field_5812;
            }
            if (stack.method_31573(FactoryItemTags.DRAIN_CATALYST) && hit.method_17780() == class_2350.field_11036 && be.catalyst().method_7960()) {
                be.setCatalyst(stack.method_46651(1));
                stack.method_57008(1, (class_1309)player);
                return class_1269.field_5812;
            }
            FluidContainer container = be.getFluidContainer();
            class_1799 copy = stack.method_7972();
            DrainInput input = DrainInput.of(copy, be.catalyst(), container, !(player instanceof FakePlayer));
            Optional optional = world.method_8433().method_8132(FactoryRecipeTypes.DRAIN, (class_9695)input, world);
            if (optional.isEmpty()) {
                return super.method_55766(state, world, pos, player, hit);
            }
            DrainRecipe recipe = (DrainRecipe)((class_8786)optional.get()).comp_1933();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_174.field_44587.method_51350(serverPlayer, ((class_8786)optional.get()).comp_1932(), List.of(stack.method_7972(), be.catalyst()));
                TriggerCriterion.trigger((class_3222)serverPlayer, (class_2960)FactoryTriggers.DRAIN_USE);
            }
            class_1799 itemOut = recipe.method_8116(input, (class_7225.class_7874)player.method_56673());
            for (FluidStack<?> fluid : recipe.fluidInput(input)) {
                container.extract(fluid, false);
            }
            player.method_6122(class_1268.field_5808, FactoryUtil.exchangeStack(stack, recipe.decreasedInputItemAmount(input), player, itemOut));
            for (FluidStack<?> fluid : recipe.fluidOutput(input)) {
                container.insert(fluid, false);
            }
            world.method_45447(null, pos, (class_3414)recipe.soundEvent().comp_349(), class_3419.field_15245);
            return class_1269.field_5812;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof DrainBlockEntity) {
            DrainBlockEntity be = (DrainBlockEntity)class_25862;
            if (entity instanceof class_1303) {
                class_1303 xp = (class_1303)entity;
                if (be.catalyst().method_31573(FactoryItemTags.XP_CONVERSION_CATALYST)) {
                    int amount = xp.method_5919();
                    if (be.getFluidContainer().canInsert(FactoryFluids.EXPERIENCE.defaultInstance(), 500L, true)) {
                        be.getFluidContainer().insert(FactoryFluids.EXPERIENCE.defaultInstance(), 500L, false);
                        if (amount - 1 <= 0) {
                            xp.method_31472();
                        } else {
                            ((ExperienceOrbEntityAccessor)xp).setAmount(amount - 1);
                        }
                    }
                }
            }
        }
        super.method_9591(world, pos, state, entity);
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 class_25862;
        if (!state.method_27852(newState.method_26204()) && (class_25862 = world.method_8321(pos)) instanceof DrainBlockEntity) {
            DrainBlockEntity be = (DrainBlockEntity)class_25862;
            be.onBroken(world, pos);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return DrainBlockEntity::ticker;
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState);
    }

    public boolean tickElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return true;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new DrainBlockEntity(pos, state);
    }

    public class_2680 getPolymerBlockState(class_2680 state) {
        return class_2246.field_10499.method_9564();
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, class_3222 player) {
        return class_2246.field_27119.method_9564();
    }

    public static final class Model
    extends BlockModel {
        private final ItemDisplayElement main;
        private final ItemDisplayElement catalyst;
        private final TopFluidViewModel fluid;

        private Model(class_2680 state) {
            this.main = ItemDisplayElementUtil.createSimple((class_1792)state.method_26204().method_8389());
            this.main.setScale((Vector3fc)new Vector3f(2.0f));
            this.fluid = new TopFluidViewModel((ElementHolder)this, -0.3375f, 0.6875f, 0.5f);
            this.catalyst = ItemDisplayElementUtil.createSimple();
            this.catalyst.setPitch(-90.0f);
            this.catalyst.setTranslation((Vector3fc)new Vector3f(0.0f, 0.0f, 0.28125f));
            this.catalyst.setScale((Vector3fc)new Vector3f(0.75f));
            this.catalyst.setViewRange(0.4f);
            this.addElement((VirtualElement)this.main);
            this.addElement((VirtualElement)this.catalyst);
        }

        public void setFluid(@Nullable FluidInstance<?> type, float position) {
            this.fluid.setFluid(type, position);
        }

        public void setCatalyst(class_1799 catalyst) {
            this.catalyst.setItem(catalyst);
        }
    }
}

