/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids;

import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.polyfactory.block.BlockHeat;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.FluidInputOutput;
import eu.pb4.polyfactory.block.fluids.FluidTankBlock;
import eu.pb4.polyfactory.block.property.ConnectablePart;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerImpl;
import eu.pb4.polyfactory.fluid.FluidContainerUtil;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.component.FluidComponent;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public class FluidTankBlockEntity
extends class_2586
implements FluidInputOutput.ContainerBased,
BlockEntityExtraListener {
    public static final long CAPACITY = 486000L;
    private final FluidContainerImpl container = new FluidContainerImpl(486000L, this::onFluidChanged);
    @Nullable
    private FluidTankBlock.Model model;
    private boolean postInitialRead = false;
    private float blockTemperature = 0.0f;

    public FluidTankBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.FLUID_TANK, pos, state);
    }

    public FluidContainer getFluidContainer() {
        return this.container;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566("fluid", this.container.toNbt(registryLookup));
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.container.fromNbt(registryLookup, nbt, "fluid");
        if (!this.postInitialRead) {
            this.updateModel();
            this.postInitialRead = true;
        }
    }

    protected void method_57568(class_2586.class_9473 components) {
        super.method_57568(components);
        FluidComponent f = (FluidComponent)components.method_58694(FactoryDataComponents.FLUID);
        if (f != null) {
            this.container.clear();
            f.extractTo(this.container);
        }
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(FactoryDataComponents.FLUID, (Object)FluidComponent.copyFrom(this.container));
    }

    public void method_57569(class_2487 nbt) {
        super.method_57569(nbt);
        nbt.method_10551("fluid");
    }

    @Override
    public long insertFluid(FluidInstance<?> type, long amount, class_2350 direction) {
        if (this.field_11863 == null) {
            return FluidInputOutput.ContainerBased.super.insertFluid(type, amount, direction);
        }
        class_2338.class_2339 mut = this.field_11867.method_25503();
        FluidTankBlockEntity tank = this;
        while (amount != 0L) {
            FluidTankBlockEntity tank2;
            class_2586 class_25862;
            amount = tank.container.insert(type, amount, false);
            if (!((ConnectablePart)((Object)tank.method_11010().method_11654(FluidTankBlock.PART_Y))).hasNext() || !((class_25862 = tank.field_11863.method_8321((class_2338)mut.method_10098(class_2350.field_11036))) instanceof FluidTankBlockEntity)) break;
            tank = tank2 = (FluidTankBlockEntity)class_25862;
        }
        return amount;
    }

    @Override
    public FluidContainer getFluidContainer(class_2350 direction) {
        return this.container;
    }

    @Override
    @Nullable
    public FluidContainer getMainFluidContainer() {
        return this.container;
    }

    private void onFluidChanged() {
        this.method_5431();
    }

    private void updateModel() {
        if (this.model != null) {
            this.model.setFluids(this.container);
        }
    }

    public void onListenerUpdate(class_2818 chunk) {
        ElementHolder elementHolder;
        BlockAwareAttachment x = BlockAwareAttachment.get((class_2818)chunk, (class_2338)this.field_11867);
        if (x != null && (elementHolder = x.holder()) instanceof FluidTankBlock.Model) {
            FluidTankBlock.Model model;
            this.model = model = (FluidTankBlock.Model)elementHolder;
        }
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        if (!(t instanceof FluidTankBlockEntity)) {
            return;
        }
        FluidTankBlockEntity tank = (FluidTankBlockEntity)t;
        tank.postInitialRead = true;
        FluidTankBlockEntity.updateVertical(world, tank, pos, state);
        FluidTankBlockEntity.updateHorizontal(world, tank, pos, state);
        FluidTankBlockEntity.updateVertical(world, tank, pos, state);
        ConnectablePart y = (ConnectablePart)((Object)state.method_11654(FluidTankBlock.PART_Y));
        if ((y.single() || y.positive()) && tank.model != null) {
            tank.model.setFluidAbove(null);
        }
        if ((y.single() || y.negative()) && tank.model != null) {
            tank.model.setFluidBelow(null);
        }
        FluidContainerUtil.tick((FluidContainer)tank.container, (class_3218)world, pos, tank.blockTemperature, tank::dropItem);
        tank.updateModel();
    }

    private void dropItem(class_1799 stack) {
        class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.field_11867.method_10263() + 0.5), (double)((double)this.field_11867.method_10264() + 0.5), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)stack);
    }

    private static void updateVertical(class_1937 world, FluidTankBlockEntity tank, class_2338 pos, class_2680 state) {
        class_2586 class_25862;
        ConnectablePart y = (ConnectablePart)((Object)state.method_11654(FluidTankBlock.PART_Y));
        if ((y.middle() || y.positive()) && (class_25862 = world.method_8321(pos.method_10093(class_2350.field_11033))) instanceof FluidTankBlockEntity) {
            FluidInstance<?> ownBottomFluid;
            FluidTankBlockEntity below = (FluidTankBlockEntity)class_25862;
            tank.blockTemperature = below.blockTemperature;
            if (below.container.isNotFull()) {
                while (below.container.isNotFull() && tank.container.isNotEmpty()) {
                    ownBottomFluid = tank.container.bottomFluid();
                    below.container.insert(ownBottomFluid, tank.container.extract(ownBottomFluid, below.container.empty(), false), false);
                }
            }
            if ((ownBottomFluid = tank.container.bottomFluid()) != null) {
                FluidInstance<?> belowTop = below.container.topFluid();
                assert (belowTop != null);
                if (belowTop.density() < ownBottomFluid.density()) {
                    long swappable = Math.min(below.container.get(belowTop), tank.container.get(ownBottomFluid));
                    below.container.extract(belowTop, swappable, false);
                    tank.container.extract(ownBottomFluid, swappable, false);
                    below.container.insert(ownBottomFluid, swappable, false);
                    tank.container.insert(belowTop, swappable, false);
                }
            }
            if (below.model != null) {
                below.model.setFluidAbove(tank.container.bottomFluid());
            }
            if (tank.model != null) {
                tank.model.setFluidBelow(below.container.topFluid());
            }
        } else {
            tank.blockTemperature = BlockHeat.getReceived(world, pos) + tank.container.fluidTemperature();
        }
    }

    private static void updateHorizontal(class_1937 world, FluidTankBlockEntity tank, class_2338 pos, class_2680 state) {
        class_2338.class_2339 p = new class_2338.class_2339();
        ConnectablePart x = (ConnectablePart)((Object)state.method_11654(FluidTankBlock.PART_X));
        ConnectablePart z = (ConnectablePart)((Object)state.method_11654(FluidTankBlock.PART_Z));
        if (!x.single() || !z.single()) {
            FluidTankBlockEntity tank2;
            Object object;
            ArrayList<FluidTankBlockEntity> tanks = new ArrayList<FluidTankBlockEntity>(5);
            tanks.add(tank);
            if ((x.middle() || x.positive()) && (object = world.method_8321((class_2338)p.method_10101((class_2382)pos).method_10100(-1, 0, 0))) instanceof FluidTankBlockEntity) {
                tank2 = (FluidTankBlockEntity)object;
                tanks.add(tank2);
            }
            if ((x.middle() || x.negative()) && (object = world.method_8321((class_2338)p.method_10101((class_2382)pos).method_10100(1, 0, 0))) instanceof FluidTankBlockEntity) {
                tank2 = (FluidTankBlockEntity)object;
                tanks.add(tank2);
            }
            if ((z.middle() || z.positive()) && (object = world.method_8321((class_2338)p.method_10101((class_2382)pos).method_10100(0, 0, -1))) instanceof FluidTankBlockEntity) {
                tank2 = (FluidTankBlockEntity)object;
                tanks.add(tank2);
            }
            if ((z.middle() || z.negative()) && (object = world.method_8321((class_2338)p.method_10101((class_2382)pos).method_10100(0, 0, 1))) instanceof FluidTankBlockEntity) {
                tank2 = (FluidTankBlockEntity)object;
                tanks.add(tank2);
            }
            if (tanks.size() > 1) {
                Object2LongOpenHashMap map = new Object2LongOpenHashMap();
                for (FluidTankBlockEntity tankk : tanks) {
                    tankk.container.forEach((a, b) -> map.put(a, map.getLong(a) + b));
                    tankk.container.clear();
                }
                Object2LongOpenHashMap leftover = new Object2LongOpenHashMap(map.size());
                for (FluidInstance key : map.keySet()) {
                    long val = map.getLong((Object)key);
                    long split = val / (long)tanks.size();
                    map.put((Object)key, split);
                    leftover.put((Object)key, val - split * (long)tanks.size());
                }
                for (FluidTankBlockEntity tankk : tanks) {
                    tankk.container.clear();
                    for (FluidInstance val : map.keySet()) {
                        tankk.container.set(val, map.getLong((Object)val));
                    }
                }
                for (FluidInstance val : leftover.keySet()) {
                    tank.container.insert(val, leftover.getLong((Object)val), false);
                }
            }
        }
    }
}

