/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids;

import eu.pb4.factorytools.api.resourcepack.BaseItemProvider;
import eu.pb4.factorytools.api.util.WorldPointer;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.MDrainBlockEntity;
import eu.pb4.polyfactory.block.fluids.PipeConnectable;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.machines.TallItemMachineBlock;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.models.fluid.TopFluidViewModel;
import eu.pb4.polyfactory.util.movingitem.ContainerHolder;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MDrainBlock
extends TallItemMachineBlock
implements PipeConnectable {
    public MDrainBlock(class_4970.class_2251 settings) {
        super(settings);
        Model.AXLE_MODEL.method_7960();
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, class_3222 player) {
        return class_2246.field_10535.method_9564();
    }

    @Override
    protected class_2586 createSourceBlockEntity(class_2338 pos, class_2680 state) {
        return new MDrainBlockEntity(pos, state);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof MDrainBlockEntity) {
            MDrainBlockEntity be = (MDrainBlockEntity)class_25862;
            return be.getComparatorOutput(state, world, pos);
        }
        return 0;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world instanceof class_3218 && type == FactoryBlockEntities.MECHANICAL_DRAIN ? MDrainBlockEntity::ticker : null;
    }

    @Override
    protected ElementHolder createModel(class_3218 serverWorld, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState);
    }

    @Override
    public boolean pushItemTo(WorldPointer self, class_2350 pushDirection, class_2350 relative, class_2338 conveyorPos, ContainerHolder conveyor) {
        if (((class_2350)self.getBlockState().method_11654(INPUT_FACING)).method_10153() != pushDirection || self.getBlockState().method_11654(PART) == TallItemMachineBlock.Part.TOP) {
            return false;
        }
        MDrainBlockEntity be = (MDrainBlockEntity)self.getBlockEntity();
        for (int i = 0; i < 1; ++i) {
            int count;
            ContainerHolder container = be.getContainerHolder(i);
            if (container.isContainerEmpty()) {
                container.pushAndAttach(conveyor.pullAndRemove());
                return true;
            }
            class_1799 targetStack = container.getContainer().method_32327();
            class_1799 sourceStack = conveyor.getContainer().method_32327();
            if (!class_1799.method_31577((class_1799)container.getContainer().method_32327(), (class_1799)conveyor.getContainer().method_32327()) || (count = Math.min(targetStack.method_7947() + sourceStack.method_7947(), container.getMaxStackCount(sourceStack))) == targetStack.method_7947()) continue;
            int dec = count - targetStack.method_7947();
            targetStack.method_7933(dec);
            sourceStack.method_7934(dec);
            if (sourceStack.method_7960()) {
                conveyor.clearContainer();
            }
            return true;
        }
        return true;
    }

    @Override
    public void getItemFrom(WorldPointer self, class_2350 pushDirection, class_2350 relative, class_2338 conveyorPos, ContainerHolder conveyor) {
        class_2350 inputDir = (class_2350)self.getBlockState().method_11654(INPUT_FACING);
        if (!conveyor.isContainerEmpty() || pushDirection == inputDir || inputDir.method_10153() != relative || self.getBlockState().method_11654(PART) == TallItemMachineBlock.Part.TOP) {
            return;
        }
        MDrainBlockEntity be = (MDrainBlockEntity)self.getBlockEntity();
        ContainerHolder out = be.getContainerHolder(1);
        if (out.isContainerEmpty()) {
            return;
        }
        class_1799 stack = out.getContainer().method_32327();
        int amount = Math.min(stack.method_7947(), out.getMaxStackCount(stack));
        if (stack.method_7947() == amount) {
            conveyor.pushAndAttach(out.pullAndRemove());
        } else {
            stack.method_7934(amount);
            conveyor.setMovementPosition(pushDirection == inputDir.method_10153() ? 0.0 : 0.5);
            conveyor.pushNew(stack.method_46651(amount));
        }
    }

    @Override
    public boolean canPipeConnect(class_1936 world, class_2338 pos, class_2680 state, class_2350 dir) {
        return state.method_11654(PART) == TallItemMachineBlock.Part.MAIN;
    }

    public static final class Model
    extends RotationAwareModel {
        private static final class_1799 BASE_MODEL = BaseItemProvider.requestModel((class_1792)BaseItemProvider.requestItem(), (class_2960)ModInit.id("block/mechanical_drain"));
        private static final class_1799 AXLE_MODEL = BaseItemProvider.requestModel((class_1792)BaseItemProvider.requestItem(), (class_2960)ModInit.id("block/mechanical_drain_axle"));
        private final ItemDisplayElement catalyst;
        private final ItemDisplayElement main;
        private final ItemDisplayElement axle;
        private final TopFluidViewModel fluid = new TopFluidViewModel((ElementHolder)this, -0.3375f, 0.6875f, 0.5f);
        private float rotation;
        private boolean active;

        private Model(class_2680 state) {
            this.main = ItemDisplayElementUtil.createSimple((class_1799)BASE_MODEL);
            this.main.setScale((Vector3fc)new Vector3f(2.0f));
            this.main.setTranslation((Vector3fc)new Vector3f(0.0f, 0.5f, 0.0f));
            this.catalyst = ItemDisplayElementUtil.createSimple();
            this.catalyst.setPitch(-90.0f);
            this.catalyst.setTranslation((Vector3fc)new Vector3f(0.0f, 0.0f, 0.28125f));
            this.catalyst.setScale((Vector3fc)new Vector3f(0.75f));
            this.catalyst.setViewRange(0.4f);
            this.axle = LodItemDisplayElement.createSimple((class_1799)AXLE_MODEL, (int)this.getUpdateRate(), (float)0.3f, (float)0.6f);
            this.axle.setOffset(new class_243(0.0, 1.0, 0.0));
            this.axle.setViewRange(0.6f);
            this.updateStatePos(state);
            class_2350 dir = (class_2350)state.method_11654(TallItemMachineBlock.INPUT_FACING);
            this.updateAnimation(0.0f, dir.method_10170().method_10166());
            this.addElement((VirtualElement)this.main);
            this.addElement((VirtualElement)this.axle);
            this.addElement((VirtualElement)this.catalyst);
        }

        private void updateStatePos(class_2680 state) {
            class_2350 direction = (class_2350)state.method_11654(TallItemMachineBlock.INPUT_FACING);
            this.main.setYaw(direction.method_10144());
        }

        private void updateAnimation(float rotation, class_2350.class_2351 axis) {
            Matrix4f mat = Model.mat();
            switch (axis) {
                case field_11048: {
                    mat.rotate((Quaternionfc)class_2350.field_11034.method_23224());
                    break;
                }
                case field_11051: {
                    mat.rotate((Quaternionfc)class_2350.field_11035.method_23224());
                }
            }
            mat.rotateY(rotation);
            mat.scale(2.0f);
            this.axle.setTransformation(mat);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
            }
        }

        protected void onTick() {
            long tick = this.getAttachment().getWorld().method_8510();
            if (tick % (long)this.getUpdateRate() == 0L) {
                class_2350 dir = (class_2350)this.blockState().method_11654(TallItemMachineBlock.INPUT_FACING);
                this.updateAnimation(RotationUser.getRotation((class_1937)this.getAttachment().getWorld(), this.blockPos().method_10084()).rotation(), dir.method_10170().method_10166());
                if (this.axle.isDirty()) {
                    this.axle.startInterpolation();
                }
            }
        }

        public void setFluid(@Nullable FluidInstance<?> type, float position) {
            this.fluid.setFluid(type, position);
        }

        public void rotate(float speed) {
            this.rotation += speed * ((float)Math.PI / 180) * 2.0f;
            if (this.rotation > (float)Math.PI * 2) {
                this.rotation -= (float)Math.PI * 2;
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setCatalyst(class_1799 catalyst) {
            this.catalyst.setItem(catalyst);
        }
    }
}

