/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.block.BarrierBasedWaterloggable;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.block.fluids.NozzleBlockEntity;
import eu.pb4.polyfactory.block.fluids.PipeConnectable;
import eu.pb4.polyfactory.block.network.NetworkBlock;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.block.other.FilledStateProvider;
import eu.pb4.polyfactory.item.wrench.WrenchAction;
import eu.pb4.polyfactory.item.wrench.WrenchableBlock;
import eu.pb4.polyfactory.nodes.pipe.NozzleNode;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class NozzleBlock
extends NetworkBlock
implements FactoryBlock,
WrenchableBlock,
PipeConnectable,
BarrierBasedWaterloggable,
class_2343,
NetworkComponent.Pipe {
    public static final class_2753 FACING = class_2741.field_12525;
    public static final WrenchAction SPREAD = WrenchAction.ofBlockEntityString("spread", NozzleBlockEntity.class, x -> String.format(Locale.ROOT, "%.2f", Float.valueOf(x.extraSpread())), (x, n) -> x.setExtraSpread(FactoryUtil.wrap(x.extraSpread() + (n != false ? 0.05f : -0.05f), 0.0f, 0.8f)));

    public NozzleBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return this.waterLog(ctx, (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8038()));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED});
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof FilledStateProvider) {
            FilledStateProvider be = (FilledStateProvider)class_25862;
            return (int)(be.getFilledAmount() * 15L / be.getFillCapacity());
        }
        return 0;
    }

    @Override
    protected void updateNetworkAt(class_1936 world, class_2338 pos) {
        NetworkComponent.Pipe.updatePipeAt(world, pos);
    }

    @Override
    protected boolean isSameNetworkType(class_2248 block) {
        return block instanceof NetworkComponent.Pipe;
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (placer instanceof class_1657) {
            class_1657 player = (class_1657)placer;
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof NozzleBlockEntity) {
                NozzleBlockEntity be = (NozzleBlockEntity)class_25862;
                be.setOwner(player.method_7334());
            }
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        this.tickWater(state, world, pos);
        return state;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2470)rotation).method_10503(arg_0), FACING);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2415)mirror).method_10343(arg_0), FACING);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public boolean canPipeConnect(class_1936 world, class_2338 pos, class_2680 state, class_2350 dir) {
        return dir == ((class_2350)state.method_11654((class_2769)FACING)).method_10153();
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new NozzleBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return NozzleBlockEntity::tick;
    }

    @Override
    public Collection<BlockNode> createPipeNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new NozzleNode(((class_2350)state.method_11654((class_2769)FACING)).method_10153()));
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, class_3222 player) {
        return class_2246.field_27119.method_9564();
    }

    @Override
    public List<WrenchAction> getWrenchActions() {
        return List.of(WrenchAction.FACING, SPREAD);
    }

    public static final class Model
    extends BlockModel {
        private final ItemDisplayElement main;

        private Model(class_2680 state) {
            this.main = ItemDisplayElementUtil.createSimple((class_1792)state.method_26204().method_8389());
            this.main.setScale((Vector3fc)new Vector3f(2.0f));
            this.updateStatePos(state);
            this.addElement((VirtualElement)this.main);
        }

        private void updateStatePos(class_2680 state) {
            class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
            float p = -90.0f;
            float y = 0.0f;
            if (dir.method_10166() != class_2350.class_2351.field_11052) {
                p = 0.0f;
                y = dir.method_10144();
            } else if (dir == class_2350.field_11033) {
                p = 90.0f;
            }
            this.main.setYaw(y);
            this.main.setPitch(p);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
                this.tick();
            }
        }
    }
}

