/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids;

import com.mojang.authlib.GameProfile;
import eu.pb4.factorytools.api.block.OwnedBlockEntity;
import eu.pb4.factorytools.api.util.LegacyNbtHelper;
import eu.pb4.polyfactory.advancement.FluidShootsCriterion;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.FluidInput;
import eu.pb4.polyfactory.block.fluids.NozzleBlock;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerImpl;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.shooting.ShooterContext;
import eu.pb4.polyfactory.util.FactoryUtil;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.Nullable;

public class NozzleBlockEntity
extends class_2586
implements FluidInput.ContainerBased,
ShooterContext,
OwnedBlockEntity {
    protected final FluidContainerImpl container = new FluidContainerImpl(121500L, () -> ((NozzleBlockEntity)this).method_5431());
    private double speed;
    @Nullable
    private FluidInstance<?> currentFluid;
    private GameProfile owner;
    private int tick = 0;
    private float extraSpread = 0.0f;

    public NozzleBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.NOZZLE, pos, state);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10549("speed", this.speed);
        nbt.method_10569("tick", this.tick);
        nbt.method_10566("fluid", this.container.toNbt(registryLookup));
        nbt.method_10548("spread", this.extraSpread);
        if (this.currentFluid != null) {
            nbt.method_10566("current_fluid", this.currentFluid.toNbt(registryLookup));
        }
        if (this.owner != null) {
            nbt.method_10566("owner", (class_2520)LegacyNbtHelper.writeGameProfile((class_2487)new class_2487(), (GameProfile)this.owner));
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.speed = nbt.method_10574("speed");
        this.tick = nbt.method_10550("tick");
        this.container.fromNbt(registryLookup, nbt, "fluid");
        this.currentFluid = FluidInstance.fromNbt(registryLookup, nbt.method_10580("current_fluid"));
        this.extraSpread = nbt.method_10583("spread");
        this.owner = LegacyNbtHelper.toGameProfile((class_2487)nbt.method_10562("owner"));
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        if (!(t instanceof NozzleBlockEntity)) {
            return;
        }
        NozzleBlockEntity nozzle = (NozzleBlockEntity)t;
        if (!nozzle.world().method_14178().field_17254.method_17263().method_38630(class_1923.method_37232((class_2338)pos))) {
            return;
        }
        if (nozzle.container.isEmpty()) {
            nozzle.stopShooting();
            if (nozzle.speed != 0.0) {
                nozzle.speed = 0.0;
                nozzle.method_5431();
            }
            return;
        }
        MutableDouble num = new MutableDouble();
        class_2350 goodDir = (class_2350)nozzle.method_11010().method_11654((class_2769)NozzleBlock.FACING);
        NetworkComponent.Pipe.getLogic((class_3218)world, pos).runPushFlows(pos, () -> true, (dir, strength) -> {
            if (dir == goodDir) {
                num.add(strength);
            } else {
                num.subtract(strength);
            }
        });
        double strength2 = num.doubleValue();
        if (strength2 <= 0.01) {
            nozzle.speed = 0.0;
            nozzle.stopShooting();
            return;
        }
        if (nozzle.speed != strength2) {
            nozzle.speed = strength2;
            nozzle.method_5431();
        }
        if (nozzle.currentFluid != null) {
            FluidInstance<?> fluid = nozzle.currentFluid;
            if (fluid.shootingBehavior().canShoot(nozzle, fluid, nozzle.container)) {
                fluid.shootingBehavior().continueShooting(nozzle, fluid, nozzle.tick++, nozzle.container);
                nozzle.method_5431();
                return;
            }
            nozzle.stopShooting();
        }
        for (FluidInstance<?> f : nozzle.container.fluids()) {
            FluidInstance<?> fluid = f;
            if (!fluid.shootingBehavior().canShoot(nozzle, fluid, nozzle.container)) continue;
            nozzle.currentFluid = fluid;
            nozzle.tick = 0;
            fluid.shootingBehavior().startShooting(nozzle, fluid, nozzle.container);
            class_1657 class_16572 = FactoryUtil.getClosestPlayer(world, pos, 32.0);
            if (class_16572 instanceof class_3222) {
                class_3222 player = (class_3222)class_16572;
                FluidShootsCriterion.triggerNozzle(player, fluid);
            }
            nozzle.method_5431();
            break;
        }
    }

    private void stopShooting() {
        if (this.currentFluid == null) {
            return;
        }
        FluidInstance<?> fluid = this.currentFluid;
        fluid.shootingBehavior().stopShooting(this, fluid);
        this.tick = 0;
        this.currentFluid = null;
        this.method_5431();
    }

    @Override
    @Nullable
    public FluidContainer getFluidContainer(class_2350 direction) {
        return direction == ((class_2350)this.method_11010().method_11654((class_2769)NozzleBlock.FACING)).method_10153() ? this.getMainFluidContainer() : null;
    }

    @Override
    @Nullable
    public FluidContainer getMainFluidContainer() {
        return this.container;
    }

    @Override
    public class_5819 random() {
        return this.field_11863.field_9229;
    }

    @Override
    public class_3218 world() {
        return (class_3218)this.field_11863;
    }

    @Override
    public UUID uuid() {
        return this.owner != null ? this.owner.getId() : class_156.field_25140;
    }

    @Override
    public class_243 position() {
        return class_243.method_24953((class_2382)this.field_11867).method_43206((class_2350)this.method_11010().method_11654((class_2769)NozzleBlock.FACING), 0.75);
    }

    @Override
    public class_243 rotation() {
        return new class_243(((class_2350)this.method_11010().method_11654((class_2769)NozzleBlock.FACING)).method_23955());
    }

    @Override
    public class_3419 soundCategory() {
        return class_3419.field_15245;
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public float extraSpread() {
        return this.extraSpread;
    }

    public void setExtraSpread(float extraSpread) {
        this.extraSpread = extraSpread;
        this.method_5431();
    }

    public void setOwner(GameProfile profile) {
        this.owner = profile;
        this.method_5431();
    }

    @Override
    public float force() {
        return (float)class_3532.method_15350((double)(this.speed * 10.0), (double)0.4, (double)1.0);
    }
}

