/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids;

import eu.pb4.polyfactory.block.fluids.PipeBaseBlock;
import eu.pb4.polyfactory.block.fluids.PipeBlockEntity;
import eu.pb4.polyfactory.block.fluids.PipeConnectable;
import eu.pb4.polyfactory.block.fluids.PipeInWallBlock;
import eu.pb4.polyfactory.block.property.FactoryProperties;
import eu.pb4.polyfactory.block.property.LazyEnumProperty;
import eu.pb4.polyfactory.fluid.FluidContainerImpl;
import eu.pb4.polyfactory.item.wrench.WrenchAction;
import eu.pb4.polyfactory.item.wrench.WrenchableBlock;
import eu.pb4.polyfactory.util.FactoryUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2544;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class PipeBlock
extends PipeBaseBlock
implements WrenchableBlock {
    public static final class_2746 LOCKED = FactoryProperties.LOCKED;
    public static final LazyEnumProperty<TriState> NORTH = FactoryProperties.TRI_STATE_NORTH;
    public static final LazyEnumProperty<TriState> SOUTH = FactoryProperties.TRI_STATE_SOUTH;
    public static final LazyEnumProperty<TriState> EAST = FactoryProperties.TRI_STATE_EAST;
    public static final LazyEnumProperty<TriState> WEST = FactoryProperties.TRI_STATE_WEST;
    public static final LazyEnumProperty<TriState> UP = FactoryProperties.TRI_STATE_UP;
    public static final LazyEnumProperty<TriState> DOWN = FactoryProperties.TRI_STATE_DOWN;
    private static final List<WrenchAction> WRENCH_ACTIONS = List.of(WrenchAction.of("locked", LOCKED));
    public static final Map<class_2350, LazyEnumProperty<TriState>> FACING_PROPERTIES = FactoryProperties.TRI_STATE_DIRECTIONS;

    public PipeBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(false))).method_11657(NORTH, (Comparable)TriState.FALSE)).method_11657(SOUTH, (Comparable)TriState.FALSE)).method_11657(EAST, (Comparable)TriState.FALSE)).method_11657(WEST, (Comparable)TriState.FALSE)).method_11657(UP, (Comparable)TriState.FALSE)).method_11657(DOWN, (Comparable)TriState.FALSE));
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = this.method_9564();
        int i = 0;
        class_2350 lastDir = null;
        for (class_2350 direction : class_2350.values()) {
            class_2338 neighborPos = ctx.method_8037().method_10093(direction);
            if (!this.canConnectTo((class_1936)ctx.method_8045(), neighborPos, ctx.method_8045().method_8320(neighborPos), direction.method_10153())) continue;
            state = (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(direction), (Comparable)TriState.TRUE);
            ++i;
            lastDir = direction;
        }
        if (i == 0) {
            state = (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(ctx.method_8038()), (Comparable)TriState.DEFAULT);
            state = (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(ctx.method_8038().method_10153()), (Comparable)TriState.DEFAULT);
        } else if (i == 1) {
            state = (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(lastDir.method_10153()), (Comparable)TriState.DEFAULT);
        }
        return this.waterLog(ctx, state);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LOCKED, NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        this.tickWater(state, world, pos);
        if (((Boolean)state.method_11654((class_2769)LOCKED)).booleanValue()) {
            return state;
        }
        int i = 0;
        class_2350 lastKnown = null;
        state = (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(direction), (Comparable)TriState.of((boolean)this.canConnectTo(world, neighborPos, neighborState, direction.method_10153())));
        for (class_2350 dir : class_2350.values()) {
            if (((TriState)state.method_11654((class_2769)FACING_PROPERTIES.get(dir))).orElse(false)) {
                ++i;
                lastKnown = dir;
                continue;
            }
            state = (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(dir), (Comparable)TriState.FALSE);
        }
        if (i == 0) {
            state = (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(direction), (Comparable)TriState.DEFAULT);
            state = (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(direction.method_10153()), (Comparable)TriState.DEFAULT);
        } else if (i == 1) {
            state = (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(lastKnown.method_10153()), (Comparable)TriState.DEFAULT);
        }
        return state;
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2544 wallBlock;
        PipeInWallBlock convert;
        class_1747 blockItem;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747 && (class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_2544 && (convert = PipeInWallBlock.MAP.get(wallBlock = (class_2544)class_17922)) != null) {
            FluidContainerImpl fluidContainerImpl;
            PipeBlockEntity be;
            stack.method_57008(1, (class_1309)player);
            class_2680 convertState = Objects.requireNonNull(convert.method_9605(new class_1750(world, player, hand, stack, hit)));
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof PipeBlockEntity) {
                be = (PipeBlockEntity)class_25862;
                fluidContainerImpl = be.container;
            } else {
                fluidContainerImpl = null;
            }
            FluidContainerImpl container = fluidContainerImpl;
            world.method_8501(pos, convertState);
            if (container != null && (class_25862 = world.method_8321(pos)) instanceof PipeBlockEntity) {
                be = (PipeBlockEntity)class_25862;
                container.forEach(be.container::set);
            }
            return class_9062.field_47728;
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    protected boolean canConnectTo(class_1936 world, class_2338 neighborPos, class_2680 neighborState, class_2350 direction) {
        PipeConnectable connectable;
        class_2248 class_22482 = neighborState.method_26204();
        return class_22482 instanceof PipeConnectable && (connectable = (PipeConnectable)class_22482).canPipeConnect(world, neighborPos, neighborState, direction);
    }

    @Override
    public EnumSet<class_2350> getFlowDirections(class_2680 state) {
        ArrayList<class_2350> list = new ArrayList<class_2350>(6);
        for (class_2350 dir : class_2350.values()) {
            if (!((TriState)state.method_11654((class_2769)FACING_PROPERTIES.get(dir))).orElse(true)) continue;
            list.add(dir);
        }
        return list.isEmpty() ? EnumSet.noneOf(class_2350.class) : EnumSet.copyOf(list);
    }

    @Override
    public boolean canPipeConnect(class_1936 world, class_2338 pos, class_2680 state, class_2350 dir) {
        return (Boolean)state.method_11654((class_2769)LOCKED) == false || super.canPipeConnect(world, pos, state, dir);
    }

    @Override
    public boolean checkModelDirection(class_2680 state, class_2350 direction) {
        return ((TriState)state.method_11654((class_2769)FACING_PROPERTIES.get(direction))).orElse(true);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.rotate(state, NORTH, SOUTH, EAST, WEST, rotation);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return FactoryUtil.mirror(state, NORTH, SOUTH, EAST, WEST, mirror);
    }

    @Override
    public List<WrenchAction> getWrenchActions() {
        return WRENCH_ACTIONS;
    }
}

