/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids;

import eu.pb4.polyfactory.block.fluids.FluidInput;
import eu.pb4.polyfactory.block.fluids.FluidOutput;
import eu.pb4.polyfactory.fluid.FactoryFluids;
import eu.pb4.polyfactory.fluid.FluidBehaviours;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerImpl;
import eu.pb4.polyfactory.fluid.FluidContainerUtil;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.component.FluidComponent;
import eu.pb4.polyfactory.util.DebugTextProvider;
import java.util.List;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_3902;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public abstract class PipeLikeBlockEntity
extends class_2586
implements FluidInput.ContainerBased,
DebugTextProvider {
    protected final FluidContainerImpl container = this.createContainer();
    protected final class_2338.class_2339 mut = new class_2338.class_2339();
    protected final double[] pullOverflow = new double[class_2350.values().length];
    protected class_2680[] pullState = new class_2680[this.pullOverflow.length];
    protected final double[] pushOverflow = new double[class_2350.values().length];
    protected class_2680[] pushState = new class_2680[this.pushOverflow.length];
    protected long maxPush = 0L;
    private final int[] particleCounter = new int[]{1, 3, 5, 6, 8, 4};

    public PipeLikeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public FluidContainer getFluidContainer() {
        return this.container;
    }

    @Override
    @Nullable
    public FluidContainer getMainFluidContainer() {
        return this.container;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566("fluid", this.container.toNbt(registryLookup));
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.container.fromNbt(registryLookup, nbt, "fluid");
        this.maxPush = this.container.stored();
    }

    protected void method_57568(class_2586.class_9473 components) {
        super.method_57568(components);
        FluidComponent f = (FluidComponent)components.method_58694(FactoryDataComponents.FLUID);
        if (f != null) {
            f.copyTo(this.container);
        }
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(FactoryDataComponents.FLUID, (Object)FluidComponent.copyFrom(this.container));
    }

    public void method_57569(class_2487 nbt) {
        super.method_57569(nbt);
        nbt.method_10551("fluid");
    }

    public void preTick() {
        FluidContainerUtil.tick((FluidContainer)this.container, (class_3218)this.field_11863, this.field_11867, this.container.fluidTemperature(), this::dropItem);
        for (int i = 0; i < this.pullOverflow.length; ++i) {
            this.pullOverflow[i] = Math.max(0.0, this.pullOverflow[i] - 0.01);
            this.pushOverflow[i] = Math.max(0.0, this.pushOverflow[i] - 0.01);
        }
    }

    private void dropItem(class_1799 stack) {
        class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.field_11867.method_10263() + 0.5), (double)((double)this.field_11867.method_10264() + 0.5), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)stack);
    }

    public void postTick() {
        this.maxPush = this.container.stored();
    }

    public void pushFluid(class_2350 direction, double strength) {
        FluidInstance<?> fluid;
        this.mut.method_10101((class_2382)this.field_11867).method_10098(direction);
        class_2680 pushedBlockState = this.field_11863.method_8320((class_2338)this.mut);
        FluidInput fluidInput = null;
        class_2248 class_22482 = pushedBlockState.method_26204();
        if (class_22482 instanceof FluidInput.Getter) {
            FluidInput.Getter getter = (FluidInput.Getter)class_22482;
            fluidInput = getter.getFluidInput((class_3218)this.field_11863, (class_2338)this.mut, direction.method_10153());
        } else {
            class_22482 = this.field_11863.method_8321((class_2338)this.mut);
            if (class_22482 instanceof FluidInput) {
                FluidInput f;
                fluidInput = f = (FluidInput)class_22482;
            }
        }
        if (fluidInput != null) {
            fluid = this.container.topFluid();
            if (fluid != null) {
                long maxFlow = fluid.getMaxFlow((class_3218)this.field_11863);
                long amount = Math.min(Math.min((long)(strength * (double)maxFlow * fluid.getFlowSpeedMultiplier((class_3218)this.field_11863)), maxFlow), this.maxPush);
                long extracted = this.container.extract(fluid, amount, false);
                long leftover = fluidInput.insertFluid(fluid, extracted, direction.method_10153());
                if (leftover != 0L) {
                    this.container.insert(fluid, leftover, false);
                }
                this.maxPush -= extracted - leftover;
                this.pushOverflow[direction.ordinal()] = 0.0;
            }
            return;
        }
        fluid = this.container.topFluid();
        if (pushedBlockState.method_26215() && fluid != null && fluid.type() == FactoryFluids.EXPERIENCE && this.container.get(fluid) >= 500L && this.field_11863.field_9229.method_43056()) {
            int max = (int)Math.min(this.container.get(fluid) / 500L, 30L);
            int amount = max <= 1 ? 1 : this.field_11863.field_9229.method_39332(1, max);
            this.container.extract(fluid, (long)amount * 500L, false);
            class_1303 x = new class_1303(this.field_11863, (double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.7, (double)this.field_11867.method_10264() + 0.5 + (double)direction.method_10164() * 0.7, (double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.7, amount);
            this.field_11863.method_8649((class_1297)x);
        }
        if (pushedBlockState.method_26215()) {
            class_2394 particle;
            int n = direction.ordinal();
            int n2 = this.particleCounter[n];
            this.particleCounter[n] = n2 + 1;
            if (n2 % 3 == 0 && fluid != null && (particle = fluid.particle()) != null) {
                ((class_3218)this.field_11863).method_14199(particle, (double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.55, (double)this.field_11867.method_10264() + 0.5 + (double)direction.method_10164() * 0.55, (double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.55, 0, (double)direction.method_10148() * 0.1, (double)direction.method_10164() * 0.1, (double)direction.method_10165() * 0.1, 0.4);
            }
        }
        if (pushedBlockState == this.pushState[direction.ordinal()]) {
            List<class_3545<FluidStack<?>, class_2680>> possibilities = FluidBehaviours.BLOCK_STATE_TO_FLUID_INSERT.get(pushedBlockState);
            if (possibilities != null) {
                for (class_3545<FluidStack<?>, class_2680> insert : possibilities) {
                    if (insert == null || !this.container.canExtract((FluidStack)insert.method_15442(), true)) continue;
                    long maxFlow = ((FluidStack)insert.method_15442()).instance().getMaxFlow((class_3218)this.field_11863);
                    long amount = Math.min(Math.min((long)(strength * (double)maxFlow * ((FluidStack)insert.method_15442()).instance().getFlowSpeedMultiplier((class_3218)this.field_11863)), maxFlow), this.maxPush);
                    int n = direction.ordinal();
                    this.pushOverflow[n] = this.pushOverflow[n] + (double)amount;
                    if (!(this.pushOverflow[direction.ordinal()] >= (double)((FluidStack)insert.method_15442()).amount())) continue;
                    this.field_11863.method_8501((class_2338)this.mut, (class_2680)insert.method_15441());
                    this.container.extract((FluidStack)insert.method_15442(), false);
                    this.pushOverflow[direction.ordinal()] = 0.0;
                    break;
                }
            }
        } else {
            this.pushState[direction.ordinal()] = pushedBlockState;
            this.pushOverflow[direction.ordinal()] = 0.0;
        }
    }

    public void pullFluid(class_2350 direction, double strength) {
        this.mut.method_10101((class_2382)this.field_11867).method_10098(direction);
        class_2680 pulledBlockState = this.field_11863.method_8320((class_2338)this.mut);
        FluidInstance<?> currentFluid = this.container.topFluid();
        FluidOutput fluidOutput = null;
        class_2248 class_22482 = pulledBlockState.method_26204();
        if (class_22482 instanceof FluidOutput.Getter) {
            FluidOutput.Getter getter = (FluidOutput.Getter)class_22482;
            fluidOutput = getter.getFluidOutput((class_3218)this.field_11863, (class_2338)this.mut, direction.method_10153());
        } else {
            class_22482 = this.field_11863.method_8321((class_2338)this.mut);
            if (class_22482 instanceof FluidOutput) {
                FluidOutput fluidOutput2;
                fluidOutput = fluidOutput2 = (FluidOutput)class_22482;
            }
        }
        if (fluidOutput != null) {
            for (FluidInstance fluidInstance : fluidOutput.getContainedFluids(direction.method_10153())) {
                long leftover;
                long maxFlow;
                long amount;
                long extracted;
                if (fluidInstance == null || currentFluid != null && !currentFluid.equals(fluidInstance) || (extracted = fluidOutput.extractFluid(fluidInstance, amount = Math.min(Math.min((long)(strength * (double)(maxFlow = fluidInstance.getMaxFlow((class_3218)this.field_11863)) * fluidInstance.getFlowSpeedMultiplier((class_3218)this.field_11863)), maxFlow), this.container.empty()), direction.method_10153(), false)) == (leftover = this.container.insert(fluidInstance, extracted, false))) continue;
                fluidOutput.extractFluid(fluidInstance, extracted - leftover, direction.method_10153(), true);
                return;
            }
            return;
        }
        if (pulledBlockState == this.pullState[direction.ordinal()]) {
            class_3545<FluidStack<class_3902>, class_2680> extract = FluidBehaviours.BLOCK_STATE_TO_FLUID_EXTRACT.get(pulledBlockState);
            if (extract != null && this.container.canInsert((FluidStack)extract.method_15442(), true)) {
                long l = ((FluidStack)extract.method_15442()).instance().getMaxFlow((class_3218)this.field_11863);
                long amount = Math.min(Math.min((long)(strength * (double)l * ((FluidStack)extract.method_15442()).instance().getFlowSpeedMultiplier((class_3218)this.field_11863)), l), this.container.empty());
                int n = direction.ordinal();
                this.pullOverflow[n] = this.pullOverflow[n] + (double)amount;
                if (this.pullOverflow[direction.ordinal()] >= (double)((FluidStack)extract.method_15442()).amount()) {
                    this.field_11863.method_8501((class_2338)this.mut, (class_2680)extract.method_15441());
                    this.container.insert((FluidStack)extract.method_15442(), false);
                    this.pullOverflow[direction.ordinal()] = 0.0;
                }
            }
        } else {
            this.pullState[direction.ordinal()] = pulledBlockState;
            this.pullOverflow[direction.ordinal()] = 0.0;
        }
    }

    protected FluidContainerImpl createContainer() {
        return FluidContainerImpl.singleFluid(81000L, () -> ((PipeLikeBlockEntity)this).method_5431());
    }

    @Override
    public class_2561 getDebugText() {
        return class_2561.method_43470((String)("F: " + this.container.getFilledPercentage()));
    }

    @Override
    public FluidContainer getFluidContainer(class_2350 direction) {
        return this.hasDirection(direction) ? this.container : null;
    }

    protected abstract boolean hasDirection(class_2350 var1);
}

