/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.block.BarrierBasedWaterloggable;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.resourcepack.BaseItemProvider;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.block.fluids.PipeConnectable;
import eu.pb4.polyfactory.block.fluids.PumpBlockEntity;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.network.NetworkBlock;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.block.other.FilledStateProvider;
import eu.pb4.polyfactory.item.wrench.WrenchAction;
import eu.pb4.polyfactory.item.wrench.WrenchableBlock;
import eu.pb4.polyfactory.models.GenericParts;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.nodes.mechanical.UnconnectedGearMechanicalNode;
import eu.pb4.polyfactory.nodes.mechanical_connectors.SmallGearNode;
import eu.pb4.polyfactory.nodes.pipe.PumpNode;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PumpBlock
extends NetworkBlock
implements FactoryBlock,
RotationUser,
WrenchableBlock,
PipeConnectable,
BarrierBasedWaterloggable,
class_2343,
NetworkComponent.Pipe,
NetworkComponent.Rotational,
NetworkComponent.RotationalConnector {
    public static final class_2753 FACING = class_2741.field_12525;

    public PumpBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof FilledStateProvider) {
            FilledStateProvider be = (FilledStateProvider)class_25862;
            return (int)(be.getFilledAmount() * 15L / be.getFillCapacity());
        }
        return 0;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return this.waterLog(ctx, (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8038().method_10153()));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED});
    }

    @Override
    protected void updateNetworkAt(class_1936 world, class_2338 pos) {
        NetworkComponent.Pipe.updatePipeAt(world, pos);
        NetworkComponent.RotationalConnector.updateRotationalConnectorAt(world, pos);
        NetworkComponent.Rotational.updateRotationalAt(world, pos);
    }

    @Override
    protected boolean isSameNetworkType(class_2248 block) {
        return block instanceof NetworkComponent.Pipe || block instanceof NetworkComponent.RotationalConnector || block instanceof NetworkComponent.Rotational;
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        this.tickWater(state, world, pos);
        return state;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2470)rotation).method_10503(arg_0), FACING);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2415)mirror).method_10343(arg_0), FACING);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public boolean canPipeConnect(class_1936 world, class_2338 pos, class_2680 state, class_2350 dir) {
        return dir.method_10166() == ((class_2350)state.method_11654((class_2769)FACING)).method_10166();
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState, pos);
    }

    public boolean tickElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return true;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PumpBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return PumpBlockEntity::tick;
    }

    @Override
    public Collection<BlockNode> createPipeNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new PumpNode((class_2350)state.method_11654((class_2769)FACING), false, 32), new PumpNode((class_2350)state.method_11654((class_2769)FACING), true, 32));
    }

    @Override
    public Collection<BlockNode> createRotationalNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new UnconnectedGearMechanicalNode());
    }

    @Override
    public Collection<BlockNode> createRotationalConnectorNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new SmallGearNode(((class_2350)state.method_11654((class_2769)FACING)).method_10166()));
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, class_3222 player) {
        return class_2246.field_27119.method_9564();
    }

    @Override
    public List<WrenchAction> getWrenchActions() {
        return List.of(WrenchAction.FACING);
    }

    @Override
    public void updateRotationalData(RotationData.State modifier, class_2680 state, class_3218 world, class_2338 pos) {
        modifier.stress(5.0);
    }

    public static final class Model
    extends RotationAwareModel {
        public static final class_1799 BLOCK_MODEL = BaseItemProvider.requestModel((class_2960)ModInit.id("block/pump"));
        private final ItemDisplayElement mainElement;
        private final ItemDisplayElement gear;
        private final boolean offset;
        private class_2350.class_2351 axis = class_2350.class_2351.field_11052;

        private Model(class_2680 state, class_2338 pos) {
            this.mainElement = ItemDisplayElementUtil.createSimple((class_1799)BLOCK_MODEL);
            this.mainElement.setScale((Vector3fc)new Vector3f(2.0f));
            this.offset = (pos.method_10263() + pos.method_10264() + pos.method_10260()) % 2 == 0;
            this.gear = LodItemDisplayElement.createSimple((class_1799)GenericParts.REGULAR_GEAR, (int)this.getUpdateRate(), (float)0.3f, (float)0.6f);
            this.gear.setViewRange(0.7f);
            this.updateStatePos(state);
            this.updateAnimation(0.0f);
            this.addElement((VirtualElement)this.mainElement);
            this.addElement((VirtualElement)this.gear);
        }

        private void updateStatePos(class_2680 state) {
            class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
            this.axis = dir.method_10166();
            float p = -90.0f;
            float y = 0.0f;
            if (dir.method_10166() != class_2350.class_2351.field_11052) {
                p = 0.0f;
                y = dir.method_10144();
            } else if (dir == class_2350.field_11033) {
                p = 90.0f;
            }
            this.mainElement.setYaw(y);
            this.mainElement.setPitch(p);
        }

        private void updateAnimation(float rotation) {
            Matrix4f mat = Model.mat();
            switch (this.axis) {
                case field_11048: {
                    mat.rotate((Quaternionfc)class_2350.field_11034.method_23224());
                    break;
                }
                case field_11051: {
                    mat.rotate((Quaternionfc)class_2350.field_11035.method_23224());
                }
            }
            mat.rotateY(rotation + (this.offset ? 0.3926991f : 0.0f));
            this.gear.setTransformation(mat);
        }

        protected void onTick() {
            long tick = this.getAttachment().getWorld().method_8510();
            if (tick % (long)this.getUpdateRate() == 0L) {
                this.updateAnimation(this.getRotationData().rotation());
                if (this.gear.isDirty()) {
                    this.gear.startInterpolation();
                }
            }
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
            }
        }
    }
}

