/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.block.BarrierBasedWaterloggable;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.item.AutoModeledPolymerItem;
import eu.pb4.factorytools.api.resourcepack.BaseItemProvider;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.block.mechanical.RotationalNetworkBlock;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.wrench.WrenchAction;
import eu.pb4.polyfactory.item.wrench.WrenchableBlock;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.nodes.generic.SimpleAxisNode;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.core.impl.networking.PolymerServerProtocol;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5554;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class AxleBlock
extends RotationalNetworkBlock
implements FactoryBlock,
WrenchableBlock,
BarrierBasedWaterloggable {
    public static final class_2769<class_2350.class_2351> AXIS = class_2741.field_12496;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;

    public AxleBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AXIS}).method_11667(new class_2769[]{WATERLOGGED});
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        this.tickWater(state, world, pos);
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return this.waterLog(ctx, (class_2680)super.method_9605(ctx).method_11657(AXIS, (Comparable)ctx.method_8038().method_10166()));
    }

    @Override
    public Collection<BlockNode> createRotationalNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new SimpleAxisNode((class_2350.class_2351)state.method_11654(AXIS)));
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, class_3222 player) {
        return class_2246.field_10519.method_9564();
    }

    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(world, initialBlockState);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return ((class_2680)class_2246.field_27171.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)state.method_11654(AXIS)), (class_2350.class_2352)class_2350.class_2352.field_11056))).method_26194(world, pos, context);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.rotateAxis(state, AXIS, rotation);
    }

    public void onPolymerBlockSend(class_2680 blockState, class_2338.class_2339 pos, class_3222 player) {
        if (pos.method_10268(player.method_23317(), player.method_23318(), player.method_23321()) < 256.0) {
            player.field_13987.method_14364((class_2596)new class_2626(pos.method_10062(), (class_2680)((class_2680)((class_2680)class_2246.field_27171.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)blockState.method_11654(AXIS)), (class_2350.class_2352)class_2350.class_2352.field_11056))).method_11657((class_2769)class_5554.field_27193, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)blockState.method_11654((class_2769)WATERLOGGED)))));
            PolymerServerProtocol.sendBlockUpdate((class_3244)player.field_13987, (class_2338)pos, (class_2680)blockState);
        }
    }

    public class_2680 getPolymerBlockState(class_2680 state) {
        return (class_2680)class_2246.field_10499.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED)));
    }

    public boolean tickElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return true;
    }

    @Override
    public List<WrenchAction> getWrenchActions() {
        return List.of(WrenchAction.AXIS);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public static final class Model
    extends RotationAwareModel {
        public static final class_1799 ITEM_MODEL = new class_1799((class_1935)FactoryItems.AXLE.getPolymerItem());
        public static final class_1799 ITEM_MODEL_SHORT = new class_1799((class_1935)BaseItemProvider.requestItem());
        private final ItemDisplayElement mainElement;
        private final Set<class_3244> viewingClose = new ObjectOpenCustomHashSet(CommonImplUtils.IDENTITY_HASH);
        private final List<class_3244> sentRod = new ArrayList<class_3244>();
        private final List<class_3244> sentBarrier = new ArrayList<class_3244>();

        private Model(class_3218 world, class_2680 state) {
            this.mainElement = LodItemDisplayElement.createSimple((class_1799)ITEM_MODEL, (int)this.getUpdateRate(), (float)0.3f, (float)0.6f);
            this.mainElement.setViewRange(0.7f);
            this.mainElement.setTeleportDuration(1);
            this.updateAnimation(0.0f, (class_2350.class_2351)state.method_11654(AXIS));
            this.addElement((VirtualElement)this.mainElement);
        }

        private void updateAnimation(float rotation, class_2350.class_2351 axis) {
            mat.identity();
            switch (axis) {
                case field_11048: {
                    mat.rotate((Quaternionfc)class_2350.field_11034.method_23224());
                    break;
                }
                case field_11051: {
                    mat.rotate((Quaternionfc)class_2350.field_11035.method_23224());
                }
            }
            mat.rotateY(rotation);
            mat.scale(2.0f, 2.005f, 2.0f);
            this.mainElement.setTransformation(mat);
        }

        public boolean stopWatching(class_3244 player) {
            if (super.stopWatching(player)) {
                this.viewingClose.remove(player);
                return true;
            }
            return false;
        }

        protected void onTick() {
            if (!this.blockAware().isPartOfTheWorld()) {
                return;
            }
            class_2680 rodState = (class_2680)((class_2680)((class_2680)class_2246.field_27171.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)this.blockAware().getBlockState().method_11654(AXIS)), (class_2350.class_2352)class_2350.class_2352.field_11056))).method_11657((class_2769)class_5554.field_27193, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)this.blockAware().getBlockState().method_11654((class_2769)WATERLOGGED)));
            class_2338 pos = this.blockAware().getBlockPos();
            class_2680 state = this.blockAware().getBlockState();
            for (class_3244 player : this.sentRod) {
                player.method_14364((class_2596)new class_2626(pos, rodState));
                PolymerServerProtocol.sendBlockUpdate((class_3244)player, (class_2338)pos, (class_2680)state);
            }
            this.sentRod.clear();
            for (class_3244 player : this.sentBarrier) {
                player.method_14364((class_2596)new class_2626(pos, (class_2680)class_2246.field_10499.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)this.blockAware().getBlockState().method_11654((class_2769)WATERLOGGED)))));
                PolymerServerProtocol.sendBlockUpdate((class_3244)player, (class_2338)pos, (class_2680)state);
            }
            this.sentBarrier.clear();
            for (class_3244 player : this.getWatchingPlayers()) {
                double d = this.squaredDistance(player);
                if (d < 256.0) {
                    if (this.viewingClose.contains(player)) continue;
                    this.sentRod.add(player);
                    this.viewingClose.add(player);
                    continue;
                }
                if (!this.viewingClose.contains(player)) continue;
                this.sentBarrier.add(player);
                this.viewingClose.remove(player);
            }
            long tick = this.blockAware().getWorld().method_8510();
            if (tick % (long)this.getUpdateRate() == 0L) {
                this.updateAnimation(this.getRotation(), (class_2350.class_2351)this.blockAware().getBlockState().method_11654(AXIS));
                this.mainElement.startInterpolationIfDirty();
            }
        }

        static {
            ITEM_MODEL.method_57379(class_9334.field_49637, (Object)new class_9280(((PolymerModelData)AutoModeledPolymerItem.MODELS.get(FactoryItems.AXLE)).value()));
            ITEM_MODEL_SHORT.method_57379(class_9334.field_49637, (Object)new class_9280(PolymerResourcePackUtils.requestModel((class_1792)ITEM_MODEL_SHORT.method_7909(), (class_2960)FactoryUtil.id("block/axle_short")).value()));
        }
    }
}

