/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical;

import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.block.BarrierBasedWaterloggable;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.block.mechanical.AxleBlock;
import eu.pb4.polyfactory.block.mechanical.RotationalNetworkBlock;
import eu.pb4.polyfactory.item.wrench.WrenchAction;
import eu.pb4.polyfactory.item.wrench.WrenchableBlock;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.nodes.DirectionNode;
import eu.pb4.polyfactory.nodes.generic.SimpleAxisNode;
import eu.pb4.polyfactory.nodes.generic.SimpleDirectionNode;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ClutchBlock
extends RotationalNetworkBlock
implements FactoryBlock,
WrenchableBlock,
BarrierBasedWaterloggable {
    public static final class_2769<class_2350.class_2351> AXIS = class_2741.field_12496;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 INVERTED = class_2741.field_12501;

    public ClutchBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AXIS, WATERLOGGED, POWERED, INVERTED});
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        this.tickWater(state, world, pos);
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (!oldState.method_27852(state.method_26204())) {
            this.updatePowered(world, pos, state);
        }
        super.method_9615(state, world, pos, oldState, notify);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        this.updatePowered(world, pos, state);
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return this.waterLog(ctx, (class_2680)super.method_9605(ctx).method_11657(AXIS, (Comparable)ctx.method_8038().method_10166()));
    }

    private void updatePowered(class_1937 world, class_2338 pos, class_2680 state) {
        boolean powered = world.method_49803(pos);
        if (powered != (Boolean)state.method_11654((class_2769)POWERED)) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered)), 4);
        }
    }

    @Override
    public Collection<BlockNode> createRotationalNodes(class_2680 state, class_3218 world, class_2338 pos) {
        class_2350.class_2351 ax = (class_2350.class_2351)state.method_11654(AXIS);
        return state.method_11654((class_2769)POWERED) == state.method_11654((class_2769)INVERTED) ? List.of(new SimpleAxisNode((class_2350.class_2351)state.method_11654(AXIS))) : List.of(new SimpleDirectionNode(class_2350.method_10169((class_2350.class_2351)ax, (class_2350.class_2352)class_2350.class_2352.field_11056)), new SimpleDirectionNode(class_2350.method_10169((class_2350.class_2351)ax, (class_2350.class_2352)class_2350.class_2352.field_11060)));
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, class_3222 player) {
        return class_2246.field_10085.method_9564();
    }

    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(world, initialBlockState);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.rotateAxis(state, AXIS, rotation);
    }

    public class_2680 getPolymerBlockState(class_2680 state) {
        return (class_2680)class_2246.field_10499.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED)));
    }

    public boolean tickElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return true;
    }

    @Override
    public List<WrenchAction> getWrenchActions() {
        return List.of(WrenchAction.AXIS, WrenchAction.INVERTED);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public static final class Model
    extends RotationAwareModel {
        private final ItemDisplayElement main;
        private final ItemDisplayElement left;
        private final ItemDisplayElement right;

        private Model(class_3218 world, class_2680 state) {
            this.main = ItemDisplayElementUtil.createSimple((class_1792)state.method_26204().method_8389());
            this.main.setScale((Vector3fc)new Vector3f(2.0f));
            this.left = LodItemDisplayElement.createSimple((class_1799)AxleBlock.Model.ITEM_MODEL_SHORT, (int)this.getUpdateRate(), (float)0.3f, (float)0.6f);
            this.left.setViewRange(0.5f);
            this.left.setScale((Vector3fc)new Vector3f(2.0f));
            this.right = LodItemDisplayElement.createSimple((class_1799)AxleBlock.Model.ITEM_MODEL_SHORT, (int)this.getUpdateRate(), (float)0.3f, (float)0.6f);
            this.right.setViewRange(0.5f);
            this.right.setScale((Vector3fc)new Vector3f(2.0f));
            this.updateStatePos(state);
            this.updateAnimation(0.0f, 0.0f, (class_2350.class_2351)state.method_11654(AXIS));
            this.addElement((VirtualElement)this.left);
            this.addElement((VirtualElement)this.right);
            this.addElement((VirtualElement)this.main);
        }

        private void updateStatePos(class_2680 state) {
            class_2350.class_2351 dir = (class_2350.class_2351)state.method_11654(AXIS);
            float p = 0.0f;
            float y = 0.0f;
            if (dir == class_2350.class_2351.field_11048) {
                p = 0.0f;
                y = 90.0f;
            } else if (dir == class_2350.class_2351.field_11051) {
                p = 0.0f;
                y = 0.0f;
            } else if (dir == class_2350.class_2351.field_11052) {
                p = 90.0f;
            }
            this.main.setYaw(y);
            this.main.setPitch(p);
        }

        private void updateAnimation(float left, float right, class_2350.class_2351 axis) {
            mat.identity();
            switch (axis) {
                case field_11048: {
                    mat.rotate((Quaternionfc)class_2350.field_11034.method_23224());
                    break;
                }
                case field_11051: {
                    mat.rotate((Quaternionfc)class_2350.field_11035.method_23224());
                }
            }
            mat.rotateY(left);
            mat.scale(2.0f, 2.0f, 2.0f);
            this.left.setTransformation(mat);
            mat.identity();
            switch (axis) {
                case field_11048: {
                    mat.rotate((Quaternionfc)class_2350.field_11039.method_23224());
                    break;
                }
                case field_11051: {
                    mat.rotate((Quaternionfc)class_2350.field_11043.method_23224());
                    break;
                }
                case field_11052: {
                    mat.rotateZ((float)Math.PI);
                }
            }
            mat.rotateY(-right);
            mat.scale(2.0f, 2.0f, 2.0f);
            this.right.setTransformation(mat);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
            }
        }

        protected void onTick() {
            long tick = this.getAttachment().getWorld().method_8510();
            if (tick % (long)this.getUpdateRate() == 0L) {
                float right;
                float left;
                class_2680 state = this.blockState();
                if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
                    left = this.getRotationData(this::isNegative).rotation();
                    right = this.getRotationData(this::isPositive).rotation();
                } else {
                    right = left = this.getRotation();
                }
                this.updateAnimation(left, right, (class_2350.class_2351)this.blockState().method_11654(AXIS));
                if (this.left.isDirty()) {
                    this.left.startInterpolation();
                }
                if (this.right.isDirty()) {
                    this.right.startInterpolation();
                }
            }
        }

        private boolean isPositive(NodeHolder<?> nodeHolder) {
            DirectionNode directionNode;
            BlockNode blockNode = nodeHolder.getNode();
            return blockNode instanceof DirectionNode && (directionNode = (DirectionNode)blockNode).direction().method_10171() == class_2350.class_2352.field_11056;
        }

        private boolean isNegative(NodeHolder<?> nodeHolder) {
            DirectionNode directionNode;
            BlockNode blockNode = nodeHolder.getNode();
            return blockNode instanceof DirectionNode && (directionNode = (DirectionNode)blockNode).direction().method_10171() == class_2350.class_2352.field_11060;
        }
    }
}

