/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.resourcepack.BaseItemProvider;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.mechanical.FanBlockEntity;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.RotationalNetworkBlock;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.wrench.WrenchAction;
import eu.pb4.polyfactory.item.wrench.WrenchableBlock;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.nodes.generic.FunctionalDirectionNode;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4970;
import net.minecraft.class_5244;
import net.minecraft.class_5558;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FanBlock
extends RotationalNetworkBlock
implements FactoryBlock,
RotationUser,
class_2343,
WrenchableBlock {
    public static final class_2753 FACING = class_2741.field_12525;
    public static final class_2746 ENABLED = class_2741.field_12515;
    public static final class_2746 REVERSE = class_2746.method_11825((String)"reverse");
    public static final WrenchAction REVERSE_ACTION = WrenchAction.of("reverse", REVERSE, class_5244::method_36134);

    public FanBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)REVERSE, (Comparable)Boolean.valueOf(false)));
        Model.ITEM_MODEL.method_7909();
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_7715());
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (!oldState.method_27852(state.method_26204())) {
            this.updateEnabled(world, pos, state);
        }
        super.method_9615(state, world, pos, oldState, notify);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        this.updateEnabled(world, pos, state);
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
    }

    private void updateEnabled(class_1937 world, class_2338 pos, class_2680 state) {
        boolean powered = world.method_49803(pos);
        if (powered == (Boolean)state.method_11654((class_2769)ENABLED)) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(!powered)), 4);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ENABLED, REVERSE});
    }

    @Override
    public Collection<BlockNode> createRotationalNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new FunctionalDirectionNode(((class_2350)state.method_11654((class_2769)FACING)).method_10153()));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FanBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world instanceof class_3218 && type == FactoryBlockEntities.FAN ? FanBlockEntity::tick : null;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2470)rotation).method_10503(arg_0), FACING);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2415)mirror).method_10343(arg_0), FACING);
    }

    public class_2680 getPolymerBlockState(class_2680 state) {
        return class_2246.field_10499.method_9564();
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, class_3222 player) {
        return class_2246.field_10085.method_9564();
    }

    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState);
    }

    public boolean tickElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return true;
    }

    @Override
    public List<WrenchAction> getWrenchActions() {
        return List.of(REVERSE_ACTION, WrenchAction.FACING);
    }

    @Override
    public void updateRotationalData(RotationData.State modifier, class_2680 state, class_3218 world, class_2338 pos) {
        modifier.stress(0.1);
    }

    public static final class Model
    extends RotationAwareModel {
        public static final class_1799 ITEM_MODEL = new class_1799((class_1935)BaseItemProvider.requestModel());
        private final ItemDisplayElement mainElement = ItemDisplayElementUtil.createSimple((class_1792)FactoryItems.FAN);
        private final ItemDisplayElement fan;
        private float rotation = 0.0f;
        private boolean reverse;

        private Model(class_2680 state) {
            this.mainElement.setScale((Vector3fc)new Vector3f(2.0f));
            this.fan = LodItemDisplayElement.createSimple((class_1799)ITEM_MODEL, (int)2, (float)0.2f, (float)0.4f);
            this.fan.setViewRange(0.3f);
            this.updateStatePos(state);
            this.updateAnimation(0.0);
            this.addElement((VirtualElement)this.mainElement);
            this.addElement((VirtualElement)this.fan);
        }

        private void updateStatePos(class_2680 state) {
            this.reverse = (Boolean)state.method_11654((class_2769)REVERSE);
            class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
            float p = 0.0f;
            float y = 0.0f;
            if (dir.method_10166() != class_2350.class_2351.field_11052) {
                p = 90.0f;
                y = dir.method_10144();
            } else if (dir == class_2350.field_11033) {
                p = 180.0f;
            }
            this.mainElement.setYaw(y);
            this.mainElement.setPitch(p);
            this.fan.setYaw(y);
            this.fan.setPitch(p);
        }

        private void updateAnimation(double speed) {
            this.rotation += (float)Math.min((this.reverse ? -speed : speed) * 0.01745329238474369 * 3.0, 1.5707863569259644) % ((float)Math.PI * 2);
            mat.identity();
            mat.rotateY(this.rotation);
            mat.scale(2.0f);
            this.fan.setTransformation(mat);
        }

        protected void onTick() {
            if (this.getTick() % 2 == 0) {
                this.updateAnimation(this.getRotationData().speed());
                if (this.fan.isDirty()) {
                    this.fan.startInterpolation();
                }
            }
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
            }
        }

        static {
            ITEM_MODEL.method_57379(class_9334.field_49637, (Object)new class_9280(PolymerResourcePackUtils.requestModel((class_1792)ITEM_MODEL.method_7909(), (class_2960)FactoryUtil.id("block/fan_rotating")).value()));
        }
    }
}

