/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.conveyor;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.mojang.serialization.Codec;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.util.WorldPointer;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.FastItemDisplayElement;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.FactoryBlockTags;
import eu.pb4.polyfactory.block.FactoryBlocks;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.RotationalNetworkBlock;
import eu.pb4.polyfactory.block.mechanical.conveyor.ConveyorBlockEntity;
import eu.pb4.polyfactory.block.mechanical.conveyor.ConveyorLikeDirectional;
import eu.pb4.polyfactory.block.property.FactoryProperties;
import eu.pb4.polyfactory.item.FactoryEnchantmentEffectComponents;
import eu.pb4.polyfactory.item.FactoryEnchantments;
import eu.pb4.polyfactory.models.ConveyorModels;
import eu.pb4.polyfactory.nodes.mechanical.ConveyorNode;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.movingitem.ContainerHolder;
import eu.pb4.polyfactory.util.movingitem.MovingItem;
import eu.pb4.polyfactory.util.movingitem.MovingItemConsumer;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2510;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ConveyorBlock
extends RotationalNetworkBlock
implements FactoryBlock,
class_2343,
ConveyorLikeDirectional,
MovingItemConsumer {
    public static final class_2753 DIRECTION = FactoryProperties.HORIZONTAL_DIRECTION;
    public static final class_2754<DirectionValue> VERTICAL = class_2754.method_11850((String)"vertical", DirectionValue.class);
    public static final class_2746 TOP_CONVEYOR = class_2746.method_11825((String)"hide_top");
    public static final class_2746 BOTTOM_CONVEYOR = class_2746.method_11825((String)"hide_bottom");
    public static final class_2746 PREVIOUS_CONVEYOR = class_2746.method_11825((String)"hide_back");
    public static final class_2746 NEXT_CONVEYOR = class_2746.method_11825((String)"hide_front");
    public static final class_2746 HAS_OUTPUT_TOP = class_2746.method_11825((String)"has_top_output");

    public ConveyorBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(VERTICAL, (Comparable)((Object)DirectionValue.NONE))).method_11657((class_2769)DIRECTION, (Comparable)class_2350.field_11043)).method_11657((class_2769)HAS_OUTPUT_TOP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)NEXT_CONVEYOR, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)PREVIOUS_CONVEYOR, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)TOP_CONVEYOR, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BOTTOM_CONVEYOR, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{DIRECTION});
        builder.method_11667(new class_2769[]{VERTICAL});
        builder.method_11667(new class_2769[]{HAS_OUTPUT_TOP});
        builder.method_11667(new class_2769[]{NEXT_CONVEYOR});
        builder.method_11667(new class_2769[]{PREVIOUS_CONVEYOR});
        builder.method_11667(new class_2769[]{TOP_CONVEYOR});
        builder.method_11667(new class_2769[]{BOTTOM_CONVEYOR});
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        ConveyorBlockEntity conveyor;
        class_2586 be;
        class_1799 x = player.method_5998(class_1268.field_5808);
        if (x.method_31574(class_1802.field_8777) && this == FactoryBlocks.CONVEYOR) {
            ConveyorBlockEntity conveyor2;
            double delta = 0.0;
            MovingItem itemContainer = null;
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof ConveyorBlockEntity) {
                conveyor2 = (ConveyorBlockEntity)class_25862;
                itemContainer = conveyor2.pullAndRemove();
                delta = conveyor2.delta;
            }
            world.method_8501(pos, FactoryBlocks.STICKY_CONVEYOR.method_34725(state));
            world.method_20290(2001, pos, class_2248.method_9507((class_2680)class_2246.field_10030.method_9564()));
            if (!player.method_7337()) {
                x.method_7934(1);
            }
            if (itemContainer != null && (class_25862 = world.method_8321(pos)) instanceof ConveyorBlockEntity) {
                conveyor2 = (ConveyorBlockEntity)class_25862;
                conveyor2.pushAndAttach(itemContainer);
                conveyor2.setDelta(delta);
            }
            return class_1269.field_5812;
        }
        if (x.method_31574(class_1802.field_8554) && this == FactoryBlocks.STICKY_CONVEYOR) {
            ConveyorBlockEntity conveyor3;
            double delta = 0.0;
            MovingItem itemContainer = null;
            class_2586 class_25863 = world.method_8321(pos);
            if (class_25863 instanceof ConveyorBlockEntity) {
                conveyor3 = (ConveyorBlockEntity)class_25863;
                itemContainer = conveyor3.pullAndRemove();
                delta = conveyor3.delta;
            }
            world.method_8501(pos, FactoryBlocks.CONVEYOR.method_34725(state));
            world.method_20290(2001, pos, class_2248.method_9507((class_2680)class_2246.field_10030.method_9564()));
            if (!player.method_7337()) {
                player.method_31548().method_7398(class_1802.field_8777.method_7854());
            }
            if (itemContainer != null && (class_25863 = world.method_8321(pos)) instanceof ConveyorBlockEntity) {
                conveyor3 = (ConveyorBlockEntity)class_25863;
                conveyor3.pushAndAttach(itemContainer);
                conveyor3.setDelta(delta);
            }
            return class_1269.field_5812;
        }
        if (x.method_7960() && (be = world.method_8321(pos)) instanceof ConveyorBlockEntity && !(conveyor = (ConveyorBlockEntity)be).method_5438(0).method_7960()) {
            player.method_6122(class_1268.field_5808, conveyor.method_5438(0));
            conveyor.method_5447(0, class_1799.field_8037);
            conveyor.setDelta(0.0);
            return class_1269.field_5812;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        super.method_9559(state, direction, neighborState, world, pos, neighborPos);
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            DirectionValue vert = (DirectionValue)((Object)state.method_11654(VERTICAL));
            if (vert.value != 0 && direction == class_2350.field_11036) {
                if (neighborState.method_27852((class_2248)this)) {
                    state = (class_2680)state.method_11657(VERTICAL, (Comparable)((Object)(switch (vert.ordinal()) {
                        case 1 -> DirectionValue.POSITIVE_STACK;
                        case 3 -> DirectionValue.NEGATIVE_STACK;
                        default -> vert;
                    })));
                } else {
                    state = (class_2680)state.method_11657(VERTICAL, (Comparable)((Object)(switch (vert.ordinal()) {
                        case 2 -> DirectionValue.POSITIVE;
                        case 4 -> DirectionValue.NEGATIVE;
                        default -> vert;
                    })));
                }
            }
            return (class_2680)((class_2680)state.method_11657((class_2769)HAS_OUTPUT_TOP, (Comparable)Boolean.valueOf(world.method_8320(pos.method_10084()).method_26164(FactoryBlockTags.CONVEYOR_TOP_OUTPUT)))).method_11657((class_2769)(direction == class_2350.field_11036 ? TOP_CONVEYOR : BOTTOM_CONVEYOR), (Comparable)Boolean.valueOf(this.isMatchingConveyor(neighborState, direction, (class_2350)state.method_11654((class_2769)DIRECTION), (DirectionValue)((Object)state.method_11654(VERTICAL)))));
        }
        if (direction.method_10166() == ((class_2350)state.method_11654((class_2769)DIRECTION)).method_10166()) {
            return (class_2680)state.method_11657((class_2769)(direction == state.method_11654((class_2769)DIRECTION) ? NEXT_CONVEYOR : PREVIOUS_CONVEYOR), (Comparable)Boolean.valueOf(this.isMatchingConveyor(neighborState, direction, (class_2350)state.method_11654((class_2769)DIRECTION), (DirectionValue)((Object)state.method_11654(VERTICAL)))));
        }
        return state;
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.pushEntity(serverWorld, state, pos, entity);
        }
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 be = world.method_8321(pos);
        return be.getClass() == ConveyorBlockEntity.class && !((ConveyorBlockEntity)be).method_5438(0).method_7960() ? 15 : 0;
    }

    private void pushEntity(class_3218 world, class_2680 state, class_2338 pos, class_1297 entity) {
        class_1309 livingEntity;
        if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            if (itemEntity.field_6012 > 0) {
                ConveyorBlockEntity conveyorBlockEntity;
                class_2586 be = world.method_8321(pos);
                if (be instanceof ConveyorBlockEntity && (conveyorBlockEntity = (ConveyorBlockEntity)be).tryAdding(itemEntity.method_6983())) {
                    conveyorBlockEntity.setDelta(0.5);
                    if (itemEntity.method_6983().method_7960()) {
                        entity.method_31472();
                    }
                }
                return;
            }
        }
        float mult = 1.0f;
        if (entity instanceof class_1309 && (mult = FactoryEnchantments.getMultiplier(livingEntity = (class_1309)entity, FactoryEnchantmentEffectComponents.CONVEYOR_PUSH_MULTIPLIER)) <= 0.0f) {
            return;
        }
        class_2350 dir = (class_2350)state.method_11654((class_2769)DIRECTION);
        class_2338 next = entity.method_24515().method_10093(dir);
        double speed = RotationUser.getRotation((class_1937)world, pos).speed() * 0.01745329238474369 * 0.9 * 0.7 * (double)mult;
        if (speed == 0.0) {
            return;
        }
        DirectionValue vert = (DirectionValue)((Object)state.method_11654(VERTICAL));
        if (vert != DirectionValue.NONE) {
            speed /= (double)class_3532.field_15724;
        }
        class_243 vec = class_243.method_24954((class_2382)dir.method_10163()).method_1021(speed);
        if ((double)entity.method_49476() < 0.51) {
            class_2680 nextState;
            class_238 box = entity.method_5829().method_997(vec);
            if (vert == DirectionValue.POSITIVE) {
                for (class_238 shape : state.method_26220((class_1922)world, pos).method_1090()) {
                    if (!shape.method_996(pos).method_994(box)) continue;
                    entity.method_5784(class_1313.field_6308, new class_243(0.0, 0.51, 0.0));
                    entity.method_5784(class_1313.field_6308, FactoryUtil.safeVelocity(vec));
                    return;
                }
            }
            if ((nextState = world.method_8320(next)).method_27852((class_2248)this) && nextState.method_11654(VERTICAL) == DirectionValue.POSITIVE) {
                for (class_238 shape : state.method_26220((class_1922)world, pos).method_1090()) {
                    if (!shape.method_996(next).method_994(box)) continue;
                    entity.method_5784(class_1313.field_6308, new class_243(0.0, 0.51, 0.0));
                    entity.method_5784(class_1313.field_6308, FactoryUtil.safeVelocity(vec));
                    return;
                }
            }
        }
        FactoryUtil.addSafeVelocity(entity, vec);
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            FactoryUtil.sendVelocityDelta(player, vec.method_1021(0.55));
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 upState;
        class_2680 against = ctx.method_8045().method_8320(ctx.method_8037().method_10093(ctx.method_8038().method_10153()));
        class_2680 state = null;
        class_2350 direction = class_2350.field_11043;
        if (against.method_27852((class_2248)this)) {
            if (ctx.method_8038().method_10166() == class_2350.class_2351.field_11052) {
                class_2680 behind = ctx.method_8045().method_8320(ctx.method_8037().method_10093(((class_2350)against.method_11654((class_2769)DIRECTION)).method_10153()));
                state = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)DIRECTION, (Comparable)((class_2350)against.method_11654((class_2769)DIRECTION)))).method_11657(VERTICAL, (Comparable)((Object)(behind.method_27852((class_2248)this) ? DirectionValue.NEGATIVE : DirectionValue.POSITIVE)));
            } else if (ctx.method_8038().method_10166() == ((class_2350)against.method_11654((class_2769)DIRECTION)).method_10166()) {
                state = (class_2680)this.method_9564().method_11657((class_2769)DIRECTION, (Comparable)((class_2350)against.method_11654((class_2769)DIRECTION)));
                double y = ctx.method_17698().method_10214() - (double)ctx.method_8037().method_10264();
                if (y < 0.3125) {
                    state = (class_2680)state.method_11657(VERTICAL, (Comparable)((Object)(ctx.method_8038() == against.method_11654((class_2769)DIRECTION) ? DirectionValue.NEGATIVE : DirectionValue.POSITIVE)));
                }
            }
            direction = (class_2350)against.method_11654((class_2769)DIRECTION);
        }
        if (state == null) {
            if (ctx.method_8038().method_10166() != class_2350.class_2351.field_11052) {
                direction = ctx.method_8038().method_10153();
                state = (class_2680)this.method_9564().method_11657((class_2769)DIRECTION, (Comparable)ctx.method_8038().method_10153());
            } else {
                direction = ctx.method_8042();
                state = (class_2680)this.method_9564().method_11657((class_2769)DIRECTION, (Comparable)ctx.method_8042());
            }
        }
        if ((upState = ctx.method_8045().method_8320(ctx.method_8037().method_10084())).method_27852((class_2248)this) && upState.method_11654((class_2769)DIRECTION) == direction) {
            if (((DirectionValue)((Object)upState.method_11654(ConveyorBlock.VERTICAL))).value != 0) {
                DirectionValue vert = (DirectionValue)((Object)upState.method_11654(VERTICAL));
                state = (class_2680)state.method_11657(VERTICAL, (Comparable)((Object)(switch (vert.ordinal()) {
                    case 1, 2 -> DirectionValue.POSITIVE_STACK;
                    case 3, 4 -> DirectionValue.NEGATIVE_STACK;
                    default -> vert;
                })));
            } else if (ctx.method_8038() == class_2350.field_11033) {
                state = (class_2680)state.method_11657(VERTICAL, (Comparable)((Object)DirectionValue.NEGATIVE_STACK));
            }
        }
        DirectionValue value = (DirectionValue)((Object)state.method_11654(VERTICAL));
        class_2680 bottom = ctx.method_8045().method_8320(ctx.method_8037().method_10074());
        return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NEXT_CONVEYOR, (Comparable)Boolean.valueOf(this.isMatchingConveyor(ctx.method_8045().method_8320(ctx.method_8037().method_10093(direction)), direction, direction, value)))).method_11657((class_2769)PREVIOUS_CONVEYOR, (Comparable)Boolean.valueOf(this.isMatchingConveyor(ctx.method_8045().method_8320(ctx.method_8037().method_10079(direction, -1)), direction.method_10153(), direction, value)))).method_11657((class_2769)TOP_CONVEYOR, (Comparable)Boolean.valueOf(this.isMatchingConveyor(ctx.method_8045().method_8320(ctx.method_8037().method_10084()), class_2350.field_11036, direction, value)))).method_11657((class_2769)BOTTOM_CONVEYOR, (Comparable)Boolean.valueOf(this.isMatchingConveyor(bottom, class_2350.field_11033, direction, value)))).method_11657((class_2769)HAS_OUTPUT_TOP, (Comparable)Boolean.valueOf(ctx.method_8045().method_8320(ctx.method_8037().method_10084()).method_26164(FactoryBlockTags.CONVEYOR_TOP_OUTPUT)));
    }

    public static int getModelId(class_2680 state) {
        DirectionValue value = (DirectionValue)((Object)state.method_11654(VERTICAL));
        if (value.stack && value.value == 1) {
            return ConveyorBlock.getModelId((Boolean)state.method_11654((class_2769)PREVIOUS_CONVEYOR), (Boolean)state.method_11654((class_2769)NEXT_CONVEYOR), (Boolean)state.method_11654((class_2769)BOTTOM_CONVEYOR), (Boolean)state.method_11654((class_2769)TOP_CONVEYOR));
        }
        if (value.stack && value.value == -1) {
            return ConveyorBlock.getModelId((Boolean)state.method_11654((class_2769)NEXT_CONVEYOR), (Boolean)state.method_11654((class_2769)PREVIOUS_CONVEYOR), (Boolean)state.method_11654((class_2769)TOP_CONVEYOR), (Boolean)state.method_11654((class_2769)BOTTOM_CONVEYOR));
        }
        return ConveyorBlock.getModelId((Boolean)state.method_11654((class_2769)TOP_CONVEYOR), (Boolean)state.method_11654((class_2769)BOTTOM_CONVEYOR), (Boolean)state.method_11654((class_2769)PREVIOUS_CONVEYOR), (Boolean)state.method_11654((class_2769)NEXT_CONVEYOR));
    }

    public static int getModelId(boolean top, boolean bottom, boolean previous, boolean next) {
        int i = 0;
        if (top) {
            i |= 1;
        }
        if (bottom) {
            i |= 2;
        }
        if (previous) {
            i |= 4;
        }
        if (next) {
            i |= 8;
        }
        return i;
    }

    public static boolean hasTop(int i) {
        return (i & 1) != 0;
    }

    public static boolean hasBottom(int i) {
        return (i & 2) != 0;
    }

    public static boolean hasPrevious(int i) {
        return (i & 4) != 0;
    }

    public static boolean hasNext(int i) {
        return (i & 8) != 0;
    }

    private boolean isMatchingConveyor(class_2680 neighborState, class_2350 neighborDirection, class_2350 selfDirection, DirectionValue selfValue) {
        if (!neighborState.method_27852((class_2248)this) || neighborState.method_11654((class_2769)DIRECTION) != selfDirection) {
            return false;
        }
        DirectionValue neighborValue = (DirectionValue)((Object)neighborState.method_11654(VERTICAL));
        if (neighborValue == DirectionValue.POSITIVE && (neighborDirection == class_2350.field_11033 || neighborDirection == selfDirection)) {
            return selfValue == DirectionValue.NEGATIVE;
        }
        if (neighborValue == DirectionValue.NEGATIVE && (neighborDirection == class_2350.field_11033 || neighborDirection == selfDirection.method_10153())) {
            return selfValue == DirectionValue.POSITIVE;
        }
        if (selfValue == DirectionValue.POSITIVE && (neighborDirection == class_2350.field_11036 || neighborDirection == selfDirection.method_10153())) {
            return neighborValue == DirectionValue.NEGATIVE;
        }
        if (selfValue == DirectionValue.NEGATIVE && (neighborDirection == class_2350.field_11036 || neighborDirection == selfDirection)) {
            return neighborValue == DirectionValue.POSITIVE;
        }
        if (neighborDirection == class_2350.field_11036 || neighborDirection == class_2350.field_11033) {
            return neighborValue.value != -selfValue.value;
        }
        return true;
    }

    public class_2680 getPolymerBlockState(class_2680 state) {
        if (state.method_11654(VERTICAL) == DirectionValue.NONE || ((DirectionValue)((Object)state.method_11654(ConveyorBlock.VERTICAL))).stack) {
            return class_2246.field_10499.method_9564();
        }
        return (class_2680)((class_2680)class_2246.field_10386.method_9564().method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12617)).method_11657((class_2769)class_2510.field_11571, (Comparable)(((DirectionValue)((Object)state.method_11654(ConveyorBlock.VERTICAL))).value == 1 ? (class_2350)state.method_11654((class_2769)DIRECTION) : ((class_2350)state.method_11654((class_2769)DIRECTION)).method_10153()));
    }

    @Override
    public Collection<BlockNode> createRotationalNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new ConveyorNode((class_2350)state.method_11654((class_2769)DIRECTION), (DirectionValue)((Object)state.method_11654(VERTICAL))));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ConveyorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world instanceof class_3218 && type == FactoryBlockEntities.CONVEYOR ? ConveyorBlockEntity::tick : null;
    }

    @Override
    public ConveyorLikeDirectional.TransferMode getTransferMode(class_2680 selfState, class_2350 direction) {
        class_2350 dir = (class_2350)selfState.method_11654((class_2769)DIRECTION);
        if (dir == direction) {
            return ConveyorLikeDirectional.TransferMode.TO_CONVEYOR;
        }
        return ConveyorLikeDirectional.TransferMode.FROM_CONVEYOR;
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 blockEntity;
        if (!state.method_27852(newState.method_26204()) && (blockEntity = world.method_8321(pos)) instanceof class_1263) {
            class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((class_1263)blockEntity));
            world.method_8455(pos, (class_2248)this);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(this, world, initialBlockState);
    }

    public class_243 getElementHolderOffset(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return FactoryUtil.HALF_BELOW;
    }

    @Override
    public boolean pushItemTo(WorldPointer self, class_2350 pushDirection, class_2350 relative, class_2338 conveyorPos, ContainerHolder conveyor) {
        ConveyorBlockEntity be;
        class_2680 state = self.getBlockState();
        DirectionValue vert = (DirectionValue)((Object)state.method_11654(VERTICAL));
        if (!state.method_27852((class_2248)FactoryBlocks.STICKY_CONVEYOR) && vert.stack) {
            return vert.value == 1;
        }
        class_2586 class_25862 = self.getBlockEntity();
        if (class_25862 instanceof ConveyorBlockEntity && (be = (ConveyorBlockEntity)class_25862).isContainerEmpty()) {
            class_2350 selfDir = (class_2350)be.method_11010().method_11654((class_2769)DIRECTION);
            if (selfDir == pushDirection) {
                be.setDelta(0.0);
            } else if (selfDir == pushDirection.method_10153()) {
                be.setDelta(0.8);
            } else {
                be.setDelta(0.5);
            }
            be.pushAndAttach(conveyor.pullAndRemove());
            return true;
        }
        return true;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2470)rotation).method_10503(arg_0), DIRECTION);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2415)mirror).method_10343(arg_0), DIRECTION);
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, class_3222 player) {
        return class_2246.field_10360.method_9564();
    }

    public boolean tickElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return true;
    }

    public static enum DirectionValue implements class_3542
    {
        NONE(0, false),
        POSITIVE(1, false),
        POSITIVE_STACK(1, true),
        NEGATIVE(-1, false),
        NEGATIVE_STACK(-1, true);

        public static final Codec<DirectionValue> CODEC;
        public final int value;
        public final boolean stack;

        private DirectionValue(int value, boolean isStack) {
            this.value = value;
            this.stack = isStack;
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_53955(DirectionValue::values);
        }
    }

    public final class Model
    extends BlockModel
    implements ContainerHolder {
        private final FastItemDisplayElement base;
        private double speed;
        private class_2350 direction;
        private MovingItem movingItemContainer;
        private DirectionValue value;
        private double delta;

        private Model(ConveyorBlock this$0, class_3218 world, class_2680 state) {
            DirectionValue type = (DirectionValue)((Object)state.method_11654(VERTICAL));
            this.base = new FastItemDisplayElement(this.getModelForSpeed(0.0, type, state.method_27852((class_2248)FactoryBlocks.STICKY_CONVEYOR), state));
            this.base.setFastItem(this.getFastModel(type, state.method_27852((class_2248)FactoryBlocks.STICKY_CONVEYOR), state), 24);
            this.base.setDisplaySize(1.0f, 1.0f);
            this.base.setModelTransformation(class_811.field_4319);
            this.base.setViewRange(0.7f);
            this.base.setInvisible(true);
            this.updateAnimation((class_2350)state.method_11654((class_2769)DIRECTION), (DirectionValue)((Object)state.method_11654(VERTICAL)));
            this.addElement((VirtualElement)this.base);
        }

        private class_1799 getModelForSpeed(double speed, DirectionValue directionValue, boolean sticky, class_2680 state) {
            return (switch (directionValue.ordinal()) {
                case 1 -> {
                    if (sticky) {
                        yield ConveyorModels.ANIMATION_UP_STICKY;
                    }
                    yield ConveyorModels.ANIMATION_UP;
                }
                case 3 -> {
                    if (sticky) {
                        yield ConveyorModels.ANIMATION_DOWN_STICKY;
                    }
                    yield ConveyorModels.ANIMATION_DOWN;
                }
                default -> sticky ? ConveyorModels.ANIMATION_REGULAR_STICKY : ConveyorModels.ANIMATION_REGULAR;
            })[ConveyorBlock.getModelId(state)][(int)Math.ceil(class_3532.method_15350((double)(speed * 20.0 * 15.0), (double)0.0, (double)20.0))];
        }

        private class_1799 getFastModel(DirectionValue directionValue, boolean sticky, class_2680 state) {
            return switch (directionValue.ordinal()) {
                case 1 -> {
                    if (sticky) {
                        yield ConveyorModels.STICKY_UP_FAST;
                    }
                    yield ConveyorModels.UP_FAST;
                }
                case 3 -> {
                    if (sticky) {
                        yield ConveyorModels.STICKY_DOWN_FAST;
                    }
                    yield ConveyorModels.DOWN_FAST;
                }
                default -> sticky ? ConveyorModels.STICKY_REGULAR_FAST : ConveyorModels.REGULAR_FAST;
            };
        }

        private void updateAnimation(class_2350 dir, DirectionValue value) {
            if (dir != this.direction || value != this.value) {
                mat.identity().translate(0.0f, 0.5f, 0.0f).rotateY((270.0f - dir.method_10144()) * ((float)Math.PI / 180));
                if (value.value == -1 && !value.stack) {
                    mat.rotateY((float)Math.PI);
                }
                if (value.value != 0 && value.stack) {
                    mat.rotateZ(1.5707964f * (float)value.value);
                }
                float f = (float)dir.method_10166().ordinal() * 1.0E-4f;
                boolean x = value == DirectionValue.NONE || value.stack;
                float v = x ? 0.0f : 0.0015f;
                mat.translate(-v, v + f, 0.0f);
                mat.scale(x ? 2.001f : 2.015f);
                this.base.setTransformation(mat);
            }
            this.direction = dir;
            this.value = value;
        }

        protected void onTick() {
            if (this.movingItemContainer != null) {
                this.movingItemContainer.tick();
            }
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                class_2680 state = this.blockState();
                this.base.setItem(this.getModelForSpeed(this.speed, (DirectionValue)((Object)state.method_11654(VERTICAL)), state.method_27852((class_2248)FactoryBlocks.STICKY_CONVEYOR), state));
                this.base.setFastItem(this.getFastModel((DirectionValue)((Object)state.method_11654(VERTICAL)), state.method_27852((class_2248)FactoryBlocks.STICKY_CONVEYOR), state), 24);
                this.updateAnimation((class_2350)state.method_11654((class_2769)DIRECTION), (DirectionValue)((Object)state.method_11654(VERTICAL)));
                this.tick();
            }
        }

        public boolean updateSpeed(double speed) {
            if (this.speed != speed) {
                class_2680 state = this.blockState();
                this.base.setItem(this.getModelForSpeed(speed, (DirectionValue)((Object)state.method_11654(VERTICAL)), state.method_27852((class_2248)FactoryBlocks.STICKY_CONVEYOR), state));
                this.speed = speed;
                return true;
            }
            return false;
        }

        public void updateDelta(double oldDelta, double newDelta) {
            if (oldDelta == newDelta) {
                return;
            }
            this.delta = newDelta;
            if (this.movingItemContainer != null) {
                this.movingItemContainer.setPos(this.calculatePos(newDelta));
                Quaternionf base = new Quaternionf().rotateY(this.direction.method_10144() * ((float)Math.PI / 180));
                if (this.value.stack) {
                    base.rotateX(1.5707964f);
                } else if (this.value.value != 0) {
                    base.rotateX((float)(this.direction.method_10166() == class_2350.class_2351.field_11048 ? -1 : 1) * 1.5707964f / 2.0f * (float)(-this.value.value));
                }
                this.movingItemContainer.setRotation(base.mul((Quaternionfc)class_2350.field_11043.method_23224()));
            }
        }

        private class_243 calculatePos(double delta) {
            if (this.value.stack) {
                double visualDelta = class_3532.method_15350((double)delta, (double)0.0, (double)1.0);
                class_2382 vec3i = this.direction.method_10163();
                return new class_243((double)(-vec3i.method_10263() * this.value.value) * 0.52, this.value.value == -1 ? 1.0 - visualDelta : visualDelta, (double)(-vec3i.method_10260() * this.value.value) * 0.52).method_1019(this.getPos());
            }
            double visualDelta = class_3532.method_15350((double)(delta - 0.5), (double)-0.5, (double)0.5);
            class_2382 vec3i = this.direction.method_10163();
            return new class_243((double)vec3i.method_10263() * visualDelta, class_3532.method_15350((double)((double)this.value.value * visualDelta), (double)-1.0, (double)0.0) + 1.05, (double)vec3i.method_10260() * visualDelta).method_1019(this.getPos());
        }

        @Override
        public MovingItem getContainer() {
            return this.movingItemContainer;
        }

        @Override
        public void setContainer(MovingItem container) {
            if (this.movingItemContainer != null) {
                this.removeElement(this.movingItemContainer);
            }
            this.movingItemContainer = container;
            if (container != null) {
                container.setPos(this.calculatePos(this.delta));
                container.scale(1.0f);
                this.updateDelta(-1.0, this.delta);
                this.addElement(container);
            }
        }

        @Override
        public void clearContainer() {
            if (this.movingItemContainer != null) {
                this.removeElement(this.movingItemContainer);
            }
            this.movingItemContainer = null;
        }

        @Override
        public MovingItem pullAndRemove() {
            MovingItem x = this.movingItemContainer;
            this.movingItemContainer = null;
            if (x != null) {
                this.removeElementWithoutUpdates(x);
            }
            return x;
        }

        @Override
        public void pushAndAttach(MovingItem container) {
            if (container == null) {
                this.clearContainer();
                return;
            }
            if (this.movingItemContainer != null) {
                this.removeElement(this.movingItemContainer);
            }
            this.movingItemContainer = container;
            container.scale(1.0f);
            this.updateDelta(-1.0, this.delta);
            this.addElementWithoutUpdates(container);
        }
    }
}

