/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.conveyor;

import eu.pb4.factorytools.api.block.BarrierBasedWaterloggable;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.resourcepack.BaseItemProvider;
import eu.pb4.factorytools.api.util.WorldPointer;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.block.mechanical.conveyor.ConveyorLikeDirectional;
import eu.pb4.polyfactory.block.mechanical.conveyor.FunnelBlockEntity;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.tool.FilterItem;
import eu.pb4.polyfactory.item.wrench.WrenchAction;
import eu.pb4.polyfactory.item.wrench.WrenchableBlock;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.movingitem.ContainerHolder;
import eu.pb4.polyfactory.util.movingitem.MovingItem;
import eu.pb4.polyfactory.util.movingitem.MovingItemConsumer;
import eu.pb4.polyfactory.util.movingitem.MovingItemProvider;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_811;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class FunnelBlock
extends class_2248
implements FactoryBlock,
MovingItemConsumer,
MovingItemProvider,
WrenchableBlock,
class_2343,
BarrierBasedWaterloggable {
    public static final class_2753 FACING = class_2741.field_12525;
    public static final class_2746 ENABLED = class_2741.field_12515;
    public static final class_2754<ConveyorLikeDirectional.TransferMode> MODE = class_2754.method_11849((String)"mode", ConveyorLikeDirectional.TransferMode.class, (Enum[])new ConveyorLikeDirectional.TransferMode[]{ConveyorLikeDirectional.TransferMode.FROM_CONVEYOR, ConveyorLikeDirectional.TransferMode.TO_CONVEYOR});
    private static final WrenchAction MODE_ACTION = WrenchAction.of("mode", MODE, t -> class_2561.method_43471((String)("item.polyfactory.wrench.action.mode.transfer_mode." + t.method_15434())));

    public FunnelBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(true)));
        Model.MODEL_OUT.method_7960();
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, MODE, ENABLED});
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        this.tickWater(state, world, pos);
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 class_25862;
        if (!state.method_27852(newState.method_26204()) && (class_25862 = world.method_8321(pos)) instanceof FunnelBlockEntity) {
            FunnelBlockEntity be = (FunnelBlockEntity)class_25862;
            class_1264.method_5449((class_1937)world, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 0.5), (double)((double)pos.method_10260() + 0.5), (class_1799)be.getFilter());
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    public boolean pushItemTo(WorldPointer self, class_2350 pushDirection, class_2350 relative, class_2338 conveyorPos, ContainerHolder conveyor) {
        FunnelBlockEntity funnelBlockEntity;
        class_2350 selfDir;
        class_2680 selfState;
        block8: {
            block7: {
                selfState = self.getBlockState();
                if (!((Boolean)selfState.method_11654((class_2769)ENABLED)).booleanValue()) {
                    return false;
                }
                selfDir = (class_2350)selfState.method_11654((class_2769)FACING);
                ConveyorLikeDirectional.TransferMode mode = (ConveyorLikeDirectional.TransferMode)((Object)selfState.method_11654(MODE));
                if (!mode.fromConveyor || relative != class_2350.field_11036 || selfDir.method_10153() == pushDirection) break block7;
                double d = conveyor.movementDelta();
                double d2 = selfDir == pushDirection ? 0.9 : 0.48;
                if (!(d < d2) && selfDir.method_10166() != class_2350.class_2351.field_11052) break block8;
            }
            return false;
        }
        class_2586 be = self.getBlockEntity();
        if (be instanceof FunnelBlockEntity && !(funnelBlockEntity = (FunnelBlockEntity)be).matches(conveyor.getContainer().method_32327())) {
            return false;
        }
        MovingItem stack = conveyor.getContainer();
        if (FactoryUtil.tryInserting((class_1937)self.getWorld(), self.getPos().method_10093((class_2350)selfState.method_11654((class_2769)FACING)), stack.method_32327(), selfDir.method_10153()) == -1) {
            return selfDir.method_10166() == pushDirection.method_10166();
        }
        if (stack.method_32327().method_7960()) {
            conveyor.clearContainer();
        }
        return selfDir.method_10166() == pushDirection.method_10166();
    }

    @Override
    public void getItemFrom(WorldPointer self, class_2350 pushDirection, class_2350 relative, class_2338 conveyorPos, ContainerHolder conveyor) {
        block12: {
            FunnelBlockEntity be;
            class_2350 selfFacing;
            block11: {
                class_1278 s;
                class_1278 sided;
                FunnelBlockEntity x;
                if (relative != class_2350.field_11033 || !conveyor.isContainerEmpty()) {
                    return;
                }
                class_2680 selfState = self.getBlockState();
                ConveyorLikeDirectional.TransferMode mode = (ConveyorLikeDirectional.TransferMode)((Object)selfState.method_11654(MODE));
                selfFacing = (class_2350)selfState.method_11654((class_2769)FACING);
                if (!((Boolean)selfState.method_11654((class_2769)ENABLED)).booleanValue() || !mode.toConveyor || pushDirection == selfFacing) {
                    return;
                }
                class_2586 class_25862 = self.getBlockEntity();
                FunnelBlockEntity funnelBlockEntity = be = class_25862 instanceof FunnelBlockEntity ? (x = (FunnelBlockEntity)class_25862) : null;
                if (be == null) {
                    return;
                }
                class_1263 inv = class_2614.method_11250((class_1937)self.getWorld(), (class_2338)self.getPos().method_10093(selfFacing));
                class_1278 class_12782 = sided = inv instanceof class_1278 ? (s = (class_1278)inv) : null;
                if (inv == null) break block11;
                for (int i = 0; i < inv.method_5439(); ++i) {
                    class_1799 stack = inv.method_5438(i);
                    if (stack.method_7960() || !be.matches(stack) || sided != null && !sided.method_5493(i, stack, selfFacing.method_10153()) || !conveyor.pushNew(stack)) continue;
                    inv.method_5431();
                    if (stack.method_7960()) {
                        inv.method_5447(i, class_1799.field_8037);
                    }
                    conveyor.setMovementPosition(pushDirection.method_10153() == selfFacing ? 0.15 : 0.5);
                    return;
                }
                break block12;
            }
            Storage storage = (Storage)ItemStorage.SIDED.find((class_1937)self.getWorld(), self.getPos().method_10093(selfFacing), (Object)selfFacing);
            if (storage == null) break block12;
            for (StorageView view : storage) {
                if (view.isResourceBlank() || !be.matches(((ItemVariant)view.getResource()).toStack())) continue;
                Transaction t = Transaction.openOuter();
                try {
                    long val = view.extract((Object)((ItemVariant)view.getResource()), (long)conveyor.getMaxStackCount(((ItemVariant)view.getResource()).toStack()), (TransactionContext)t);
                    if (val == 0L) continue;
                    t.commit();
                    if (!conveyor.pushNew(((ItemVariant)view.getResource()).toStack((int)val))) continue;
                    conveyor.setMovementPosition(pushDirection.method_10153() == selfFacing ? 0.15 : 0.5);
                    return;
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
        }
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (!oldState.method_27852(state.method_26204())) {
            this.updateEnabled(world, pos, state);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        this.updateEnabled(world, pos, state);
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
    }

    private void updateEnabled(class_1937 world, class_2338 pos, class_2680 state) {
        boolean powered = world.method_49803(pos);
        if (powered == (Boolean)state.method_11654((class_2769)ENABLED)) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(!powered)), 4);
        }
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        ConveyorLikeDirectional.TransferMode transferMode;
        class_2350 dir;
        if (ctx.method_8038() == class_2350.field_11033) {
            ((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11036)).method_11657(MODE, (Comparable)((Object)ConveyorLikeDirectional.TransferMode.TO_CONVEYOR));
        }
        if ((dir = ctx.method_8038().method_10153()) == class_2350.field_11033) {
            dir = ctx.method_8042();
        }
        class_2338 selfPos = ctx.method_8037();
        if (ctx.method_8038() != class_2350.field_11036) {
            selfPos = selfPos.method_10093(ctx.method_8038());
        }
        selfPos = selfPos.method_10074();
        class_2680 below = ctx.method_8045().method_8320(selfPos);
        class_2248 class_22482 = below.method_26204();
        if (class_22482 instanceof ConveyorLikeDirectional) {
            ConveyorLikeDirectional directional = (ConveyorLikeDirectional)class_22482;
            transferMode = directional.getTransferMode(below, dir.method_10153());
        } else {
            transferMode = ConveyorLikeDirectional.TransferMode.TO_CONVEYOR;
        }
        ConveyorLikeDirectional.TransferMode mode = transferMode;
        return this.waterLog(ctx, (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)dir)).method_11657(MODE, (Comparable)((Object)mode)));
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        FunnelBlockEntity x;
        FunnelBlockEntity be;
        class_1799 stack = player.method_5998(class_1268.field_5808);
        class_2586 class_25862 = world.method_8321(pos);
        FunnelBlockEntity funnelBlockEntity = be = class_25862 instanceof FunnelBlockEntity ? (x = (FunnelBlockEntity)class_25862) : null;
        if (be == null) {
            return class_1269.field_5814;
        }
        if (stack.method_31574(FactoryItems.ITEM_FILTER) && !FilterItem.getStack(stack).method_7960()) {
            if (!be.getFilter().method_7960()) {
                player.method_31548().method_7398(be.getFilter());
            }
            be.setFilter(stack.method_46651(1));
            stack.method_7934(1);
            return class_1269.field_5812;
        }
        if (stack.method_7960()) {
            player.method_6122(class_1268.field_5808, be.getFilter());
            be.setFilter(class_1799.field_8037);
            return class_1269.field_5812;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2470)rotation).method_10503(arg_0), FACING);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2415)mirror).method_10343(arg_0), FACING);
    }

    public class_2680 getPolymerBlockState(class_2680 state) {
        return class_2246.field_10499.method_9564();
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, class_3222 player) {
        return class_2246.field_9975.method_9564();
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FunnelBlockEntity(pos, state);
    }

    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(world, pos, initialBlockState);
    }

    @Override
    public List<WrenchAction> getWrenchActions() {
        return List.of(WrenchAction.FACING, MODE_ACTION);
    }

    public static final class Model
    extends BlockModel {
        private static final class_1799 MODEL_IN = new class_1799((class_1935)BaseItemProvider.requestModel());
        private static final class_1799 MODEL_OUT = new class_1799((class_1935)BaseItemProvider.requestModel());
        private final ItemDisplayElement mainElement = new LodItemDisplayElement();
        final ItemDisplayElement filterElement;

        private Model(class_3218 world, class_2338 pos, class_2680 state) {
            this.mainElement.setDisplaySize(1.0f, 1.0f);
            this.mainElement.setModelTransformation(class_811.field_4319);
            this.mainElement.setInvisible(true);
            this.mainElement.setViewRange(0.8f);
            this.filterElement = new LodItemDisplayElement();
            this.filterElement.setDisplaySize(1.0f, 1.0f);
            this.filterElement.setModelTransformation(class_811.field_4317);
            this.filterElement.setViewRange(0.1f);
            this.filterElement.setInvisible(true);
            this.filterElement.setViewRange(0.3f);
            this.updateFacing(state);
            this.addElement((VirtualElement)this.mainElement);
            this.addElement((VirtualElement)this.filterElement);
        }

        private void updateFacing(class_2680 facing) {
            Quaternionf rot = ((class_2350)facing.method_11654((class_2769)FACING)).method_23224().mul((Quaternionfc)class_2350.field_11043.method_23224());
            mat.identity();
            mat.rotate((Quaternionfc)rot);
            mat.scale(2.01f);
            boolean outModel = facing.method_11654(MODE) == ConveyorLikeDirectional.TransferMode.FROM_CONVEYOR;
            this.mainElement.setItem(outModel ? MODEL_OUT : MODEL_IN);
            this.mainElement.setTransformation(mat);
            mat.identity();
            mat.rotate((Quaternionfc)rot).rotateY((float)Math.PI);
            if (outModel) {
                mat.rotateX(-0.3926991f);
                mat.translate(0.0f, 0.5f, 0.008f);
            } else {
                mat.translate(0.0f, 0.555f, 0.025f);
            }
            mat.scale(0.4f, 0.4f, 0.005f);
            this.filterElement.setTransformation(mat);
            this.tick();
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateFacing(this.blockState());
            }
        }

        static {
            MODEL_IN.method_57379(class_9334.field_49637, (Object)new class_9280(PolymerResourcePackUtils.requestModel((class_1792)MODEL_IN.method_7909(), (class_2960)FactoryUtil.id("block/funnel_in")).value()));
            MODEL_OUT.method_57379(class_9334.field_49637, (Object)new class_9280(PolymerResourcePackUtils.requestModel((class_1792)MODEL_OUT.method_7909(), (class_2960)FactoryUtil.id("block/funnel_out")).value()));
        }
    }
}

