/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.conveyor;

import eu.pb4.factorytools.api.block.BarrierBasedWaterloggable;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.util.WorldPointer;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.polyfactory.block.FactoryBlockTags;
import eu.pb4.polyfactory.block.mechanical.conveyor.ConveyorBlock;
import eu.pb4.polyfactory.block.mechanical.conveyor.SplitterBlockEntity;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.tool.FilterItem;
import eu.pb4.polyfactory.item.wrench.WrenchAction;
import eu.pb4.polyfactory.item.wrench.WrenchableBlock;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.movingitem.ContainerHolder;
import eu.pb4.polyfactory.util.movingitem.MovingItem;
import eu.pb4.polyfactory.util.movingitem.MovingItemConsumer;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.List;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class SplitterBlock
extends class_2248
implements FactoryBlock,
MovingItemConsumer,
WrenchableBlock,
class_2343,
BarrierBasedWaterloggable {
    public static final class_2746 ENABLED = class_2741.field_12515;
    public static final class_2746 DISTRIBUTE = class_2746.method_11825((String)"distribute");
    public static final class_2746 BLOCKING = class_2746.method_11825((String)"blocking");
    public static class_2753 FACING = class_2741.field_12481;

    public SplitterBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)DISTRIBUTE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)BLOCKING, (Comparable)Boolean.valueOf(true)));
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        this.tickWater(state, world, pos);
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ENABLED, DISTRIBUTE, BLOCKING});
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    @Override
    public boolean pushItemTo(WorldPointer self, class_2350 pushDirection, class_2350 relative, class_2338 conveyorPos, ContainerHolder conveyor) {
        class_2680 selfState = self.getBlockState();
        class_2350 dir = (class_2350)selfState.method_11654((class_2769)FACING);
        MovingItem item = conveyor.getContainer();
        if (!((Boolean)selfState.method_11654((class_2769)ENABLED)).booleanValue() || item == null || item.method_32327().method_7960() || conveyor.movementDelta() < 0.49) {
            return false;
        }
        class_2586 class_25862 = self.getBlockEntity();
        if (class_25862 instanceof SplitterBlockEntity) {
            List<class_2350> dirs;
            SplitterBlockEntity blockEntity = (SplitterBlockEntity)class_25862;
            class_1799 stack = item.method_32327();
            if (blockEntity.filtersEmpty()) {
                dirs = List.of(dir.method_10160(), dir, dir.method_10170());
            } else if (blockEntity.matchesSides(stack)) {
                dirs = List.of(dir.method_10160(), dir.method_10170());
            } else if (blockEntity.matchesLeft(item.method_32327())) {
                dirs = List.of(dir.method_10160());
            } else if (blockEntity.matchesRight(item.method_32327())) {
                dirs = List.of(dir.method_10170());
            } else if (blockEntity.isLeftFilterEmpty()) {
                dirs = List.of(dir.method_10160(), dir);
            } else if (blockEntity.isRightFilterEmpty()) {
                dirs = List.of(dir.method_10170(), dir);
            } else {
                return false;
            }
            if (((Boolean)selfState.method_11654((class_2769)DISTRIBUTE)).booleanValue() && dirs.size() > 1) {
                dirs = List.of(dirs.get(blockEntity.pos(dirs.size())));
            }
            for (class_2350 direction : dirs) {
                FactoryUtil.MovableResult x = FactoryUtil.tryInsertingMovable(conveyor, (class_1937)self.getWorld(), conveyorPos, conveyorPos.method_10093(direction), direction, direction, FactoryBlockTags.SPLITTER_SIDE_OUTPUT);
                if (x != FactoryUtil.MovableResult.FAILURE) {
                    return true;
                }
                x = FactoryUtil.tryInsertingMovable(conveyor, (class_1937)self.getWorld(), conveyorPos, conveyorPos.method_10093(direction).method_10084(), direction, direction, FactoryBlockTags.SPLITTER_SIDE_OUTPUT);
                if (x == FactoryUtil.MovableResult.FAILURE) continue;
                return true;
            }
            return (Boolean)selfState.method_11654((class_2769)BLOCKING) == false;
        }
        return false;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (!oldState.method_27852(state.method_26204())) {
            this.updateEnabled(world, pos, state);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        this.updateEnabled(world, pos, state);
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
    }

    private void updateEnabled(class_1937 world, class_2338 pos, class_2680 state) {
        boolean powered = world.method_49803(pos);
        if (powered == (Boolean)state.method_11654((class_2769)ENABLED)) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(!powered)), 4);
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 below = ctx.method_8045().method_8320(ctx.method_8037().method_10074());
        class_2350 dir = below.method_26204() instanceof ConveyorBlock ? (class_2350)below.method_11654((class_2769)ConveyorBlock.DIRECTION) : ctx.method_8042();
        return this.waterLog(ctx, (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)dir));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 class_25862;
        if (!state.method_27852(newState.method_26204()) && (class_25862 = world.method_8321(pos)) instanceof SplitterBlockEntity) {
            SplitterBlockEntity be = (SplitterBlockEntity)class_25862;
            class_1264.method_5449((class_1937)world, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 0.5), (double)((double)pos.method_10260() + 0.5), (class_1799)be.getFilterRight());
            class_1264.method_5449((class_1937)world, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 0.5), (double)((double)pos.method_10260() + 0.5), (class_1799)be.getFilterLeft());
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 be = world.method_8321(pos);
        class_1268 hand = class_1268.field_5808;
        class_1799 stack = player.method_5998(hand);
        if ((stack.method_31574(FactoryItems.ITEM_FILTER) && !FilterItem.getStack(stack).method_7960() || stack.method_7960()) && hand == class_1268.field_5808 && be instanceof SplitterBlockEntity) {
            SplitterBlockEntity splitterBlockEntity = (SplitterBlockEntity)be;
            class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
            if (hit.method_17780().method_10166() != class_2350.class_2351.field_11052 && hit.method_17780().method_10166() != dir.method_10166()) {
                if (hit.method_17780() == dir.method_10160()) {
                    if (stack.method_7960()) {
                        player.method_6122(hand, splitterBlockEntity.getFilterLeft());
                        splitterBlockEntity.setFilterLeft(class_1799.field_8037);
                    } else {
                        if (!splitterBlockEntity.getFilterLeft().method_7960()) {
                            player.method_31548().method_7398(splitterBlockEntity.getFilterLeft());
                        }
                        splitterBlockEntity.setFilterLeft(stack.method_46651(1));
                        stack.method_7934(1);
                    }
                } else if (stack.method_7960()) {
                    player.method_6122(hand, splitterBlockEntity.getFilterRight());
                    splitterBlockEntity.setFilterRight(class_1799.field_8037);
                } else {
                    if (!splitterBlockEntity.getFilterRight().method_7960()) {
                        player.method_31548().method_7398(splitterBlockEntity.getFilterRight());
                    }
                    splitterBlockEntity.setFilterRight(stack.method_46651(1));
                    stack.method_7934(1);
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2470)rotation).method_10503(arg_0), FACING);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2415)mirror).method_10343(arg_0), FACING);
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, class_3222 player) {
        return class_2246.field_10360.method_9564();
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SplitterBlockEntity(pos, state);
    }

    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(world, pos, initialBlockState);
    }

    @Override
    public List<WrenchAction> getWrenchActions() {
        return List.of(WrenchAction.FACING_HORIZONTAL);
    }

    public static final class Model
    extends BlockModel {
        private final Matrix4fStack mat = new Matrix4fStack(2);
        private final ItemDisplayElement mainElement = new ItemDisplayElement();
        private final ItemDisplayElement leftLockElement;
        private final ItemDisplayElement rightLockElement;

        private Model(class_3218 world, class_2338 pos, class_2680 state) {
            this.mainElement.setDisplaySize(1.0f, 1.0f);
            this.mainElement.setModelTransformation(class_811.field_4319);
            this.mainElement.setItem(FactoryItems.SPLITTER.method_7854());
            this.mainElement.setInvisible(true);
            this.mainElement.setViewRange(0.8f);
            this.leftLockElement = new ItemDisplayElement();
            this.leftLockElement.setDisplaySize(1.0f, 1.0f);
            this.leftLockElement.setModelTransformation(class_811.field_4317);
            this.leftLockElement.setInvisible(true);
            this.leftLockElement.setViewRange(0.3f);
            this.rightLockElement = new ItemDisplayElement();
            this.rightLockElement.setDisplaySize(1.0f, 1.0f);
            this.rightLockElement.setModelTransformation(class_811.field_4317);
            this.rightLockElement.setInvisible(true);
            this.rightLockElement.setViewRange(0.3f);
            this.updateFacing(state);
            this.addElement((VirtualElement)this.mainElement);
            this.addElement((VirtualElement)this.leftLockElement);
            this.addElement((VirtualElement)this.rightLockElement);
        }

        private void updateFacing(class_2680 facing) {
            Quaternionf rot = ((class_2350)facing.method_11654((class_2769)FACING)).method_23224().mul((Quaternionfc)class_2350.field_11043.method_23224());
            this.mat.identity();
            this.mat.rotate((Quaternionfc)rot);
            this.mat.pushMatrix();
            this.mat.scale(2.0f);
            this.mat.rotateY((float)Math.PI);
            this.mainElement.setTransformation((Matrix4f)this.mat);
            this.mat.popMatrix();
            this.mat.pushMatrix();
            this.mat.translate(-0.51f, 0.4f, 0.0f);
            this.mat.rotateY(1.5707964f);
            this.mat.scale(0.3f, 0.3f, 0.02f);
            this.leftLockElement.setTransformation((Matrix4f)this.mat);
            this.mat.popMatrix();
            this.mat.pushMatrix();
            this.mat.translate(0.51f, 0.4f, 0.0f);
            this.mat.rotateY(-1.5707964f);
            this.mat.scale(0.3f, 0.3f, 0.02f);
            this.rightLockElement.setTransformation((Matrix4f)this.mat);
            this.mat.popMatrix();
            this.tick();
        }

        public void updateFilters(class_1799 filterStackLeft, class_1799 filterStackRight) {
            this.leftLockElement.setItem(filterStackLeft);
            this.rightLockElement.setItem(filterStackRight);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateFacing(this.blockState());
            }
        }
    }
}

