/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.conveyor;

import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.mechanical.conveyor.SplitterBlock;
import eu.pb4.polyfactory.util.filter.FilterData;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_7225;

public class SplitterBlockEntity
extends class_2586
implements BlockEntityExtraListener {
    private FilterData filterLeft = FilterData.EMPTY_FALSE;
    private FilterData filterRight = FilterData.EMPTY_FALSE;
    private class_1799 filterStackLeft = class_1799.field_8037;
    private class_1799 filterStackRight = class_1799.field_8037;
    private SplitterBlock.Model model;
    private boolean filtersEqual = true;
    private int position;

    public SplitterBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.SPLITTER, pos, state);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        nbt.method_10566("FilterStackLeft", this.filterStackLeft.method_57375(lookup));
        nbt.method_10566("FilterStackRight", this.filterStackRight.method_57375(lookup));
        nbt.method_10567("CurPos", (byte)this.position);
    }

    private void updateHologram() {
        if (this.model != null) {
            this.model.updateFilters(this.filterLeft.icon(), this.filterRight.icon());
            this.model.tick();
        }
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        this.filterStackLeft = class_1799.method_57359((class_7225.class_7874)lookup, (class_2487)nbt.method_10562("FilterStackLeft"));
        this.filterStackRight = class_1799.method_57359((class_7225.class_7874)lookup, (class_2487)nbt.method_10562("FilterStackRight"));
        this.filterRight = FilterData.of(this.filterStackRight, false);
        this.filterLeft = FilterData.of(this.filterStackLeft, false);
        this.filtersEqual = Objects.equals(this.filterLeft.filter(), this.filterRight.filter());
        this.position = nbt.method_10571("CurPos");
    }

    public int pos(int max) {
        int c = this.position + 1;
        if (c >= max) {
            c = 0;
        }
        this.position = c;
        this.method_5431();
        return c;
    }

    public boolean matchesLeft(class_1799 stack) {
        return this.filterLeft.test(stack);
    }

    public boolean matchesRight(class_1799 stack) {
        return this.filterRight.test(stack);
    }

    public void method_11012() {
        super.method_11012();
    }

    public class_1799 getFilterLeft() {
        return this.filterStackLeft;
    }

    public void setFilterLeft(class_1799 stack) {
        this.filterStackLeft = stack;
        this.filterLeft = FilterData.of(stack, false);
        this.filtersEqual = Objects.equals(this.filterLeft.filter(), this.filterRight.filter());
        this.method_5431();
        this.updateHologram();
    }

    public class_1799 getFilterRight() {
        return this.filterStackRight;
    }

    public void setFilterRight(class_1799 stack) {
        this.filterStackRight = stack;
        this.filterRight = FilterData.of(stack, false);
        this.filtersEqual = Objects.equals(this.filterLeft.filter(), this.filterRight.filter());
        this.method_5431();
        this.updateHologram();
    }

    public void onListenerUpdate(class_2818 chunk) {
        SplitterBlock.Model model;
        ElementHolder elementHolder = BlockBoundAttachment.get((class_2818)chunk, (class_2338)this.field_11867).holder();
        this.model = elementHolder instanceof SplitterBlock.Model ? (model = (SplitterBlock.Model)elementHolder) : null;
        this.updateHologram();
    }

    public boolean matchesSides(class_1799 stack) {
        return this.filtersEqual && this.filterLeft.test(stack);
    }

    public boolean filtersEmpty() {
        return this.filtersEqual && this.filterLeft.isEmpty();
    }

    public boolean isLeftFilterEmpty() {
        return this.filterLeft.isEmpty();
    }

    public boolean isRightFilterEmpty() {
        return this.filterRight.isEmpty();
    }
}

