/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.machines.crafting;

import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.factorytools.api.recipe.OutputStack;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.machines.crafting.GrinderBlock;
import eu.pb4.polyfactory.block.other.MachineInfoProvider;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.polydex.PolydexCompat;
import eu.pb4.polyfactory.recipe.FactoryRecipeTypes;
import eu.pb4.polyfactory.recipe.GrindingRecipe;
import eu.pb4.polyfactory.recipe.input.GrindingInput;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.inventory.MinimalSidedInventory;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1719;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class GrinderBlockEntity
extends LockableBlockEntity
implements MinimalSidedInventory,
MachineInfoProvider {
    public static final int INPUT_SLOT = 0;
    private static final int[] INPUT_SLOTS = new int[]{0};
    private static final int[] OUTPUT_SLOTS = new int[]{1, 2, 3};
    private final class_2371<class_1799> stacks = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    protected double process = 0.0;
    @Nullable
    protected class_8786<GrindingRecipe> currentRecipe = null;
    @Nullable
    protected class_1792 currentItem = null;
    private boolean active;
    private double speedScale;
    private class_2561 state = null;

    public GrinderBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.GRINDER, pos, state);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        class_1262.method_5426((class_2487)nbt, this.stacks, (class_7225.class_7874)lookup);
        nbt.method_10549("Progress", this.process);
        super.method_11007(nbt, lookup);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        class_1262.method_5429((class_2487)nbt, this.stacks, (class_7225.class_7874)lookup);
        this.process = nbt.method_10574("Progress");
        super.method_11014(nbt, lookup);
    }

    @Override
    public class_2371<class_1799> getStacks() {
        return this.stacks;
    }

    public int[] method_5494(class_2350 side) {
        class_2350 facing = (class_2350)this.method_11010().method_11654(GrinderBlock.INPUT_FACING);
        return facing.method_10153() == side || side == class_2350.field_11033 ? OUTPUT_SLOTS : INPUT_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot == 0;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot != 0;
    }

    public void createGui(class_3222 player) {
        new Gui(player);
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        GrinderBlockEntity self = (GrinderBlockEntity)t;
        class_1799 stack = self.method_5438(0);
        self.state = null;
        if (stack.method_7960()) {
            self.process = 0.0;
            self.active = false;
            self.speedScale = 0.0;
            return;
        }
        if (self.currentRecipe == null && self.currentItem != null && stack.method_31574(self.currentItem)) {
            self.process = 0.0;
            self.active = false;
            self.speedScale = 0.0;
            self.state = INCORRECT_ITEMS_TEXT;
            return;
        }
        GrindingInput input = new GrindingInput((class_1799)self.stacks.get(0));
        if (self.currentItem == null || !stack.method_31574(self.currentItem)) {
            self.process = 0.0;
            self.speedScale = 0.0;
            self.currentItem = stack.method_7909();
            self.currentRecipe = world.method_8433().method_8132(FactoryRecipeTypes.GRINDING, (class_9695)input, world).orElse(null);
            if (self.currentRecipe == null) {
                self.active = false;
                self.state = INCORRECT_ITEMS_TEXT;
                return;
            }
        }
        self.active = true;
        assert (self.currentRecipe != null);
        if (self.process >= ((GrindingRecipe)self.currentRecipe.comp_1933()).grindTime()) {
            class_3414 class_34142;
            ArrayList<class_1799> items = new ArrayList<class_1799>();
            for (OutputStack out : ((GrindingRecipe)self.currentRecipe.comp_1933()).output()) {
                for (int a = 0; a < out.roll(); ++a) {
                    items.add(out.stack().method_7972());
                }
            }
            class_1277 inv = new class_1277(3);
            for (int i = 0; i < 3; ++i) {
                inv.method_5447(i, self.method_5438(i + 1).method_7972());
            }
            class_1792 i = items.iterator();
            while (i.hasNext()) {
                class_1799 item = (class_1799)i.next();
                FactoryUtil.tryInsertingInv((class_1263)inv, item, null);
                if (item.method_7960()) continue;
                self.state = OUTPUT_FULL_TEXT;
                return;
            }
            inv = FactoryUtil.getClosestPlayer(world, pos, 32.0);
            if (inv instanceof class_3222) {
                class_3222 player = (class_3222)inv;
                class_174.field_44587.method_51350(player, self.currentRecipe.comp_1932(), self.stacks.subList(0, 1));
            }
            if ((i = stack.method_7909()) instanceof class_1747) {
                class_1747 blockItem = (class_1747)i;
                class_34142 = blockItem.method_7711().method_9564().method_26231().method_10595();
            } else {
                class_34142 = class_3417.field_15026;
            }
            class_3414 sound = class_34142;
            world.method_8396(null, pos, sound, class_3419.field_15245, 0.6f, 0.5f);
            self.process = 0.0;
            stack.method_7934(1);
            for (OutputStack out : ((GrindingRecipe)self.currentRecipe.comp_1933()).output()) {
                for (int a = 0; a < out.roll(); ++a) {
                    if (!(world.field_9229.method_43057() < out.chance())) continue;
                    FactoryUtil.insertBetween((class_1263)self, 1, 4, out.stack().method_7972());
                }
            }
            self.method_5431();
        } else {
            double speed;
            double d = Math.max(((GrindingRecipe)self.currentRecipe.comp_1933()).optimalSpeed() - ((GrindingRecipe)self.currentRecipe.comp_1933()).minimumSpeed(), 1.0);
            RotationData rot = RotationUser.getRotation((class_1937)((class_3218)world), pos);
            self.speedScale = speed = Math.min(Math.max(Math.abs(rot.speed()) - ((GrindingRecipe)self.currentRecipe.comp_1933()).minimumSpeed(), 0.0), d) / d / 20.0;
            if (speed > 0.0) {
                if (world.method_8510() % class_3532.method_53062((long)Math.round(1.0 / speed), (long)2L, (long)5L) == 0L) {
                    ((class_3218)world).method_14199((class_2394)new class_2392(class_2398.field_11218, stack.method_7972()), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.15, (double)pos.method_10260() + 0.5, 0, (Math.random() - 0.5) * 0.2, 0.02, (Math.random() - 0.5) * 0.2, 2.0);
                }
                if (world.method_8510() % 20L == 0L) {
                    class_3414 class_34143;
                    class_1792 class_17922 = stack.method_7909();
                    if (class_17922 instanceof class_1747) {
                        class_1747 blockItem = (class_1747)class_17922;
                        class_34143 = blockItem.method_7711().method_9564().method_26231().method_10596();
                    } else {
                        class_34143 = class_3417.field_14658;
                    }
                    class_3414 sound = class_34143;
                    world.method_8396(null, pos, sound, class_3419.field_15245, 0.5f, 0.5f);
                }
                self.process += speed;
                self.method_5431();
                return;
            }
            if (world.method_8510() % 5L == 0L) {
                ((class_3218)world).method_14199((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.3, (double)pos.method_10260() + 0.5, 0, (Math.random() - 0.5) * 0.2, 0.04, (Math.random() - 0.5) * 0.2, 0.3);
            }
            self.state = rot.getStateTextOrElse(TOO_SLOW_TEXT);
        }
    }

    public double getStress() {
        if (this.active) {
            return this.currentRecipe != null ? class_3532.method_15350((double)(((GrindingRecipe)this.currentRecipe.comp_1933()).optimalSpeed() * 0.7 * this.speedScale), (double)(((GrindingRecipe)this.currentRecipe.comp_1933()).minimumSpeed() * 0.7), (double)(((GrindingRecipe)this.currentRecipe.comp_1933()).optimalSpeed() * 0.7)) : 1.0;
        }
        return 0.0;
    }

    @Override
    @Nullable
    public class_2561 getCurrentState() {
        return this.state;
    }

    private class Gui
    extends SimpleGui {
        public Gui(class_3222 player) {
            super(class_3917.field_17326, player, false);
            this.setTitle(GuiTextures.GRINDER.apply((class_2561)GrinderBlockEntity.this.method_11010().method_26204().method_9518()));
            this.setSlot(9, (GuiElementInterface)PolydexCompat.getButton(FactoryRecipeTypes.GRINDING));
            this.setSlotRedirect(4, new class_1735((class_1263)GrinderBlockEntity.this, 0, 0, 0));
            this.setSlot(13, (GuiElementInterface)GuiTextures.PROGRESS_VERTICAL.get(this.progress()));
            this.setSlotRedirect(21, (class_1735)new class_1719((class_1657)player, (class_1263)GrinderBlockEntity.this, 1, 1, 0));
            this.setSlotRedirect(22, (class_1735)new class_1719((class_1657)player, (class_1263)GrinderBlockEntity.this, 2, 2, 0));
            this.setSlotRedirect(23, (class_1735)new class_1719((class_1657)player, (class_1263)GrinderBlockEntity.this, 3, 3, 0));
            this.open();
        }

        private float progress() {
            return GrinderBlockEntity.this.currentRecipe != null ? (float)class_3532.method_15350((double)(GrinderBlockEntity.this.process / ((GrindingRecipe)GrinderBlockEntity.this.currentRecipe.comp_1933()).grindTime()), (double)0.0, (double)1.0) : 0.0f;
        }

        public void onTick() {
            if (this.player.method_19538().method_1025(class_243.method_24953((class_2382)GrinderBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            this.setSlot(13, (GuiElementInterface)GuiTextures.PROGRESS_VERTICAL.get(this.progress()));
            super.onTick();
        }
    }
}

