/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.machines.crafting;

import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.machines.crafting.MCrafterBlock;
import eu.pb4.polyfactory.block.other.MachineInfoProvider;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.polydex.PolydexCompat;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.GuiUtils;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.inventory.CustomInsertInventory;
import eu.pb4.polyfactory.util.inventory.MinimalSidedInventory;
import eu.pb4.polyfactory.util.inventory.WrappingInputRecipeInput;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1713;
import net.minecraft.class_1719;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class MCrafterBlockEntity
extends LockableBlockEntity
implements MachineInfoProvider,
MinimalSidedInventory,
CustomInsertInventory,
class_8566 {
    private static final int[] INPUT_SLOTS = IntStream.range(0, 9).toArray();
    private static final int[] OUTPUT_SLOTS = IntStream.range(9, 18).toArray();
    private static final class_3414 CRAFT_SOUND_EVENT = class_3414.method_47908((class_2960)class_2960.method_60654((String)"minecraft:block.crafter.craft"));
    private final class_2371<class_1799> stacks = class_2371.method_10213((int)18, (Object)class_1799.field_8037);
    private BitSet lockedSlots = new BitSet(9);
    protected double process = 0.0;
    @Nullable
    protected class_8786<class_3955> currentRecipe = null;
    private boolean active;
    private boolean itemsDirty;
    private final class_8566 recipeInputProvider = WrappingInputRecipeInput.of(this, 0, 9, 3, 3);
    @Nullable
    private class_2561 state;

    public MCrafterBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.CRAFTER, pos, state);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        class_1262.method_5426((class_2487)nbt, this.stacks, (class_7225.class_7874)lookup);
        nbt.method_10549("progress", this.process);
        nbt.method_10570("locked_slots", this.lockedSlots.toByteArray());
        super.method_11007(nbt, lookup);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        class_1262.method_5429((class_2487)nbt, this.stacks, (class_7225.class_7874)lookup);
        this.process = nbt.method_10574("progress");
        this.lockedSlots = BitSet.valueOf(nbt.method_10547("locked_slots"));
        super.method_11014(nbt, lookup);
    }

    @Override
    public class_2371<class_1799> getStacks() {
        return this.stacks;
    }

    public int[] method_5494(class_2350 side) {
        class_2350 facing = (class_2350)this.method_11010().method_11654(MCrafterBlock.FACING);
        return facing == side || side == class_2350.field_11033 ? OUTPUT_SLOTS : INPUT_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (this.lockedSlots.get(slot)) {
            return false;
        }
        if (dir != null && (dir == class_2350.field_11036 || dir.method_10153() == this.method_11010().method_11654(MCrafterBlock.FACING))) {
            return this.getLeastPopulatedInputSlot(stack) == slot;
        }
        return slot < 9;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot >= 9 && (dir == this.method_11010().method_11654(MCrafterBlock.FACING) || dir == class_2350.field_11033) || slot < 9 && ((class_2350)this.method_11010().method_11654(MCrafterBlock.FACING)).method_10170().method_10166() == dir.method_10166();
    }

    private int getLeastPopulatedInputSlot(class_1799 stack) {
        if (stack.method_7960()) {
            return -1;
        }
        int slot = -1;
        int count = 9999;
        for (int i = 0; i < 9; ++i) {
            if (this.lockedSlots.get(i)) continue;
            class_1799 cur = this.method_5438(i);
            if (cur.method_7960()) {
                return i;
            }
            if (!class_1799.method_31577((class_1799)cur, (class_1799)stack) || count <= cur.method_7947() || cur.method_7947() >= cur.method_7914()) continue;
            count = cur.method_7947();
            slot = i;
        }
        return slot;
    }

    public void createGui(class_3222 player) {
        new Gui(player);
    }

    public void method_5431() {
        this.itemsDirty = true;
        super.method_5431();
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        MCrafterBlockEntity self = (MCrafterBlockEntity)t;
        self.state = null;
        if (self.isInputNotFull()) {
            self.process = 0.0;
            self.active = false;
            return;
        }
        class_9694 input = self.recipeInputProvider.method_59961();
        if (self.currentRecipe == null || self.itemsDirty && !((class_3955)self.currentRecipe.comp_1933()).method_8115((class_9695)input, world)) {
            self.process = 0.0;
            self.currentRecipe = world.method_8433().method_8132(class_3956.field_17545, (class_9695)input, world).orElse(null);
            self.itemsDirty = false;
            if (self.currentRecipe == null) {
                self.state = INCORRECT_ITEMS_TEXT;
                self.active = false;
                return;
            }
        }
        self.active = true;
        assert (self.currentRecipe != null);
        if (self.process >= 8.0) {
            class_1799 output = ((class_3955)self.currentRecipe.comp_1933()).method_8116((class_9695)input, (class_7225.class_7874)world.method_30349());
            class_2371 remainder = ((class_3955)self.currentRecipe.comp_1933()).method_8111((class_9695)input);
            ArrayList<class_1799> items = new ArrayList<class_1799>();
            items.add(output.method_7972());
            for (class_1799 stack : remainder) {
                items.add(stack.method_7972());
            }
            class_1277 inv = new class_1277(9);
            for (int i = 0; i < 9; ++i) {
                inv.method_5447(i, self.method_5438(i + 9).method_7972());
            }
            for (class_1799 item : items) {
                FactoryUtil.tryInsertingInv((class_1263)inv, item, null);
                if (item.method_7960()) continue;
                self.state = OUTPUT_FULL_TEXT;
                return;
            }
            inv = FactoryUtil.getClosestPlayer(world, pos, 32.0);
            if (inv instanceof class_3222) {
                class_3222 player = (class_3222)inv;
                TriggerCriterion.trigger((class_3222)player, (class_2960)FactoryTriggers.CRAFTER_CRAFTS);
                if (output.method_31574(FactoryItems.CRAFTER)) {
                    TriggerCriterion.trigger((class_3222)player, (class_2960)FactoryTriggers.CRAFTER_CRAFTS_CRAFTER);
                }
                class_174.field_44587.method_51350(player, self.currentRecipe.comp_1932(), self.stacks.subList(0, 9));
            }
            for (int i = 0; i < 9; ++i) {
                class_1799 stack = self.method_5438(i);
                if (stack.method_7960()) continue;
                stack.method_7934(1);
                if (!stack.method_7960()) continue;
                self.method_5447(i, class_1799.field_8037);
            }
            world.method_8396(null, pos, CRAFT_SOUND_EVENT, class_3419.field_15245, 0.6f, 0.5f);
            self.process = 0.0;
            items = new ArrayList<class_1799>();
            items.add(output);
            items.addAll((Collection<class_1799>)remainder);
            block4: for (class_1799 out : items) {
                for (int i = 9; i < 18; ++i) {
                    class_1799 c = self.method_5438(i);
                    if (c.method_7960()) {
                        self.method_5447(i, out);
                        continue block4;
                    }
                    if (class_1799.method_31577((class_1799)c, (class_1799)out)) {
                        int count = Math.min(c.method_7914() - c.method_7947(), out.method_7947());
                        c.method_7933(count);
                        out.method_7934(count);
                    }
                    if (out.method_7960()) continue block4;
                }
            }
            self.method_5431();
        } else {
            RotationData rot = RotationUser.getRotation(world, pos);
            double speed = Math.min(rot.speed() / 40.0, 1.0);
            if (speed > 0.05) {
                self.process += speed;
                self.method_5431();
                return;
            }
            if (world.method_8510() % 5L == 0L) {
                ((class_3218)world).method_14199((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, 0, (Math.random() - 0.5) * 0.2, 0.04, (Math.random() - 0.5) * 0.2, 0.3);
            }
            self.state = rot.getStateTextOrElse(TOO_SLOW_TEXT);
        }
    }

    private boolean isInputNotFull() {
        int full = 0;
        int locked = 0;
        for (int i = 0; i < 9; ++i) {
            if (this.lockedSlots.get(i)) {
                ++locked;
                ++full;
                continue;
            }
            if (this.method_5438(i).method_7960()) continue;
            ++full;
        }
        return full < 9 || locked == 9;
    }

    public double getStress() {
        if (this.active) {
            return this.currentRecipe != null ? 6.0 : 3.0;
        }
        return 0.0;
    }

    public int method_17398() {
        return 3;
    }

    public int method_17397() {
        return 3;
    }

    public List<class_1799> method_51305() {
        return List.copyOf(this.stacks.subList(0, 9));
    }

    public void method_7683(class_1662 finder) {
        for (int i = 0; i < 9; ++i) {
            finder.method_7404(this.method_5438(i));
        }
    }

    @Override
    public int insertStack(class_1799 itemStack, class_2350 direction) {
        int init = itemStack.method_7947();
        while (!itemStack.method_7960()) {
            int slot = this.getLeastPopulatedInputSlot(itemStack);
            if (slot == -1) {
                return init - itemStack.method_7947();
            }
            class_1799 current = this.method_5438(slot);
            if (current.method_7960()) {
                this.method_5447(slot, itemStack.method_46651(1));
                itemStack.method_7934(1);
                continue;
            }
            current.method_7933(1);
            itemStack.method_7934(1);
        }
        return init;
    }

    @Override
    @Nullable
    public class_2561 getCurrentState() {
        return this.state;
    }

    private class Gui
    extends SimpleGui {
        private final BitSet lockedSlots;

        public Gui(class_3222 player) {
            super(class_3917.field_17326, player, false);
            this.lockedSlots = (BitSet)MCrafterBlockEntity.this.lockedSlots.clone();
            this.setTitle(GuiTextures.CRAFTER.apply((class_2561)MCrafterBlockEntity.this.method_11010().method_26204().method_9518()));
            this.setSlot(9, (GuiElementInterface)PolydexCompat.getButton(class_3956.field_17545));
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    this.setLockableSlot(x + y * 9 + 1, x + y * 3, x, y);
                    this.setSlotRedirect(x + y * 9 + 5, (class_1735)new class_1719((class_1657)player, (class_1263)MCrafterBlockEntity.this, 9 + x + y * 3, x, y + 3));
                }
            }
            this.setSlot(13, (GuiElementInterface)GuiTextures.PROGRESS_HORIZONTAL.get(this.progress()));
            this.open();
        }

        private void setLockableSlot(int uiIndex, int slot, int x, int y) {
            if (this.lockedSlots.get(slot)) {
                this.setSlot(uiIndex, (GuiElementBuilderInterface)GuiTextures.LOCKED_SLOT.get());
            } else {
                this.setSlotRedirect(uiIndex, new class_1735((class_1263)MCrafterBlockEntity.this, x + y * 3, x, y));
            }
        }

        public boolean onAnyClick(int index, ClickType type, class_1713 action) {
            int x = index % 9 - 1;
            int y = index / 9;
            if (x >= 0 && y >= 0 && x < 3 && y < 3) {
                int slot = x + y * 3;
                boolean locked = MCrafterBlockEntity.this.lockedSlots.get(slot);
                if (locked) {
                    MCrafterBlockEntity.this.lockedSlots.set(slot, false);
                    GuiUtils.playClickSound(this.player);
                    return true;
                }
                if (MCrafterBlockEntity.this.method_5438(slot).method_7960() && this.getPlayer().field_7512.method_34255().method_7960()) {
                    MCrafterBlockEntity.this.lockedSlots.set(slot, true);
                    GuiUtils.playClickSound(this.player);
                    return true;
                }
            }
            return super.onAnyClick(index, type, action);
        }

        private float progress() {
            return MCrafterBlockEntity.this.currentRecipe != null ? (float)class_3532.method_15350((double)(MCrafterBlockEntity.this.process / 8.0), (double)0.0, (double)1.0) : 0.0f;
        }

        public void onTick() {
            if (this.player.method_19538().method_1025(class_243.method_24953((class_2382)MCrafterBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    int i = x + y * 3;
                    if (this.lockedSlots.get(i) == MCrafterBlockEntity.this.lockedSlots.get(i)) continue;
                    this.lockedSlots.flip(i);
                    this.setLockableSlot(x + y * 9 + 1, i, x, y);
                }
            }
            this.setSlot(13, (GuiElementInterface)GuiTextures.PROGRESS_HORIZONTAL.get(this.progress()));
            super.onTick();
        }
    }
}

