/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.source;

import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.mechanical.source.SteamEngineBlock;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.ui.FuelSlot;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.inventory.MinimalSidedInventory;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class SteamEngineBlockEntity
extends LockableBlockEntity
implements MinimalSidedInventory {
    private static final int[] SLOTS = new int[]{0, 1, 2};
    public float state = 0.0f;
    public int fuelTicks = 0;
    public int fuelInitial = 1;
    private final class_2371<class_1799> items = class_2371.method_10213((int)3, (Object)class_1799.field_8037);

    public SteamEngineBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.STEAM_ENGINE, pos, state);
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        SteamEngineBlockEntity self = (SteamEngineBlockEntity)t;
        if (self.fuelTicks > 0) {
            self.fuelTicks -= class_3532.method_48781((float)self.state, (int)40, (int)16);
            self.state = (float)Math.min((double)self.state + 0.005, 1.0);
            if (!((Boolean)state.method_11654((class_2769)SteamEngineBlock.LIT)).booleanValue()) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(true)));
            }
            self.method_5431();
            if ((world.method_8510() + (long)pos.method_10263() * 3L + (long)pos.method_10264() * 7L + (long)pos.method_10260() * 5L) % (long)class_3532.method_15340((int)Math.round(2.0f / self.state), (int)4, (int)8) == 0L) {
                class_2350 facing = (class_2350)state.method_11654((class_2769)SteamEngineBlock.FACING);
                class_243 a = new class_243((double)pos.method_10263() + 0.5 + (double)(facing.method_10166() == class_2350.class_2351.field_11051 ? 0.5f : 0.0f), (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5 + (double)(facing.method_10166() == class_2350.class_2351.field_11048 ? 0.5f : 0.0f));
                ((class_3218)world).method_14199((class_2394)class_2398.field_11204, a.field_1352 + (double)world.field_9229.method_43057() - 0.5, a.field_1351 + (double)world.field_9229.method_43057() - 0.5, a.field_1350 + (double)world.field_9229.method_43057() - 0.5, 0, 0.0, 1.0, 0.0, 0.1);
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                Integer value;
                class_1799 stack = self.method_5438(i);
                if (stack.method_7960() || (value = (Integer)FuelRegistry.INSTANCE.get((class_1935)stack.method_7909())) == null) continue;
                class_1799 remainder = stack.getRecipeRemainder();
                stack.method_7934(1);
                self.fuelInitial = self.fuelTicks = value * 10;
                if (stack.method_7960()) {
                    self.method_5447(i, class_1799.field_8037);
                }
                if (!remainder.method_7960()) {
                    FactoryUtil.tryInsertingRegular((class_1263)self, remainder);
                    if (!remainder.method_7960()) {
                        class_1264.method_5449((class_1937)world, (double)((double)pos.method_10263() + 0.5), (double)pos.method_10264(), (double)((double)pos.method_10260() + 0.5), (class_1799)remainder);
                    }
                }
                self.method_5431();
                return;
            }
            if (self.state != 0.0f) {
                self.state = (float)Math.max((double)self.state - 0.02, 0.0);
                self.method_5431();
            }
            if (((Boolean)state.method_11654((class_2769)SteamEngineBlock.LIT)).booleanValue()) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        class_1262.method_5426((class_2487)nbt, this.items, (class_7225.class_7874)lookup);
        nbt.method_10569("FuelTicks", this.fuelTicks);
        nbt.method_10569("FuelInitial", this.fuelInitial);
        nbt.method_10548("State", this.state);
        super.method_11007(nbt, lookup);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        class_1262.method_5429((class_2487)nbt, this.items, (class_7225.class_7874)lookup);
        this.fuelInitial = nbt.method_10550("FuelInitial");
        this.fuelTicks = nbt.method_10550("FuelTicks");
        this.state = nbt.method_10583("State");
        super.method_11014(nbt, lookup);
    }

    public void updateRotationalData(RotationData.State modifier, class_2680 state, class_3218 serverWorld, class_2338 pos) {
        if (this.state > 0.0f) {
            modifier.provide(30.0f * this.state, 110.0f * this.state, ((class_2350)state.method_11654((class_2769)SteamEngineBlock.FACING)).method_10171());
        }
    }

    @Override
    public class_2371<class_1799> getStacks() {
        return this.items;
    }

    public int[] method_5494(class_2350 side) {
        return SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return class_2609.method_11195((class_1799)stack);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    public void createGui(class_3222 player) {
        new Gui(player);
    }

    private class Gui
    extends SimpleGui {
        private boolean active;

        public Gui(class_3222 player) {
            super(class_3917.field_18665, player, false);
            this.setTitle(GuiTextures.STEAM_ENGINE.apply((class_2561)SteamEngineBlockEntity.this.method_11010().method_26204().method_9518()));
            this.setSlotRedirect(12, new FuelSlot((class_1263)SteamEngineBlockEntity.this, 0, 0, 0));
            this.setSlotRedirect(13, new FuelSlot((class_1263)SteamEngineBlockEntity.this, 1, 1, 0));
            this.setSlotRedirect(14, new FuelSlot((class_1263)SteamEngineBlockEntity.this, 2, 2, 0));
            this.setSlot(4, (GuiElementInterface)GuiTextures.FLAME.get(this.progress()));
            this.active = SteamEngineBlockEntity.this.fuelTicks > 0;
            this.open();
        }

        private float progress() {
            return SteamEngineBlockEntity.this.fuelInitial > 0 ? class_3532.method_15363((float)((float)SteamEngineBlockEntity.this.fuelTicks / (float)SteamEngineBlockEntity.this.fuelInitial), (float)0.0f, (float)1.0f) : 0.0f;
        }

        public void onTick() {
            boolean active;
            if (this.player.method_19538().method_1025(class_243.method_24953((class_2382)SteamEngineBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            boolean bl = active = SteamEngineBlockEntity.this.fuelTicks > 0;
            if (!this.active && active) {
                this.active = true;
                TriggerCriterion.trigger((class_3222)this.player, (class_2960)FactoryTriggers.FUEL_STEAM_ENGINE);
            }
            this.setSlot(4, (GuiElementInterface)GuiTextures.FLAME.get(this.progress()));
            super.onTick();
        }
    }
}

