/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.source;

import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.mechanical.source.WindmillBlock;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.other.FactoryBiomeTags;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class WindmillBlockEntity
extends class_2586 {
    private static final double LOG_BASE = Math.log(2.0);
    private final class_2371<class_1799> sails = class_2371.method_10211();
    private int sample = Integer.MIN_VALUE;

    public WindmillBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.WINDMILL, pos, state);
        for (int i = 0; i < (Integer)state.method_11654((class_2769)WindmillBlock.SAIL_COUNT); ++i) {
            this.sails.add((Object)new class_1799((class_1935)FactoryItems.WINDMILL_SAIL));
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        class_2499 list = new class_2499();
        for (class_1799 sail : this.sails) {
            list.add((Object)sail.method_57375(lookup));
        }
        nbt.method_10566("Sails", (class_2520)list);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        this.sails.clear();
        for (class_2520 sail : nbt.method_10554("Sails", 10)) {
            this.sails.add((Object)class_1799.method_57359((class_7225.class_7874)lookup, (class_2487)((class_2487)sail)));
        }
    }

    public boolean addSail(int i, class_1799 stack) {
        if (stack.method_31574((class_1792)FactoryItems.WINDMILL_SAIL)) {
            if (i < this.sails.size()) {
                this.sails.set(i, (Object)stack.method_46651(1));
            } else {
                this.sails.add((Object)stack.method_46651(1));
            }
            stack.method_7934(1);
            this.method_5431();
            BlockBoundAttachment model = BlockBoundAttachment.get((class_1937)this.field_11863, (class_2338)this.field_11867);
            if (model != null) {
                ((WindmillBlock.Model)model.holder()).updateSailsBe();
            }
            return true;
        }
        return false;
    }

    public int getSailColor(int i) {
        class_1799 sail;
        if (i < this.sails.size() && (sail = (class_1799)this.sails.get(i)).method_57826(class_9334.field_49644)) {
            return ((class_9282)sail.method_57824(class_9334.field_49644)).comp_2384();
        }
        return 0xFFFFFF;
    }

    public class_2371<class_1799> getSails() {
        return this.sails;
    }

    public void updateRotationalData(RotationData.State modifier, class_2680 state, class_3218 serverWorld, class_2338 pos) {
        if (((Boolean)state.method_11654((class_2769)WindmillBlock.WATERLOGGED)).booleanValue()) {
            return;
        }
        int baseHeight = this.sample;
        if (baseHeight == Integer.MIN_VALUE) {
            this.sample = baseHeight = serverWorld.method_14178().method_12129().method_20402(pos.method_10263(), pos.method_10260(), class_2902.class_2903.field_13197, (class_5539)serverWorld, serverWorld.method_14178().method_41248());
        }
        Integer sails = (Integer)state.method_11654((class_2769)WindmillBlock.SAIL_COUNT);
        double x = serverWorld.method_27983().equals(class_1937.field_25180) ? 32.0 - (double)Math.abs(pos.method_10264() - 64) / 2.0 : (serverWorld.method_27983().equals(class_1937.field_25181) ? 5.0 : (double)(pos.method_10264() - baseHeight - 2));
        if (x <= 0.0 || sails < 2) {
            modifier.stress(0.15);
            return;
        }
        double speed = Math.min(Math.log(x) / LOG_BASE * 2.1, 10.5);
        if (speed <= 0.0) {
            return;
        }
        class_6880 biome = serverWorld.method_23753(pos);
        if (biome.method_40220(FactoryBiomeTags.WINDMILL_HIGH_SPEED_BONUS)) {
            speed *= 1.35;
        } else if (biome.method_40220(FactoryBiomeTags.WINDMILL_MIDDLE_SPEED_BONUS)) {
            speed *= 1.2;
        } else if (biome.method_40220(FactoryBiomeTags.WINDMILL_LOW_SPEED_BONUS)) {
            speed *= 1.08;
        }
        if (serverWorld.method_8419()) {
            speed *= 1.1;
        }
        modifier.provide(speed, class_3532.method_15350((double)(speed * 0.15 * (double)sails.intValue() * 1.2), (double)0.5, (double)18.0), false);
    }
}

