/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.network;

import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.nodes.FactoryNodes;
import eu.pb4.polyfactory.nodes.data.DataStorage;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.nodes.pipe.FlowData;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public interface NetworkComponent {

    public static interface Energy
    extends NetworkComponent {
        public static void updateEnergyAt(class_1936 world, class_2338 pos) {
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                FactoryNodes.ENERGY.getGraphWorld(serverWorld).updateNodes(pos);
            }
        }

        public Collection<BlockNode> createEnergyNodes(class_2680 var1, class_3218 var2, class_2338 var3);
    }

    public static interface Data
    extends NetworkComponent {
        public static void updateDataAt(class_1936 world, class_2338 pos) {
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                FactoryNodes.DATA.getGraphWorld(serverWorld).updateNodes(pos);
            }
        }

        public Collection<BlockNode> createDataNodes(class_2680 var1, class_3218 var2, class_2338 var3);

        public static DataStorage getLogic(class_3218 world, class_2338 pos) {
            Optional o = FactoryNodes.DATA.getGraphWorld(world).getNodesAt(pos).findFirst();
            if (o.isPresent()) {
                return (DataStorage)((NodeHolder)o.get()).getGraph().getGraphEntity(DataStorage.TYPE);
            }
            return DataStorage.EMPTY;
        }

        public static DataStorage getLogic(class_3218 world, class_2338 pos, Predicate<NodeHolder<BlockNode>> predicate) {
            Optional<NodeHolder<BlockNode>> o = FactoryNodes.DATA.getGraphWorld(world).getNodesAt(pos).filter(predicate).findFirst();
            if (o.isPresent()) {
                return (DataStorage)o.get().getGraph().getGraphEntity(DataStorage.TYPE);
            }
            return DataStorage.EMPTY;
        }
    }

    public static interface RotationalConnector
    extends NetworkComponent {
        public static void updateRotationalConnectorAt(class_1936 world, class_2338 pos) {
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                FactoryNodes.ROTATIONAL_CONNECTOR.getGraphWorld(serverWorld).updateNodes(pos);
            }
        }

        public Collection<BlockNode> createRotationalConnectorNodes(class_2680 var1, class_3218 var2, class_2338 var3);
    }

    public static interface Pipe
    extends NetworkComponent {
        public static void updatePipeAt(class_1936 world, class_2338 pos) {
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                FactoryNodes.PIPE.getGraphWorld(serverWorld).updateNodes(pos);
            }
        }

        public Collection<BlockNode> createPipeNodes(class_2680 var1, class_3218 var2, class_2338 var3);

        public static FlowData getLogic(class_3218 world, class_2338 pos) {
            Optional o = FactoryNodes.PIPE.getGraphWorld(world).getNodesAt(pos).findFirst();
            if (o.isPresent()) {
                return (FlowData)((NodeHolder)o.get()).getGraph().getGraphEntity(FlowData.TYPE);
            }
            return FlowData.EMPTY;
        }

        public static void forEachLogic(class_3218 world, class_2338 pos, Consumer<FlowData> consumer) {
            FactoryNodes.PIPE.getGraphWorld(world).getNodesAt(pos).forEach(x -> consumer.accept((FlowData)x.getGraph().getGraphEntity(FlowData.TYPE)));
        }
    }

    public static interface Rotational
    extends NetworkComponent {
        public static void updateRotationalAt(class_1936 world, class_2338 pos) {
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                FactoryNodes.ROTATIONAL.getGraphWorld(serverWorld).updateNodes(pos);
            }
        }

        public Collection<BlockNode> createRotationalNodes(class_2680 var1, class_3218 var2, class_2338 var3);

        public static RotationData getLogic(class_3218 world, class_2338 pos) {
            return RotationUser.getRotation((class_1937)world, pos);
        }
    }
}

