/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.other;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.other.ContainerBlock;
import eu.pb4.polyfactory.block.other.FilledStateProvider;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3551;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class ContainerBlockEntity
extends LockableBlockEntity
implements BlockEntityExtraListener,
FilledStateProvider {
    private class_1799 itemStack = class_1799.field_8037;
    private ContainerBlock.Model model;
    public final SingleItemStorage storage = this.createStorage();

    public ContainerBlockEntity(class_2338 pos, class_2680 state) {
        this(FactoryBlockEntities.CONTAINER, pos, state);
    }

    protected ContainerBlockEntity(class_2591<? extends ContainerBlockEntity> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected SingleItemStorage createStorage() {
        return new SingleItemStorage(){

            protected long getCapacity(ItemVariant variant) {
                return ContainerBlockEntity.this.getMaxCount(ContainerBlockEntity.this.itemStack);
            }

            public long extract(ItemVariant extractedVariant, long maxAmount, TransactionContext transaction) {
                ItemVariant v = (ItemVariant)this.variant;
                long i = super.extract((TransferVariant)extractedVariant, maxAmount, transaction);
                this.variant = v;
                return i;
            }

            protected void onFinalCommit() {
                super.onFinalCommit();
                ContainerBlockEntity.this.method_5431();
                ContainerBlockEntity.this.field_11863.method_8455(ContainerBlockEntity.this.field_11867, ContainerBlockEntity.this.method_11010().method_26204());
                ContainerBlockEntity.this.updateStackWithTick();
            }
        };
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        this.storage.writeNbt(nbt, lookup);
        super.method_11007(nbt, lookup);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        try {
            if (nbt.method_10562("variant").method_10545("tag")) {
                class_2487 hack = new class_2487();
                class_2487 variant = nbt.method_10562("variant");
                hack.method_10566("tag", variant.method_10580("tag"));
                hack.method_10566("id", variant.method_10580("item"));
                hack.method_10569("Count", 1);
                class_2487 updated = (class_2487)class_3551.method_15450().update(class_1208.field_5712, new Dynamic((DynamicOps)class_2509.field_11560, (Object)hack), 3700, class_155.method_16673().method_37912().method_38494()).getValue();
                variant.method_10566("components", updated.method_10580("components"));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.storage.readNbt(nbt, lookup);
        this.updateStackWithTick();
        super.method_11014(nbt, lookup);
    }

    private void updateStack() {
        this.itemStack = ((ItemVariant)this.storage.variant).toStack();
        if (this.model != null) {
            this.model.setDisplay(this.itemStack, this.storage.amount);
        }
    }

    private void updateStackWithTick() {
        this.updateStack();
        if (this.model != null && this.field_11863 != null) {
            this.model.tick();
        }
    }

    public int getMaxCount(class_1799 stack) {
        return this.getMaxStackCount() * stack.method_7914();
    }

    protected int getMaxStackCount() {
        int n;
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof ContainerBlock) {
            ContainerBlock c = (ContainerBlock)class_22482;
            n = c.maxStackCount;
        } else {
            n = 0;
        }
        return n;
    }

    public boolean matches(class_1799 stackInHand) {
        return ((ItemVariant)this.storage.variant).matches(stackInHand);
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(class_1799 stack) {
        this.storage.variant = ItemVariant.of((class_1799)stack);
        this.updateStackWithTick();
    }

    public class_1799 extract(int amount) {
        try (Transaction t = Transaction.openOuter();){
            ItemVariant variant = (ItemVariant)this.storage.variant;
            long i = this.storage.extract((TransferVariant)variant, (long)amount, (TransactionContext)t);
            t.commit();
            this.method_5431();
            class_1799 class_17992 = variant.toStack((int)i);
            return class_17992;
        }
    }

    public int addItems(int i) {
        try (Transaction t = Transaction.openOuter();){
            i = (int)this.storage.insert((TransferVariant)((ItemVariant)this.storage.variant), (long)i, (TransactionContext)t);
            t.commit();
            int n = i;
            return n;
        }
    }

    public boolean isEmpty() {
        return this.storage.amount == 0L;
    }

    public void onListenerUpdate(class_2818 chunk) {
        ContainerBlock.Model model;
        ElementHolder elementHolder = BlockBoundAttachment.get((class_2818)chunk, (class_2338)this.field_11867).holder();
        this.model = elementHolder instanceof ContainerBlock.Model ? (model = (ContainerBlock.Model)elementHolder) : null;
        this.updateStackWithTick();
    }

    @Override
    @Nullable
    public class_2561 getFilledStateText() {
        return class_2561.method_43469((String)"text.polyfactory.x_out_of_y", (Object[])new Object[]{this.storage.amount, this.storage.getCapacity()});
    }

    @Override
    public long getFilledAmount() {
        return this.storage.getAmount();
    }

    @Override
    public long getFillCapacity() {
        return this.storage.getCapacity();
    }

    static {
        ItemStorage.SIDED.registerForBlockEntity((self, dir) -> self.storage, FactoryBlockEntities.CONTAINER);
    }
}

