/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.other;

import eu.pb4.factorytools.api.block.BarrierBasedWaterloggable;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.block.other.ColorableBlockEntity;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.util.ColoredItem;
import eu.pb4.polyfactory.util.BlockStateNameProvider;
import eu.pb4.polyfactory.util.ColorProvider;
import eu.pb4.polyfactory.util.DyeColorExtra;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9283;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SmallLampBlock
extends class_2248
implements FactoryBlock,
class_2343,
BlockStateNameProvider,
BarrierBasedWaterloggable {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2753 FACING = class_2741.field_12525;
    private final boolean inverted;

    public SmallLampBlock(class_4970.class_2251 settings, boolean inverted) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.inverted = inverted;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED}).method_11667(new class_2769[]{LIT}).method_11667(new class_2769[]{FACING});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return this.waterLog(ctx, (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8038())).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(ctx.method_8045().method_49807(ctx.method_8037().method_10093(ctx.method_8038().method_10153()), ctx.method_8038().method_10153()))));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        this.tickWater(state, world, pos);
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        boolean bl;
        if (!world.field_9236 && (bl = ((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) != world.method_49807(pos.method_10093(((class_2350)state.method_11654((class_2769)FACING)).method_10153()), ((class_2350)state.method_11654((class_2769)FACING)).method_10153())) {
            if (bl) {
                world.method_39279(pos, (class_2248)this, 4);
            } else {
                world.method_8652(pos, (class_2680)state.method_28493((class_2769)LIT), 2);
            }
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
        if (((Boolean)state.method_11654((class_2769)LIT)).booleanValue() != world.method_49807(pos.method_10093(dir.method_10153()), dir.method_10153())) {
            world.method_8652(pos, (class_2680)state.method_28493((class_2769)LIT), 2);
        }
    }

    public boolean setColor(class_1937 world, class_2338 pos, int color) {
        ColorProvider provider;
        color = FactoryItems.LAMP.downSampleColor(color);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider && (provider = (ColorProvider)class_25862).getColor() != color) {
            provider.setColor(color);
            return true;
        }
        return false;
    }

    public boolean forceLightUpdates(class_2680 blockState) {
        return true;
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        ColorableBlockEntity be;
        class_1799 stack = super.method_9574(world, pos, state);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorableBlockEntity && !(be = (ColorableBlockEntity)class_25862).isDefaultColor()) {
            ColoredItem.setColor(stack, be.getColor());
        }
        return stack;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorableBlockEntity) {
            ColorableBlockEntity be = (ColorableBlockEntity)class_25862;
            be.setColor(FactoryItems.LAMP.getItemColor(itemStack));
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(pos, initialBlockState, this.inverted);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ColorableBlockEntity(pos, state);
    }

    @Override
    public class_2561 getName(class_3218 world, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
        ColorableBlockEntity be;
        if (blockEntity instanceof ColorableBlockEntity && !(be = (ColorableBlockEntity)blockEntity).isDefaultColor()) {
            if (!DyeColorExtra.hasLang(be.getColor())) {
                return class_2561.method_43469((String)(this.method_9539() + ".colored.full"), (Object[])new Object[]{ColoredItem.getColorName(be.getColor()), ColoredItem.getHexName(be.getColor())});
            }
            return class_2561.method_43469((String)(this.method_9539() + ".colored"), (Object[])new Object[]{ColoredItem.getColorName(be.getColor())});
        }
        return this.method_9518();
    }

    public static final class Model
    extends BlockModel
    implements ColorProvider.Consumer {
        private final ItemDisplayElement main = ItemDisplayElementUtil.createSimple();
        private final boolean inverted;
        private int color = -2;
        private class_2680 state;

        private Model(class_2338 pos, class_2680 state, boolean inverted) {
            this.main.setScale((Vector3fc)new Vector3f(2.0f));
            this.main.setViewRange(0.5f);
            this.state = state;
            this.updateStatePos(state);
            this.inverted = inverted;
            this.addElement((VirtualElement)this.main);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.setState(this.blockState());
            }
        }

        private void setState(class_2680 blockState) {
            this.state = blockState;
            this.updateStatePos(blockState);
            if (this.color != -2) {
                this.updateModel();
            }
        }

        private void updateStatePos(class_2680 state) {
            class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
            float p = 0.0f;
            float y = 0.0f;
            if (dir.method_10166() != class_2350.class_2351.field_11052) {
                p = 90.0f;
                y = dir.method_10144();
            } else if (dir == class_2350.field_11033) {
                p = 180.0f;
            }
            this.main.setYaw(y);
            this.main.setPitch(p);
        }

        private void updateModel() {
            class_1799 stack = ItemDisplayElementUtil.getModel((class_1792)((Boolean)this.state.method_11654((class_2769)LIT) == this.inverted ? FactoryItems.CAGED_LAMP : FactoryItems.INVERTED_CAGED_LAMP)).method_7972();
            stack.method_57379(class_9334.field_49615, (Object)new class_9283(class_9283.class_1782.field_7970, IntList.of((int)this.color), IntList.of(), false, false));
            this.main.setItem(stack);
            this.tick();
        }

        @Override
        public void setColor(int color) {
            this.color = color;
            if (color != -2) {
                this.updateModel();
            }
        }
    }
}

