/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.property;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2769;

public class LazyEnumProperty<T extends Enum<T>>
extends class_2769<T> {
    private final ImmutableSet<T> values;
    private final Map<String, T> byName = Maps.newHashMap();
    private final Map<T, String> toName;

    protected LazyEnumProperty(String name, Class<T> type, Collection<T> values) {
        super(name, type);
        this.values = ImmutableSet.copyOf(values);
        this.toName = new EnumMap<T, String>(type);
        for (Enum enum_ : values) {
            String string = enum_.name().toLowerCase(Locale.ROOT);
            if (this.byName.containsKey(string)) {
                throw new IllegalArgumentException("Multiple values have the same name '" + string + "'");
            }
            this.byName.put(string, enum_);
            this.toName.put(enum_, string);
        }
    }

    public Collection<T> method_11898() {
        return this.values;
    }

    public Optional<T> method_11900(String name) {
        return Optional.ofNullable((Enum)this.byName.get(name));
    }

    public String name(T enum_) {
        return this.toName.get(enum_);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LazyEnumProperty) {
            LazyEnumProperty enumProperty = (LazyEnumProperty)((Object)object);
            if (super.equals(object)) {
                return this.values.equals(enumProperty.values) && this.byName.equals(enumProperty.byName);
            }
        }
        return false;
    }

    public int method_11799() {
        int i = super.method_11799();
        i = 31 * i + this.values.hashCode();
        i = 31 * i + this.byName.hashCode();
        return i;
    }

    public static <T extends Enum<T>> LazyEnumProperty<T> of(String name, Class<T> type) {
        return LazyEnumProperty.of(name, type, (T enum_) -> true);
    }

    public static <T extends Enum<T>> LazyEnumProperty<T> of(String name, Class<T> type, Predicate<T> filter) {
        return LazyEnumProperty.of(name, type, Arrays.stream((Enum[])type.getEnumConstants()).filter(filter).collect(Collectors.toList()));
    }

    public static <T extends Enum<T>> LazyEnumProperty<T> of(String name, Class<T> type, T ... values) {
        return LazyEnumProperty.of(name, type, Lists.newArrayList((Object[])values));
    }

    public static <T extends Enum<T>> LazyEnumProperty<T> of(String name, Class<T> type, Collection<T> values) {
        return new LazyEnumProperty<T>(name, type, values);
    }
}

