/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import eu.pb4.polyfactory.data.DataContainer;
import eu.pb4.polyfactory.data.DataType;

public record BoolData(boolean value) implements DataContainer
{
    public static BoolData TRUE = new BoolData(true);
    public static BoolData FALSE = new BoolData(false);
    public static MapCodec<BoolData> TYPE_CODEC = Codec.BOOL.xmap(BoolData::of, BoolData::value).fieldOf("value");

    public static BoolData of(boolean count) {
        return count ? TRUE : FALSE;
    }

    public DataType type() {
        return DataType.BOOL;
    }

    @Override
    public String asString() {
        return this.value ? "true" : "false";
    }

    @Override
    public long asLong() {
        return this.value ? 0L : 1L;
    }

    @Override
    public double asDouble() {
        return this.value ? 0.0 : 1.0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isTrue() {
        return this.value;
    }
}

