/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.fluid;

import eu.pb4.polyfactory.entity.FactoryEntities;
import eu.pb4.polyfactory.entity.splash.ExperienceSplashEntity;
import eu.pb4.polyfactory.fluid.FluidBehaviours;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidType;
import eu.pb4.polyfactory.fluid.shooting.ShootProjectileEntity;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.other.FactoryRegistries;
import eu.pb4.polyfactory.other.FactorySoundEvents;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3902;
import net.minecraft.class_4481;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5556;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.class_9381;

public class FactoryFluids {
    public static final FluidType<class_3902> WATER = FactoryFluids.register(class_2960.method_60656((String)"water"), FluidType.of().density(100).fluid((class_3611)class_3612.field_15910).color(3694022).particle((class_2394)new class_2392(class_2398.field_11218, class_1802.field_8747.method_7854())).shootingBehavior(ShootProjectileEntity.ofSplash(FactoryEntities.WATER_SPLASH, 10, 300L, FactorySoundEvents.FLUID_SHOOT_WATER)).build());
    public static final FluidType<class_3902> LAVA = FactoryFluids.register(class_2960.method_60656((String)"lava"), FluidType.of().density(1000).fluid((class_3611)class_3612.field_15908).brightness(15).heat(0.85f).flowSpeedMultiplier((world, data) -> world != null && world.method_8597().comp_644() ? 1.0 : 0.5).shootingBehavior(ShootProjectileEntity.ofSplash(FactoryEntities.LAVA_SPLASH, 10, 400L, FactorySoundEvents.FLUID_SHOOT_LAVA)).maxFlow((world, data) -> world != null && world.method_8597().comp_644() ? 27000L : 18000L).build());
    public static final FluidType<class_3902> MILK = FactoryFluids.register(class_2960.method_60656((String)"milk"), FluidType.of().density(200).flowSpeedMultiplier(0.95).shootingBehavior(ShootProjectileEntity.ofSplash(FactoryEntities.MILK_SPLASH, 10, 350L, FactorySoundEvents.FLUID_SHOOT_MILK)).build());
    public static final FluidType<class_3902> EXPERIENCE = FactoryFluids.register(class_2960.method_60656((String)"experience"), FluidType.of().density(50).flowSpeedMultiplier(1.3).maxFlow(54000L).brightness(14).heat(0.1f).shootingBehavior(new ShootProjectileEntity((world, fluid, amount) -> {
        ExperienceSplashEntity xp = (ExperienceSplashEntity)FactoryEntities.EXPERIENCE_SPLASH.method_5883((class_1937)world);
        assert (xp != null);
        xp.setAmount(amount / 500L);
        return xp;
    }, 1, (world, c, f, test) -> test ? 500L : class_3532.method_53062((long)(c.get(f) / 500L), (long)1L, (long)3L) * 500L, 2.0f, 0.5f, 0.1f, 0.3f, FactorySoundEvents.FLUID_SHOOT_EXPERIENCE)).build());
    public static final FluidType<class_1844> POTION = FactoryFluids.register(class_2960.method_60656((String)"potion"), FluidType.of(class_1844.field_49275, class_1844.field_49274).density(150).texture(WATER.texture()).color(class_1844::method_8064).flowSpeedMultiplier(0.95).name((t, d) -> {
        class_5250 base = class_2561.method_43471((String)class_1842.method_8051((Optional)d.comp_2378(), (String)"item.minecraft.potion.effect."));
        if (d.comp_2378().isPresent() && ((class_5321)((class_6880)d.comp_2378().get()).method_40230().get()).method_29177().method_12832().startsWith("long_")) {
            return class_2561.method_43469((String)"fluid_type.minecraft.potion.long", (Object[])new Object[]{base});
        }
        if (d.comp_2378().isPresent() && ((class_5321)((class_6880)d.comp_2378().get()).method_40230().get()).method_29177().method_12832().startsWith("strong_")) {
            return class_2561.method_43469((String)"fluid_type.minecraft.potion.strong", (Object[])new Object[]{base});
        }
        return base;
    }).particle(data -> class_9381.method_58256((class_2396)class_2398.field_11226, (int)((class_1844)data.data()).method_8064())).shootingBehavior(ShootProjectileEntity.ofSplash(FactoryEntities.POTION_SPLASH, 4, 450L, FactorySoundEvents.FLUID_SHOOT_POTION)).build());
    public static final FluidType<class_3902> HONEY = FactoryFluids.register(class_2960.method_60656((String)"honey"), FluidType.of().density(500).transparent().flowSpeedMultiplier(0.6).maxFlow(18000L).build());
    public static final FluidType<class_3902> SLIME = FactoryFluids.register(class_2960.method_60656((String)"slime"), FluidType.of().density(600).transparent().flowSpeedMultiplier(0.6).maxFlow(18000L).build());
    public static final FluidType<class_3902> SNOW = FactoryFluids.register(class_2960.method_60656((String)"snow"), FluidType.of().density(90).flowSpeedMultiplier(0.98).maxFlow(21600L).heat(-0.08f).shootingBehavior(ShootProjectileEntity.ofEntity(class_1299.field_6068, 1, 506L, 1.7f, 0.5f, 0.0f, 0.1f, (class_6880<class_3414>)class_7923.field_41172.method_47983((Object)class_3417.field_14873))).texture(class_2960.method_60656((String)"block/powder_snow")).build());

    public static void register() {
        FluidBehaviours.addBlockStateConversions(class_2246.field_10382.method_9564(), class_2246.field_10124.method_9564(), WATER.ofBucket());
        FluidBehaviours.addBlockStateConversions(class_2246.field_27879.method_9564(), class_2246.field_10124.method_9564(), SNOW.ofBucket());
        FluidBehaviours.addBlockStateConversions(class_2246.field_10164.method_9564(), class_2246.field_10124.method_9564(), LAVA.ofBucket());
        FluidBehaviours.addBlockStateConversions((class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(3)), (class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(2)), WATER.ofBottle());
        FluidBehaviours.addBlockStateConversions((class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(2)), (class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(1)), WATER.ofBottle());
        FluidBehaviours.addBlockStateConversions((class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(1)), class_2246.field_10593.method_9564(), WATER.ofBottle());
        FluidBehaviours.addBlockStateConversions((class_2680)class_2246.field_27878.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(3)), (class_2680)class_2246.field_27878.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(2)), SNOW.ofBottle());
        FluidBehaviours.addBlockStateConversions((class_2680)class_2246.field_27878.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(2)), (class_2680)class_2246.field_27878.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(1)), SNOW.ofBottle());
        FluidBehaviours.addBlockStateConversions((class_2680)class_2246.field_27878.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(1)), class_2246.field_10593.method_9564(), SNOW.ofBottle());
        FluidBehaviours.addBlockStateConversions(class_2246.field_27098.method_9564(), class_2246.field_10593.method_9564(), LAVA.ofBucket());
        FluidBehaviours.addBlockStateInsert(class_2246.field_10030.method_9564(), class_2246.field_10124.method_9564(), SLIME.ofBucket());
        FluidBehaviours.addBlockStateExtract((class_2680)class_2246.field_20422.method_9564().method_11657((class_2769)class_4481.field_20420, (Comparable)Integer.valueOf(5)), class_2246.field_20422.method_9564(), HONEY.of(20250L));
        FluidBehaviours.addBlockStateInsert(class_2246.field_21211.method_9564(), class_2246.field_10124.method_9564(), HONEY.ofBucket());
        FluidBehaviours.addItemToFluidLink(class_1802.field_8550, (FluidInstance)null);
        FluidBehaviours.addItemToFluidLink(class_1802.field_8705, WATER.defaultInstance());
        FluidBehaviours.addItemToFluidLink(class_1802.field_8187, LAVA.defaultInstance());
        FluidBehaviours.addItemToFluidLink(class_1802.field_8103, MILK.defaultInstance());
        FluidBehaviours.addItemToFluidLink(FactoryItems.EXPERIENCE_BUCKET, EXPERIENCE.defaultInstance());
        FluidBehaviours.addItemToFluidLink(FactoryItems.SLIME_BUCKET, SLIME.defaultInstance());
        FluidBehaviours.addItemToFluidLink(class_1802.field_8777, SLIME.defaultInstance());
        FluidBehaviours.addItemToFluidLink(class_1802.field_8828, SLIME.defaultInstance());
        FluidBehaviours.addItemToFluidLink(FactoryItems.HONEY_BUCKET, HONEY.defaultInstance());
        FluidBehaviours.addItemToFluidLink(class_1802.field_21086, HONEY.defaultInstance());
        FluidBehaviours.addItemToFluidLink(class_1802.field_20417, HONEY.defaultInstance());
        Function<class_1799, FluidInstance<?>> potionFunction = stack -> {
            class_1844 x = (class_1844)stack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
            if (x.comp_2378().isPresent() && x.comp_2378().get() == class_1847.field_8991) {
                return WATER.defaultInstance();
            }
            return POTION.toInstance(x);
        };
        FluidBehaviours.addItemToFluidLink(class_1802.field_8574, potionFunction);
        FluidBehaviours.addItemToFluidLink(class_1802.field_8436, potionFunction);
        FluidBehaviours.addItemToFluidLink(class_1802.field_8150, potionFunction);
    }

    public static <T> FluidType<T> register(class_2960 identifier, FluidType<T> item) {
        return (FluidType)class_2378.method_10230(FactoryRegistries.FLUID_TYPES, (class_2960)identifier, item);
    }

    public static <T> FluidType<T> register(String path, FluidType<T> item) {
        return (FluidType)class_2378.method_10230(FactoryRegistries.FLUID_TYPES, (class_2960)class_2960.method_60655((String)"polyfactory", (String)path), item);
    }

    public static FluidInstance<?> getPotion(class_6880<class_1842> potion) {
        if (potion == class_1847.field_8991) {
            return WATER.defaultInstance();
        }
        return POTION.toInstance(class_1844.field_49274.method_57403(potion));
    }
}

