/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.fluid;

import com.mojang.serialization.Codec;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.fluid.shooting.FluidShootingBehavior;
import eu.pb4.polyfactory.fluid.shooting.NoOpFluidShootingBehavior;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.other.FactoryRegistries;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.ModelRenderType;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3902;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_8104;
import org.jetbrains.annotations.Nullable;

public record FluidType<T>(int density, float heat, Codec<T> dataCodec, T defaultData, Optional<class_3611> backingFluid, Optional<class_2960> textureOverride, ModelRenderType modelRenderType, Optional<ColorProvider<T>> color, Optional<BiFunction<FluidType<T>, T, class_2561>> name, Function<FluidInstance<T>, class_2394> particleGetter, MaxFlowProvider<T> maxFlow, FlowSpeedProvider<T> flowSpeedMultiplier, Optional<class_8104> brightness, FluidShootingBehavior<T> shootingBehavior) {
    private static final Map<class_3611, FluidType<?>> FLUID_TO_TYPE = new IdentityHashMap();
    public static final Comparator<FluidType<?>> DENSITY_COMPARATOR = Comparator.comparingInt(FluidType::density);
    public static final Comparator<FluidType<?>> DENSITY_COMPARATOR_REVERSED = DENSITY_COMPARATOR.reversed();
    public static final long BLOCK_AMOUNT = 81000L;
    public static final Codec<FluidType<?>> CODEC = FactoryRegistries.FLUID_TYPES.method_39673();

    public FluidType(int density, float heat, Codec<T> dataCodec, T defaultData, Optional<class_3611> backingFluid, Optional<class_2960> textureOverride, ModelRenderType modelRenderType, Optional<ColorProvider<T>> color, Optional<BiFunction<FluidType<T>, T, class_2561>> name, Function<FluidInstance<T>, class_2394> particleGetter, MaxFlowProvider<T> maxFlow, FlowSpeedProvider<T> flowSpeedMultiplier, Optional<class_8104> brightness, FluidShootingBehavior<T> shootingBehavior) {
        backingFluid.ifPresent(x -> FLUID_TO_TYPE.put((class_3611)x, this));
        this.density = density;
        this.heat = heat;
        this.dataCodec = dataCodec;
        this.defaultData = defaultData;
        this.backingFluid = backingFluid;
        this.textureOverride = textureOverride;
        this.modelRenderType = modelRenderType;
        this.color = color;
        this.name = name;
        this.particleGetter = particleGetter;
        this.maxFlow = maxFlow;
        this.flowSpeedMultiplier = flowSpeedMultiplier;
        this.brightness = brightness;
        this.shootingBehavior = shootingBehavior;
    }

    public static FluidType<?> get(class_3611 fluid) {
        return FLUID_TO_TYPE.get(fluid);
    }

    public class_2561 getName() {
        return class_2561.method_43471((String)class_156.method_646((String)"fluid_type", (class_2960)FactoryRegistries.FLUID_TYPES.method_10221((Object)this)));
    }

    public class_2561 getName(T data) {
        return this.name.isEmpty() ? this.getName() : this.name.get().apply(this, (FluidType)data);
    }

    public class_5250 toLabeledAmount(long amount, T data) {
        return class_2561.method_43473().method_10852(this.getName(data)).method_27693(": ").method_10852(FactoryUtil.fluidText(amount));
    }

    public FluidStack<T> ofBottle() {
        return new FluidStack<T>(this.defaultInstance(), 27000L);
    }

    public FluidStack<T> ofBucket() {
        return new FluidStack<T>(this.defaultInstance(), 81000L);
    }

    public FluidStack<T> of(long amount) {
        return new FluidStack<T>(this.defaultInstance(), amount);
    }

    public FluidStack<T> ofBottle(T data) {
        return new FluidStack<T>(this, data, 27000L);
    }

    public FluidStack<T> ofBucket(T data) {
        return new FluidStack<T>(this, data, 81000L);
    }

    public FluidStack<T> of(long amount, T data) {
        return new FluidStack<T>(this, data, amount);
    }

    public class_2960 texture() {
        if (this.textureOverride().isPresent()) {
            return this.textureOverride().get();
        }
        class_2960 id = FactoryRegistries.FLUID_TYPES.method_10221((Object)this);
        if (id == null) {
            throw new RuntimeException("Unregistered type type!");
        }
        if (id.method_12836().equals("minecraft")) {
            return ModInit.id("block/fluid/" + id.method_12832());
        }
        return id.method_45138("block/fluid/");
    }

    public FluidInstance<T> defaultInstance() {
        return FluidInstance.getDefault(this);
    }

    public FluidInstance<T> toInstance(T data) {
        return new FluidInstance<T>(this, data);
    }

    public static <T> Builder<T> of(Codec<T> dataCodec, T defaultData) {
        return new Builder<T>(dataCodec, defaultData);
    }

    public static Builder<class_3902> of() {
        return new Builder<class_3902>(class_3902.field_51563, class_3902.field_17274);
    }

    public static interface MaxFlowProvider<T> {
        public long getMaxFlow(@Nullable class_3218 var1, T var2);
    }

    public static interface FlowSpeedProvider<T> {
        public double getSpeedMultiplier(@Nullable class_3218 var1, T var2);
    }

    public static final class Builder<T> {
        private final Codec<T> dataCodec;
        private final T defaultData;
        private int density = 0;
        private float heat = 0.0f;
        private ModelRenderType modelRenderType = ModelRenderType.SOLID;
        private Optional<class_3611> fluid = Optional.empty();
        private Optional<class_8104> brightness = Optional.empty();
        private Optional<class_2960> texture = Optional.empty();
        private Optional<ColorProvider<T>> color = Optional.empty();
        private Optional<BiFunction<FluidType<T>, T, class_2561>> name = Optional.empty();
        private Function<FluidInstance<T>, class_2394> particleGetter = x -> new class_2392(class_2398.field_11218, FactoryModels.FLUID_FLAT_FULL.get(x));
        private MaxFlowProvider<T> maxFlow = (w, x) -> 27000L;
        private FlowSpeedProvider<T> flowSpeedMultiplier = (w, x) -> 1.0;
        private FluidShootingBehavior<T> shootingBehavior = new NoOpFluidShootingBehavior();

        private Builder(Codec<T> dataCodec, T defaultData) {
            this.dataCodec = dataCodec;
            this.defaultData = defaultData;
        }

        public Builder<T> density(int density) {
            this.density = density;
            return this;
        }

        public Builder<T> heat(float heat) {
            this.heat = heat;
            return this;
        }

        public Builder<T> fluid(class_3611 fluid) {
            this.fluid = Optional.ofNullable(fluid);
            if (this.texture.isEmpty()) {
                this.texture(class_7923.field_41173.method_10221((Object)fluid).method_45138("block/").method_48331("_still"));
            }
            return this;
        }

        public Builder<T> texture(class_2960 identifier) {
            this.texture = Optional.ofNullable(identifier);
            return this;
        }

        public Builder<T> modelRenderType(ModelRenderType type) {
            this.modelRenderType = type;
            return this;
        }

        public Builder<T> transparent() {
            return this.modelRenderType == ModelRenderType.SOLID ? this.modelRenderType(ModelRenderType.TRANSPARENT) : this;
        }

        public Builder<T> color(int color) {
            this.color = Optional.of(x -> color);
            this.modelRenderType = ModelRenderType.COLORED;
            return this;
        }

        public Builder<T> color(ColorProvider<T> colorProvider) {
            this.color = Optional.of(colorProvider);
            this.modelRenderType = ModelRenderType.COLORED;
            return this;
        }

        public Builder<T> name(BiFunction<FluidType<T>, T, class_2561> name) {
            this.name = Optional.of(name);
            return this;
        }

        public Builder<T> brightness(int light) {
            return this.brightness(new class_8104(light, light));
        }

        public Builder<T> brightness(class_8104 brightness) {
            this.brightness = Optional.ofNullable(brightness);
            return this;
        }

        public Builder<T> particle(class_2394 particle) {
            return this.particle((FluidInstance<T> x) -> particle);
        }

        public Builder<T> particle(Function<FluidInstance<T>, class_2394> particle) {
            this.particleGetter = particle;
            return this;
        }

        public Builder<T> maxFlow(long maxFlow) {
            return this.maxFlow((w, x) -> maxFlow);
        }

        public Builder<T> maxFlow(MaxFlowProvider<T> maxFlow) {
            this.maxFlow = maxFlow;
            return this;
        }

        public Builder<T> flowSpeedMultiplier(double multiplier) {
            return this.flowSpeedMultiplier((w, x) -> multiplier);
        }

        public Builder<T> flowSpeedMultiplier(FlowSpeedProvider<T> multiplier) {
            this.flowSpeedMultiplier = multiplier;
            return this;
        }

        public Builder<T> shootingBehavior(FluidShootingBehavior<T> behavior) {
            this.shootingBehavior = behavior;
            return this;
        }

        public FluidType<T> build() {
            return new FluidType<T>(this.density, this.heat, this.dataCodec, this.defaultData, this.fluid, this.texture, this.modelRenderType, this.color, this.name, this.particleGetter, this.maxFlow, this.flowSpeedMultiplier, this.brightness, this.shootingBehavior);
        }
    }

    public static interface ColorProvider<T> {
        public int getColor(T var1);
    }
}

