/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.util.FactoryUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_9299;

public record FluidComponent(Object2LongMap<FluidInstance<?>> map, List<FluidInstance<?>> fluids, long stored, long capacity, boolean showTooltip) implements class_9299
{
    public static final FluidComponent DEFAULT = new FluidComponent(Object2LongMaps.emptyMap(), List.of(), 0L, -1L, true);
    public static final Codec<FluidComponent> SIMPLE_CODEC = FluidStack.CODEC.listOf().xmap(FluidComponent::fromStacks, FluidComponent::toStacks);
    public static final Codec<FluidComponent> CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(instance -> instance.group((App)FluidStack.CODEC.listOf().fieldOf("fluids").forGetter(FluidComponent::toStacks), (App)Codec.LONG.optionalFieldOf("capacity", (Object)-1L).forGetter(FluidComponent::capacity), (App)Codec.BOOL.optionalFieldOf("show_tooltip", (Object)true).forGetter(FluidComponent::showTooltip)).apply((Applicative)instance, FluidComponent::fromStacks)), SIMPLE_CODEC);

    private static FluidComponent fromStacks(Collection<FluidStack<?>> fluidStacks) {
        return FluidComponent.fromStacks(fluidStacks, true);
    }

    private static FluidComponent fromStacks(Collection<FluidStack<?>> fluidStacks, boolean showTooltip) {
        return FluidComponent.fromStacks(fluidStacks, -1L, showTooltip);
    }

    private static FluidComponent fromStacks(Collection<FluidStack<?>> fluidStacks, long capacity, boolean showTooltip) {
        Object2LongOpenHashMap map = new Object2LongOpenHashMap();
        ArrayList list = new ArrayList();
        long stored = 0L;
        for (FluidStack<?> stack : fluidStacks) {
            map.put(stack.instance(), stack.amount());
            list.add(stack.instance());
            stored += stack.amount();
        }
        list.sort(FluidInstance.DENSITY_COMPARATOR_REVERSED);
        return new FluidComponent((Object2LongMap<FluidInstance<?>>)map, list, stored, capacity, showTooltip);
    }

    public static FluidComponent copyFrom(FluidContainer container) {
        return new FluidComponent((Object2LongMap<FluidInstance<?>>)new Object2LongOpenHashMap(container.asMap()), new ArrayList(container.fluids()), container.stored(), container.capacity(), true);
    }

    public static FluidComponent empty(long capacity) {
        return new FluidComponent(Object2LongMaps.emptyMap(), List.of(), 0L, capacity, true);
    }

    public List<FluidStack<?>> toStacks() {
        ArrayList list = new ArrayList(this.fluids.size());
        for (FluidInstance<?> x : this.fluids) {
            list.add(x.stackOf(this.map.getOrDefault(x, 0L)));
        }
        return list;
    }

    public FluidComponent extractTo(FluidContainer container) {
        ArrayList list = new ArrayList();
        for (FluidInstance<?> fluid : this.fluids) {
            long leftover = container.insert(fluid, this.map.getOrDefault(fluid, 0L), false);
            if (leftover == 0L) continue;
            list.add(fluid.stackOf(leftover));
        }
        return FluidComponent.fromStacks(list, this.capacity, this.showTooltip);
    }

    public Result insert(FluidInstance<?> fluid, long amount, boolean strict) {
        if (this.capacity == -1L) {
            return new Result(this.with(fluid, this.get(fluid) + amount), 0L);
        }
        if (strict && this.stored + amount > this.capacity) {
            return new Result(this, amount);
        }
        long maxAmount = Math.min(this.capacity - this.stored, amount);
        if (maxAmount == 0L) {
            return new Result(this, amount);
        }
        return new Result(this.with(fluid, this.get(fluid) + maxAmount), amount - maxAmount);
    }

    public Result extract(FluidInstance<?> fluid, long amount, boolean strict) {
        if (strict && this.get(fluid) < amount) {
            return new Result(this, 0L);
        }
        long maxAmount = Math.min(this.get(fluid), amount);
        if (maxAmount == 0L) {
            return new Result(this, 0L);
        }
        return new Result(this.with(fluid, this.get(fluid) - maxAmount), maxAmount);
    }

    public long get(FluidInstance<?> fluid) {
        return this.map.getOrDefault(fluid, 0L);
    }

    public FluidComponent with(FluidInstance<?> fluid, long amount) {
        if (amount == 0L && this.map.containsKey(fluid)) {
            Object2LongOpenHashMap newMap = new Object2LongOpenHashMap(this.map);
            newMap.removeLong(fluid);
            ArrayList list = new ArrayList(this.fluids);
            list.remove(fluid);
            return new FluidComponent((Object2LongMap<FluidInstance<?>>)newMap, list, this.stored - this.map.getOrDefault(fluid, 0L), this.capacity, this.showTooltip);
        }
        if (amount != this.map.getOrDefault(fluid, 0L)) {
            Object2LongOpenHashMap newMap = new Object2LongOpenHashMap(this.map);
            newMap.put(fluid, amount);
            ArrayList list = new ArrayList(this.fluids);
            if (!this.map.containsKey(fluid)) {
                list.add(fluid);
                list.sort(FluidInstance.DENSITY_COMPARATOR_REVERSED);
            }
            return new FluidComponent((Object2LongMap<FluidInstance<?>>)newMap, list, this.stored - this.map.getOrDefault(fluid, 0L) + amount, this.capacity, this.showTooltip);
        }
        return this;
    }

    public void copyTo(FluidContainer container) {
        container.clear();
        this.map.forEach(container::set);
    }

    public FluidComponent withShowTooltip(boolean value) {
        return new FluidComponent(this.map, this.fluids, this.stored, this.capacity, value);
    }

    public boolean isEmpty() {
        return this.stored == 0L;
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type) {
        if (!this.showTooltip) {
            return;
        }
        for (FluidInstance<?> fluid : this.fluids) {
            tooltip.accept((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)fluid.toLabeledAmount(this.map.getOrDefault(fluid, 0L))).method_27692(class_124.field_1080));
        }
        if (this.capacity != -1L) {
            tooltip.accept((class_2561)class_2561.method_43469((String)"text.polyfactory.x_out_of_y", (Object[])new Object[]{FactoryUtil.fluidText(this.stored), FactoryUtil.fluidText(this.capacity)}).method_27692(class_124.field_1054));
        }
    }

    public FluidComponent clear() {
        return new FluidComponent(Object2LongMaps.emptyMap(), List.of(), 0L, this.capacity, this.showTooltip);
    }

    public record Result(FluidComponent component, long fluidAmount) {
    }
}

