/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.item.tool;

import eu.pb4.factorytools.api.item.RegistryCallbackItem;
import eu.pb4.factorytools.api.resourcepack.BaseItemProvider;
import eu.pb4.polyfactory.advancement.FluidShootsCriterion;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerFromComponent;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.shooting.EntityShooterContext;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.component.FluidComponent;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2744;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5630;
import net.minecraft.class_7225;
import net.minecraft.class_9278;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class PressureFluidGun
extends class_1792
implements PolymerItem,
RegistryCallbackItem {
    private PolymerModelData baseModel = FactoryModels.PLACEHOLDER;
    private PolymerModelData activeOthersModel = FactoryModels.PLACEHOLDER;
    private PolymerModelData activeSelfModel = FactoryModels.PLACEHOLDER;

    public PressureFluidGun(class_1792.class_1793 settings) {
        super(settings);
    }

    public static boolean isUsable(class_1799 stack) {
        return stack.method_7919() < stack.method_7936() - 1;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (!selected && entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            this.method_7840(stack, world, livingEntity, 0);
        }
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        FluidInstance fluid = (FluidInstance)stack.method_57824(FactoryDataComponents.CURRENT_FLUID);
        if (fluid != null) {
            fluid.shootingBehavior().stopShooting(new EntityShooterContext(user), fluid);
            stack.method_57381(FactoryDataComponents.CURRENT_FLUID);
        }
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        FluidInstance fluid = (FluidInstance)stack.method_57824(FactoryDataComponents.CURRENT_FLUID);
        if (fluid == null) {
            return;
        }
        EntityShooterContext ctx = new EntityShooterContext(user);
        List<FluidContainer> containers = this.findFluidContainer(user);
        if (containers.isEmpty() || !PressureFluidGun.isUsable(stack)) {
            fluid.shootingBehavior().stopShooting(ctx, fluid);
            stack.method_57381(FactoryDataComponents.CURRENT_FLUID);
            return;
        }
        for (FluidContainer container : containers) {
            if (!fluid.shootingBehavior().canShoot(ctx, fluid, container)) continue;
            fluid.shootingBehavior().continueShooting(ctx, fluid, -remainingUseTicks, container);
            if (remainingUseTicks % 20 == 0) {
                stack.method_7970(1, user, user.method_6058() == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
            }
            class_243 vec = ctx.rotation().method_1021(user.method_24828() ? -0.002 : -0.05);
            FactoryUtil.addSafeVelocity((class_1297)user, vec);
            if (user instanceof class_3222) {
                class_3222 player = (class_3222)user;
                FactoryUtil.sendVelocityDelta(player, vec);
            }
            return;
        }
        fluid.shootingBehavior().stopShooting(ctx, fluid);
        stack.method_57381(FactoryDataComponents.CURRENT_FLUID);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (stack.method_57826(FactoryDataComponents.CURRENT_FLUID)) {
            return class_1271.method_22428((Object)stack);
        }
        List<FluidContainer> containers = this.findFluidContainer((class_1309)user);
        if (containers.isEmpty() || !PressureFluidGun.isUsable(stack)) {
            return class_1271.method_22431((Object)user.method_5998(hand));
        }
        EntityShooterContext ctx = new EntityShooterContext((class_1309)user);
        for (FluidContainer container : containers) {
            for (FluidInstance<?> f : container.fluids()) {
                if (!f.shootingBehavior().canShoot(ctx, f, container)) continue;
                stack.method_57379(FactoryDataComponents.CURRENT_FLUID, f);
                user.method_6019(hand);
                f.shootingBehavior().startShooting(ctx, f, container);
                class_243 vec = ctx.rotation().method_1021(user.method_24828() ? -0.01 : -0.07);
                FactoryUtil.addSafeVelocity((class_1297)user, vec);
                if (user instanceof class_3222) {
                    class_3222 player = (class_3222)user;
                    FactoryUtil.sendVelocityDelta(player, vec);
                    FluidShootsCriterion.triggerFluidLauncher(player, stack, f);
                }
                return class_1271.method_22428((Object)stack);
            }
        }
        return class_1271.method_22431((Object)stack);
    }

    private List<FluidContainer> findFluidContainer(class_1309 user) {
        ArrayList<FluidContainer> stacks = new ArrayList<FluidContainer>();
        for (class_1304 eq : class_1304.values()) {
            class_1799 stack = user.method_6118(eq);
            FluidComponent fluid = (FluidComponent)stack.method_57825(FactoryDataComponents.FLUID, (Object)FluidComponent.DEFAULT);
            if (fluid.isEmpty()) continue;
            stacks.add(FluidContainerFromComponent.of(class_5630.method_32330((class_1309)user, (class_1304)eq)));
        }
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                FluidComponent fluid = (FluidComponent)player.method_31548().method_5438(i).method_57825(FactoryDataComponents.FLUID, (Object)FluidComponent.DEFAULT);
                if (fluid.isEmpty()) continue;
                stacks.add(FluidContainerFromComponent.of(class_5630.method_32328((class_1263)player.method_31548(), (int)i)));
            }
        }
        return stacks;
    }

    public class_1792 getPolymerItem(class_1799 itemStack, @Nullable class_3222 player) {
        return this.getModel(itemStack).item();
    }

    public int getPolymerCustomModelData(class_1799 itemStack, @Nullable class_3222 player) {
        return this.getModel(itemStack).value();
    }

    public int method_7837() {
        return 5;
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return ingredient.method_31574(FactoryItems.COPPER_PLATE);
    }

    public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, class_7225.class_7874 lookup, @Nullable class_3222 player) {
        class_1799 out = super.getPolymerItemStack(itemStack, tooltipType, lookup, player);
        if (this.useCrossbowModel(itemStack)) {
            out.method_57379(class_9334.field_49649, (Object)class_9278.method_57439((class_1799)class_1802.field_20391.method_7854()));
        }
        out.method_57379(class_9334.field_49629, (Object)((Integer)itemStack.method_57824(class_9334.field_49629)));
        return out;
    }

    private PolymerModelData getModel(class_1799 itemStack) {
        if (this.useCrossbowModel(itemStack)) {
            return this.activeOthersModel;
        }
        return this.useActiveModel(itemStack) ? this.activeSelfModel : this.baseModel;
    }

    private boolean useCrossbowModel(class_1799 itemStack) {
        return this.useActiveModel(itemStack) && PacketContext.get().getEncodedPacket() instanceof class_2744;
    }

    private boolean useActiveModel(class_1799 itemStack) {
        return itemStack.method_57826(FactoryDataComponents.CURRENT_FLUID);
    }

    public void onRegistered(class_2960 selfId) {
        class_2960 item = class_2960.method_60655((String)selfId.method_12836(), (String)("item/" + selfId.method_12832()));
        this.baseModel = PolymerResourcePackUtils.requestModel((class_1792)BaseItemProvider.requestItem(), (class_2960)item);
        this.activeSelfModel = PolymerResourcePackUtils.requestModel((class_1792)this.baseModel.item(), (class_2960)item.method_48331("_active"));
        this.activeOthersModel = PolymerResourcePackUtils.requestModel((class_1792)class_1802.field_8399, (class_2960)item.method_48331("_active"));
    }
}

