/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.item.wrench;

import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.wrench.WrenchAction;
import eu.pb4.polyfactory.item.wrench.WrenchableBlock;
import eu.pb4.polyfactory.other.FactorySoundEvents;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.UiResourceCreator;
import eu.pb4.polyfactory.util.ServerPlayNetExt;
import eu.pb4.sidebars.api.Sidebar;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_9020;
import net.minecraft.class_9022;
import org.jetbrains.annotations.Nullable;

public class WrenchHandler {
    private final Sidebar sidebar = new Sidebar(Sidebar.Priority.HIGH);
    private final Map<class_2248, String> currentAction = new Reference2ObjectOpenHashMap();
    private class_2680 state = class_2246.field_10124.method_9564();
    @Nullable
    private class_2338 pos;
    private List<WrenchAction> actions = List.of();

    public WrenchHandler(class_3244 handler) {
        this.sidebar.addPlayer(handler);
        this.sidebar.setDefaultNumberFormat((class_9022)class_9020.field_47557);
    }

    public static WrenchHandler of(class_3222 player) {
        return ((ServerPlayNetExt)player.field_13987).polyFactory$getWrenchHandler();
    }

    public void tick(class_3222 player) {
        class_239 class_2393;
        if (player.method_6047().method_31574((class_1792)FactoryItems.WRENCH) && (class_2393 = player.method_5745(7.0, 0.0f, false)) instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)class_2393;
            class_2680 state = player.method_37908().method_8320(blockHitResult.method_17777());
            if (state == this.state && blockHitResult.method_17777().equals((Object)this.pos)) {
                return;
            }
            this.state = state;
            this.pos = blockHitResult.method_17777();
            class_2248 class_22482 = this.state.method_26204();
            if (class_22482 instanceof WrenchableBlock) {
                WrenchableBlock wrenchableBlock = (WrenchableBlock)class_22482;
                this.actions = wrenchableBlock.getWrenchActions();
                String selected = this.currentAction.get(this.state.method_26204());
                this.sidebar.setTitle((class_2561)class_2561.method_43469((String)"item.polyfactory.wrench.title", (Object[])new Object[]{class_2561.method_43473()}).method_10862(class_2583.field_24360.method_10977(class_124.field_1065).method_10982(Boolean.valueOf(true))));
                this.sidebar.set(b -> {
                    int size = Math.min(this.actions.size(), 15);
                    for (int i = 0; i < size; ++i) {
                        WrenchAction action = this.actions.get(i);
                        class_5250 t = class_2561.method_43473();
                        if (selected == null && i == 0 || action.id().equals(selected)) {
                            t.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(GuiTextures.SPACE_1)).method_10862(UiResourceCreator.STYLE));
                            t.method_10852((class_2561)class_2561.method_43470((String)"\u00bb ").method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
                        } else {
                            t.method_27693("   ");
                        }
                        t.method_10852(action.name()).method_27693(": ");
                        b.add((class_2561)t, (class_2561)class_2561.method_43473().method_10852(action.value().getDisplayValue(player.method_37908(), blockHitResult.method_17777(), blockHitResult.method_17780(), state)).method_27692(class_124.field_1054));
                    }
                });
                this.sidebar.show();
            } else {
                this.actions = List.of();
                this.sidebar.hide();
            }
        } else {
            this.state = class_2246.field_10124.method_9564();
            this.pos = null;
            this.sidebar.hide();
        }
    }

    public class_1269 useAction(class_3222 player, class_1937 world, class_2338 pos, class_2350 side, boolean alt) {
        class_2680 state = world.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof WrenchableBlock)) {
            return class_1269.field_5811;
        }
        WrenchableBlock wrenchableBlock = (WrenchableBlock)class_22482;
        List<WrenchAction> actions = wrenchableBlock.getWrenchActions();
        if (actions.isEmpty()) {
            return class_1269.field_5811;
        }
        String current = this.currentAction.get(state.method_26204());
        if (current == null) {
            current = actions.get(0).id();
        }
        for (WrenchAction action : actions) {
            if (!action.id().equals(current)) continue;
            if ((alt ? action.alt() : action.action()).applyAction((class_1657)player, world, pos, side, state, !player.method_5715())) {
                this.pos = null;
                TriggerCriterion.trigger((class_3222)player, (class_2960)FactoryTriggers.WRENCH);
                player.method_17356(FactorySoundEvents.ITEM_WRENCH_USE, class_3419.field_15248, 0.3f, player.method_59922().method_43057() * 0.1f + 0.95f);
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public void attackAction(class_3222 player, class_1937 world, class_2338 pos, class_2350 side) {
        class_2680 state = world.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof WrenchableBlock)) {
            return;
        }
        WrenchableBlock wrenchableBlock = (WrenchableBlock)class_22482;
        List<WrenchAction> actions = wrenchableBlock.getWrenchActions();
        if (actions.isEmpty()) {
            return;
        }
        String current = this.currentAction.get(state.method_26204());
        if (current == null) {
            current = actions.get(0).id();
        }
        boolean foundCurrent = false;
        String nextAction = actions.get(0).id();
        String previousAction = actions.get(actions.size() - 1).id();
        for (WrenchAction action : actions) {
            if (foundCurrent) {
                nextAction = action.id();
                break;
            }
            if (action.id().equals(current)) {
                foundCurrent = true;
                continue;
            }
            previousAction = action.id();
        }
        if (foundCurrent) {
            this.currentAction.put(state.method_26204(), player.method_5715() ? previousAction : nextAction);
            player.method_17356(FactorySoundEvents.ITEM_WRENCH_SWITCH, class_3419.field_15248, 0.3f, 1.0f);
            this.pos = null;
        }
    }
}

