/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.block.mechanical.conveyor.ConveyorBlock;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.function.BiConsumer;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_9280;
import net.minecraft.class_9334;

public class ConveyorModels {
    public static final int FRAMES = 20;
    public static final class_1799[][] ANIMATION_REGULAR_STICKY = new class_1799[16][21];
    public static final class_1799[][] ANIMATION_REGULAR = new class_1799[16][21];
    public static final class_1799[][] ANIMATION_UP = new class_1799[16][21];
    public static final class_1799[][] ANIMATION_UP_STICKY = new class_1799[16][21];
    public static final class_1799[][] ANIMATION_DOWN = new class_1799[16][21];
    public static final class_1799[][] ANIMATION_DOWN_STICKY = new class_1799[16][21];
    private static final class_1792[] MODEL_ITEMS = new class_1792[]{class_1802.field_8850, class_1802.field_8683, class_1802.field_8384, class_1802.field_8078, class_1802.field_8142, class_1802.field_8253, class_1802.field_8580, class_1802.field_8875, class_1802.field_8654, class_1802.field_8290, class_1802.field_8098, class_1802.field_8115, class_1802.field_8294, class_1802.field_8664, class_1802.field_8482, class_1802.field_8611, class_1802.field_8156, class_1802.field_8043, class_1802.field_8783, class_1802.field_8717, class_1802.field_8385, class_1802.field_8672, class_1802.field_8853, class_1802.field_8304, class_1802.field_8133, class_1802.field_8821, class_1802.field_8715, class_1802.field_8455, class_1802.field_8467, class_1802.field_8798, class_1802.field_8353, class_1802.field_8181};
    private static final String MODEL_JSON = "{\n  \"parent\": \"polyfactory:block/|SUBTYPE|conveyor|TYPE|\",\n  \"textures\": {\n    \"1\": \"polyfactory:block/gen/|PREFIX|conveyor_top_|ID|\"\n  }\n}\n";
    private static final String MODEL_JSON_UP = "{\n  \"parent\": \"polyfactory:block/|SUBTYPE|conveyor_up|TYPE|\",\n  \"textures\": {\n    \"1\": \"polyfactory:block/gen/|PREFIX|conveyor_top_|ID|\"\n  }\n}\n";
    private static final String MODEL_JSON_DOWN = "{\n  \"parent\": \"polyfactory:block/|SUBTYPE|conveyor_down|TYPE|\",\n  \"textures\": {\n    \"1\": \"polyfactory:block/gen/|PREFIX|conveyor_top_|ID|\"\n  }\n}\n";
    private static int currentItemIndex;
    public static final class_1799 REGULAR_FAST;
    public static final class_1799 UP_FAST;
    public static final class_1799 DOWN_FAST;
    public static final class_1799 STICKY_REGULAR_FAST;
    public static final class_1799 STICKY_UP_FAST;
    public static final class_1799 STICKY_DOWN_FAST;

    private static void createItemModel(class_1799[] array, String path, int i) {
        PolymerModelData model = PolymerResourcePackUtils.requestModel((class_1792)MODEL_ITEMS[currentItemIndex++ % MODEL_ITEMS.length], (class_2960)FactoryUtil.id(path));
        class_1799 stack = new class_1799((class_1935)model.item());
        stack.method_57379(class_9334.field_49637, (Object)new class_9280(model.value()));
        array[i == 0 ? 0 : array.length - i] = stack;
    }

    public static void registerAssetsEvents() {
        ConveyorModels.createFast(REGULAR_FAST, "", "");
        ConveyorModels.createFast(UP_FAST, "", "_up");
        ConveyorModels.createFast(DOWN_FAST, "", "_down");
        ConveyorModels.createFast(STICKY_REGULAR_FAST, "sticky_", "");
        ConveyorModels.createFast(STICKY_UP_FAST, "sticky_", "_up");
        ConveyorModels.createFast(STICKY_DOWN_FAST, "sticky_", "_down");
        for (int i = 0; i <= 20; ++i) {
            for (int a = 0; a < 16; ++a) {
                Object addition = i == 0 ? (a == 0 ? "" : "_" + a) : "_" + a + "/" + i;
                String prefix = a == 0 && i == 0 ? "" : "gen/";
                ConveyorModels.createItemModel(ANIMATION_REGULAR[a], "block/" + prefix + "conveyor" + (String)addition, i);
                ConveyorModels.createItemModel(ANIMATION_UP[a], "block/" + prefix + "conveyor_up" + (String)addition, i);
                ConveyorModels.createItemModel(ANIMATION_DOWN[a], "block/" + prefix + "conveyor_down" + (String)addition, i);
                ConveyorModels.createItemModel(ANIMATION_REGULAR_STICKY[a], "block/" + prefix + "sticky_conveyor" + (String)addition, i);
                ConveyorModels.createItemModel(ANIMATION_UP_STICKY[a], "block/" + prefix + "sticky_conveyor_up" + (String)addition, i);
                ConveyorModels.createItemModel(ANIMATION_DOWN_STICKY[a], "block/" + prefix + "sticky_conveyor_down" + (String)addition, i);
            }
        }
        if (ModInit.DYNAMIC_ASSETS) {
            PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(resourcePackBuilder -> ConveyorModels.generateModels((arg_0, arg_1) -> ((ResourcePackBuilder)resourcePackBuilder).addData(arg_0, arg_1)));
        }
    }

    private static void createFast(class_1799 stack, String prefix, String suffix) {
        class_2960 path = FactoryUtil.id("block/" + prefix + "conveyor" + suffix + "_fast");
        stack.method_57379(class_9334.field_49637, (Object)new class_9280(PolymerResourcePackUtils.requestModel((class_1792)stack.method_7909(), (class_2960)path).value()));
    }

    public static void generateModels(BiConsumer<String, byte[]> dataWriter) {
        String animJson = "{\n  \"animation\": {\n    \"interpolate\": false,\n    \"frametime\": |SPEED|\n  }\n}\n";
        byte[] textureTop = new byte[]{};
        byte[] textureTopSticky = new byte[]{};
        HashMap<String, JsonObject> models = new HashMap<String, JsonObject>();
        for (Path basePath : ((ModContainer)FabricLoader.getInstance().getModContainer("polyfactory").get()).getRootPaths()) {
            Path path = basePath.resolve("assets/polyfactory/textures/block/conveyor_top.png");
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    textureTop = ConveyorModels.createMovingTexture(path);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (Files.exists(path = path.getParent().resolve("sticky_conveyor_top.png"), new LinkOption[0])) {
                try {
                    textureTopSticky = ConveyorModels.createMovingTexture(path);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            for (String variant : new String[]{"conveyor", "conveyor_up", "conveyor_down"}) {
                path = basePath.resolve("assets/polyfactory/models/block/" + variant + ".json");
                if (!Files.exists(path, new LinkOption[0])) continue;
                try {
                    models.put(variant, (JsonObject)JsonParser.parseReader((Reader)Files.newBufferedReader(path)));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (textureTop.length == 0 || textureTopSticky.length == 0 || models.size() != 3) continue;
            break;
        }
        for (String variant : new String[]{"conveyor", "conveyor_up", "conveyor_down"}) {
            JsonObject model = (JsonObject)models.get(variant);
            for (int i = 1; i < 16; ++i) {
                JsonObject base = new JsonObject();
                base.asMap().putAll(model.asMap());
                JsonArray elements = new JsonArray();
                block30: for (JsonElement element : model.getAsJsonArray("elements")) {
                    JsonElement name = element.getAsJsonObject().get("name");
                    if (name != null) {
                        switch (name.getAsString()) {
                            case "top": {
                                if (!ConveyorBlock.hasTop(i)) break;
                                continue block30;
                            }
                            case "bottom": {
                                if (!ConveyorBlock.hasBottom(i)) break;
                                continue block30;
                            }
                            case "front": {
                                if (!ConveyorBlock.hasNext(i)) break;
                                continue block30;
                            }
                            case "back": {
                                if (!ConveyorBlock.hasPrevious(i)) break;
                                continue block30;
                            }
                            case "top_front": {
                                if (!ConveyorBlock.hasTop(i) || !ConveyorBlock.hasNext(i)) break;
                                continue block30;
                            }
                            case "bottom_front": {
                                if (!ConveyorBlock.hasBottom(i) || !ConveyorBlock.hasNext(i)) break;
                                continue block30;
                            }
                            case "top_back": {
                                if (!ConveyorBlock.hasTop(i) || !ConveyorBlock.hasPrevious(i)) break;
                                continue block30;
                            }
                            case "bottom_back": {
                                if (!ConveyorBlock.hasBottom(i) || !ConveyorBlock.hasPrevious(i)) break;
                                continue block30;
                            }
                        }
                    }
                    elements.add(element);
                }
                base.add("elements", (JsonElement)elements);
                dataWriter.accept("assets/polyfactory/models/block/gen/" + variant + "_" + i + ".json", base.toString().getBytes(StandardCharsets.UTF_8));
                dataWriter.accept("assets/polyfactory/models/block/gen/sticky_" + variant + "_" + i + ".json", ("{\n  \"parent\": \"polyfactory:block/gen/" + variant + "_" + i + "\",\n \"textures\": {\n  \"1\": \"polyfactory:block/sticky_conveyor_top\"\n }\n}\n").getBytes(StandardCharsets.UTF_8));
            }
        }
        for (int i = 1; i <= 20; ++i) {
            byte[] bytes = animJson.replace("|SPEED|", "" + i).getBytes(StandardCharsets.UTF_8);
            ConveyorModels.createVariations(dataWriter, i, bytes, textureTop, "");
            ConveyorModels.createVariations(dataWriter, i, bytes, textureTopSticky, "sticky_");
        }
    }

    private static void createVariations(BiConsumer<String, byte[]> dataWriter, int i, byte[] mcmeta, byte[] texture, String prefix) {
        dataWriter.accept("assets/polyfactory/textures/block/gen/" + prefix + "conveyor_top_" + i + ".png.mcmeta", mcmeta);
        dataWriter.accept("assets/polyfactory/textures/block/gen/" + prefix + "conveyor_top_" + i + ".png", texture);
        for (int a = 0; a < 16; ++a) {
            Object base = a == 0 ? "" : "_" + a;
            String addition = "_" + a + "/" + i;
            dataWriter.accept("assets/polyfactory/models/block/gen/" + prefix + "conveyor" + addition + ".json", MODEL_JSON.replace("|PREFIX|", prefix).replace("|ID|", "" + i).replace("|TYPE|", (CharSequence)base).replace("|SUBTYPE|", a == 0 ? "" : "gen/").getBytes(StandardCharsets.UTF_8));
            dataWriter.accept("assets/polyfactory/models/block/gen/" + prefix + "conveyor_up" + addition + ".json", MODEL_JSON_UP.replace("|PREFIX|", prefix).replace("|ID|", "" + i).replace("|TYPE|", (CharSequence)base).replace("|SUBTYPE|", a == 0 ? "" : "gen/").getBytes(StandardCharsets.UTF_8));
            dataWriter.accept("assets/polyfactory/models/block/gen/" + prefix + "conveyor_down" + addition + ".json", MODEL_JSON_DOWN.replace("|PREFIX|", prefix).replace("|ID|", "" + i).replace("|TYPE|", (CharSequence)base).replace("|SUBTYPE|", a == 0 ? "" : "gen/").getBytes(StandardCharsets.UTF_8));
        }
    }

    private static byte[] createMovingTexture(Path path) throws IOException {
        BufferedImage output;
        BufferedImage image = ImageIO.read(Files.newInputStream(path, new OpenOption[0]));
        int imageSize = 32;
        int textureXSize = 16;
        int textureYSize = 18;
        ColorModel colorModel = image.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel colorModel2 = (IndexColorModel)colorModel;
            output = new BufferedImage(imageSize, imageSize * imageSize, image.getType(), colorModel2);
        } else {
            output = new BufferedImage(imageSize, imageSize * imageSize, image.getType());
        }
        int scale = imageSize / image.getWidth();
        for (int i = 0; i < imageSize; ++i) {
            int position = i * imageSize;
            for (int x = 0; x < textureXSize; ++x) {
                for (int y = 0; y < textureYSize; ++y) {
                    int pixel = image.getRGB((x + i) % textureXSize / scale, y / scale);
                    output.setRGB(x, y + position, pixel);
                    output.setRGB(x + 16, y + position, pixel);
                }
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)output, "png", out);
        return out.toByteArray();
    }

    static {
        REGULAR_FAST = new class_1799((class_1935)MODEL_ITEMS[currentItemIndex++]);
        UP_FAST = new class_1799((class_1935)MODEL_ITEMS[currentItemIndex++]);
        DOWN_FAST = new class_1799((class_1935)MODEL_ITEMS[currentItemIndex++]);
        STICKY_REGULAR_FAST = new class_1799((class_1935)MODEL_ITEMS[currentItemIndex++]);
        STICKY_UP_FAST = new class_1799((class_1935)MODEL_ITEMS[currentItemIndex++]);
        STICKY_DOWN_FAST = new class_1799((class_1935)MODEL_ITEMS[currentItemIndex++]);
    }
}

