/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.models.fluid;

import eu.pb4.factorytools.api.resourcepack.BaseItemProvider;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidType;
import eu.pb4.polyfactory.other.FactoryRegistries;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.ModelRenderType;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class FluidModel {
    private static final String BASE_MODEL = "{\n  \"parent\": \"|BASE|\",\n  \"textures\": {\n    \"texture\": \"|ID|\"\n  }\n}\n".replace(" ", "").replace("\n", "");
    private final class_2960 baseModel;
    private final List<class_3545<class_2960, class_2960>> textures = new ArrayList<class_3545<class_2960, class_2960>>();
    private final Map<FluidType<?>, class_1799> model = new IdentityHashMap();

    public FluidModel(class_2960 model) {
        this(model, FactoryUtil::requestModelBase);
    }

    public FluidModel(class_2960 model, Function<ModelRenderType, class_1792> function) {
        this.baseModel = model;
        for (class_2960 fluid : FactoryRegistries.FLUID_TYPES.method_10235()) {
            this.addTextures(fluid, Objects.requireNonNull((FluidType)FactoryRegistries.FLUID_TYPES.method_10223(fluid)), function);
        }
        RegistryEntryAddedCallback.event(FactoryRegistries.FLUID_TYPES).register((rawId, id, object) -> this.addTextures(id, (FluidType<?>)object, function));
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(b -> this.generateAssets((arg_0, arg_1) -> ((ResourcePackBuilder)b).addData(arg_0, arg_1)));
    }

    public <T> class_1799 get(FluidType<T> fluid, T data) {
        class_1799 stack = this.model.getOrDefault(fluid, class_1799.field_8037);
        if (fluid.color().isEmpty()) {
            return stack;
        }
        stack = stack.method_7972();
        stack.method_57379(class_9334.field_49644, (Object)new class_9282(fluid.color().get().getColor(data), false));
        return stack;
    }

    public <T> class_1799 get(@Nullable FluidInstance<T> type) {
        if (type == null) {
            return class_1799.field_8037;
        }
        return this.get(type.type(), type.data());
    }

    private void addTextures(class_2960 id, FluidType<?> object, Function<ModelRenderType, class_1792> function) {
        this.textures.add((class_3545<class_2960, class_2960>)new class_3545((Object)id, (Object)object.texture()));
        this.model.put(object, BaseItemProvider.requestModel((class_1792)function.apply(object.modelRenderType()), (class_2960)this.baseModel.method_48331("/" + id.method_12836() + "/" + id.method_12832())));
    }

    private void generateAssets(BiConsumer<String, byte[]> assetWriter) {
        for (class_3545<class_2960, class_2960> fluid : this.textures) {
            assetWriter.accept("assets/" + this.baseModel.method_12836() + "/models/" + this.baseModel.method_12832() + "/" + ((class_2960)fluid.method_15442()).method_12836() + "/" + ((class_2960)fluid.method_15442()).method_12832() + ".json", BASE_MODEL.replace("|BASE|", this.baseModel.toString()).replace("|ID|", ((class_2960)fluid.method_15441()).toString()).getBytes(StandardCharsets.UTF_8));
        }
    }

    public class_1799 getRaw(FluidInstance<?> x) {
        return this.model.get(x.type());
    }
}

