/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.models.fluid;

import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.block.property.ConnectablePart;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SidedMultiFluidViewModel {
    private final Map<FluidInstance<?>, Layer> fluidLayers = new Object2ObjectOpenHashMap();
    private final ElementHolder holder;
    private Layer topLayer;
    private Layer bottomLayer;
    private FluidInstance<?> fluidAbove;
    private FluidInstance<?> fluidBelow;
    private float position = 0.0f;
    private ConnectablePart xPart;
    private ConnectablePart zPart;

    public SidedMultiFluidViewModel(ElementHolder holder, ConnectablePart xPart, ConnectablePart zPart) {
        this.holder = holder;
        this.xPart = xPart;
        this.zPart = zPart;
    }

    public void update(ConnectablePart xPart, ConnectablePart zPart) {
        if (this.xPart == xPart && this.zPart == zPart) {
            return;
        }
        this.xPart = xPart;
        this.zPart = zPart;
        for (Layer x : this.fluidLayers.values()) {
            x.update(this);
        }
    }

    public ConnectablePart getX() {
        return this.xPart;
    }

    public ConnectablePart getZ() {
        return this.zPart;
    }

    private static int textureId(float amount) {
        return class_3532.method_15340((int)Math.round(amount * 15.0f), (int)0, (int)15);
    }

    private void setLayer(FluidInstance<?> instance, float amount) {
        Layer layer = this.fluidLayers.get(instance);
        if (layer == null) {
            class_1799 modelTop = FactoryModels.FLUID_FLAT_FULL.get(instance);
            EnumMap<class_2350, ItemDisplayElement> parts = new EnumMap<class_2350, ItemDisplayElement>(class_2350.class);
            for (class_2350 dir : class_2350.values()) {
                ItemDisplayElement model = ItemDisplayElementUtil.createSimple((class_1799)modelTop);
                model.setViewRange(0.5f);
                parts.put(dir, model);
                if (dir.method_10166() != class_2350.class_2351.field_11052) {
                    model.setPitch(90.0f);
                    model.setYaw(dir.method_10144());
                }
                instance.brightness().ifPresent(arg_0 -> ((ItemDisplayElement)model).setBrightness(arg_0));
            }
            layer = new Layer(instance, parts);
            this.fluidLayers.put(instance, layer);
        }
        layer.setup(this.position, amount);
        this.position += amount + 0.001f;
    }

    public void setFluids(@Nullable FluidInstance<?> topFluid, @Nullable FluidInstance<?> bottomFluid, Consumer<BiConsumer<FluidInstance<?>, Float>> consumer, Predicate<FluidInstance<?>> removePredicate) {
        this.position = 0.0f;
        consumer.accept(this::setLayer);
        for (FluidInstance<?> key : List.copyOf(this.fluidLayers.keySet())) {
            if (!removePredicate.test(key)) continue;
            this.fluidLayers.remove(key).destroy(this);
        }
        this.topLayer = this.fluidLayers.get(topFluid);
        this.bottomLayer = this.fluidLayers.get(bottomFluid);
        for (Layer l : this.fluidLayers.values()) {
            l.update(this);
        }
        if (this.topLayer != null) {
            this.topLayer.updateTop(this);
        }
        if (this.bottomLayer != null) {
            this.bottomLayer.updateBottom(this);
        }
    }

    public void setFluidAbove(@Nullable FluidInstance<?> fluidInstance) {
        if (this.fluidAbove == null && fluidInstance == null || this.fluidAbove != null && this.fluidAbove.equals(fluidInstance)) {
            return;
        }
        this.fluidAbove = fluidInstance;
    }

    public void setFluidBelow(@Nullable FluidInstance<?> fluidInstance) {
        if (this.fluidBelow == null && fluidInstance == null || this.fluidBelow != null && this.fluidBelow.equals(fluidInstance)) {
            return;
        }
        this.fluidBelow = fluidInstance;
    }

    private void addElement(VirtualElement element) {
        this.holder.addElement(element);
    }

    private void removeElement(VirtualElement element) {
        this.holder.removeElement(element);
    }

    private record Layer(FluidInstance<?> instance, EnumMap<class_2350, ItemDisplayElement> parts) {
        public void update(SidedMultiFluidViewModel model) {
            class_2350 dir;
            class_2350.class_2352 val;
            if (model.bottomLayer == this && this.instance.equals(model.fluidAbove)) {
                model.removeElement((VirtualElement)this.parts.get(class_2350.field_11036));
            } else {
                model.addElement((VirtualElement)this.parts.get(class_2350.field_11036));
            }
            if (model.topLayer == this && this.instance.equals(model.fluidBelow)) {
                model.removeElement((VirtualElement)this.parts.get(class_2350.field_11033));
            } else {
                model.addElement((VirtualElement)this.parts.get(class_2350.field_11033));
            }
            ConnectablePart x = model.getX();
            ConnectablePart z = model.getZ();
            if (!z.middle()) {
                val = z.axisDirection();
                if (val == null) {
                    model.addElement((VirtualElement)this.parts.get(class_2350.field_11043));
                    model.addElement((VirtualElement)this.parts.get(class_2350.field_11035));
                } else {
                    dir = class_2350.method_10169((class_2350.class_2351)class_2350.class_2351.field_11051, (class_2350.class_2352)val);
                    model.addElement((VirtualElement)this.parts.get(dir));
                    model.removeElement((VirtualElement)this.parts.get(dir.method_10153()));
                }
            } else {
                model.removeElement((VirtualElement)this.parts.get(class_2350.field_11043));
                model.removeElement((VirtualElement)this.parts.get(class_2350.field_11035));
            }
            if (!x.middle()) {
                val = x.axisDirection();
                if (val == null) {
                    model.addElement((VirtualElement)this.parts.get(class_2350.field_11034));
                    model.addElement((VirtualElement)this.parts.get(class_2350.field_11039));
                } else {
                    dir = class_2350.method_10169((class_2350.class_2351)class_2350.class_2351.field_11048, (class_2350.class_2352)val);
                    model.addElement((VirtualElement)this.parts.get(dir));
                    model.removeElement((VirtualElement)this.parts.get(dir.method_10153()));
                }
            } else {
                model.removeElement((VirtualElement)this.parts.get(class_2350.field_11034));
                model.removeElement((VirtualElement)this.parts.get(class_2350.field_11039));
            }
        }

        public void updateTop(SidedMultiFluidViewModel model) {
            if (this.instance.equals(model.fluidAbove)) {
                model.removeElement((VirtualElement)this.parts.get(class_2350.field_11036));
            } else {
                model.addElement((VirtualElement)this.parts.get(class_2350.field_11036));
            }
        }

        public void updateBottom(SidedMultiFluidViewModel model) {
            if (this.instance.equals(model.fluidBelow)) {
                model.removeElement((VirtualElement)this.parts.get(class_2350.field_11033));
            } else {
                model.addElement((VirtualElement)this.parts.get(class_2350.field_11033));
            }
        }

        public void destroy(SidedMultiFluidViewModel model) {
            for (ItemDisplayElement part : this.parts.values()) {
                model.removeElement((VirtualElement)part);
            }
        }

        public void setup(float position, float amount) {
            this.parts.get(class_2350.field_11033).setTranslation((Vector3fc)new Vector3f(0.0f, -0.5f + position * 15.9f / 16.0f + 0.001f, 0.0f));
            this.parts.get(class_2350.field_11036).setTranslation((Vector3fc)new Vector3f(0.0f, -0.5f + (position + amount) * 15.9f / 16.0f + 0.001f, 0.0f));
            class_1799 side = FactoryModels.FLUID_FLAT_SCALED[SidedMultiFluidViewModel.textureId(amount)].get(this.instance);
            for (class_2350 dir : FactoryUtil.HORIZONTAL_DIRECTIONS) {
                ItemDisplayElement part = this.parts.get(dir);
                part.setTranslation((Vector3fc)new Vector3f(0.0f, 0.499f, -(-0.5f + (position + amount / 2.0f) * 15.9f / 16.0f + 0.001f)));
                part.setScale((Vector3fc)new Vector3f(1.0f, 1.0f, amount));
                part.setItem(side);
            }
        }
    }
}

