/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.models.fluid;

import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.models.fluid.FluidModel;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_3532;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SimpleMultiFluidViewModel {
    private final Map<FluidInstance<?>, ItemDisplayElement> fluidLayers = new Object2ObjectOpenHashMap();
    private final ElementHolder holder;
    private float height;
    private float position = 0.0f;
    private FluidModel[] models;
    private float pitch;
    private float yaw;
    private final List<Layer> layers = new ArrayList<Layer>();

    public SimpleMultiFluidViewModel(ElementHolder holder, FluidModel[] models, float height) {
        this.holder = holder;
        this.models = models;
        this.height = height;
    }

    public void setModels(FluidModel[] models, float height) {
        if (this.models == models && this.height == height) {
            return;
        }
        this.models = models;
        this.height = height;
        this.position = 0.0f;
        for (Layer x : this.layers) {
            ItemDisplayElement y = this.fluidLayers.get(x.fluid);
            if (y == null) continue;
            this.setValues(y, x.fluid, x.amount);
        }
    }

    private int textureId(float amount) {
        return class_3532.method_15340((int)Math.round(amount * (float)this.models.length), (int)0, (int)(this.models.length - 1));
    }

    private void setLayer(FluidInstance<?> instance, float amount) {
        this.layers.add(new Layer(instance, amount));
        ItemDisplayElement layer = this.fluidLayers.get(instance);
        if (layer == null) {
            layer = ItemDisplayElementUtil.createSimple();
            layer.setViewRange(0.5f);
            layer.setYaw(this.yaw);
            layer.setPitch(this.pitch);
            instance.brightness().ifPresent(arg_0 -> ((ItemDisplayElement)layer).setBrightness(arg_0));
            this.fluidLayers.put(instance, layer);
        }
        this.setValues(layer, instance, amount);
        this.addElement((VirtualElement)layer);
    }

    private void setValues(ItemDisplayElement layer, FluidInstance<?> instance, float amount) {
        float scale = this.height / 16.0f;
        layer.setTranslation((Vector3fc)new Vector3f(0.0f, (-0.5f + (this.position + amount / 2.0f) * 15.9f / 16.0f + 0.003f) * scale, 0.0f));
        layer.setScale((Vector3fc)new Vector3f(1.0f, amount, 1.0f));
        layer.setItem(this.models[this.textureId(amount)].get(instance));
        this.position += amount + 0.001f;
    }

    public void setFluids(Consumer<BiConsumer<FluidInstance<?>, Float>> consumer, Predicate<FluidInstance<?>> removePredicate) {
        this.position = 0.0f;
        this.layers.clear();
        consumer.accept(this::setLayer);
        for (FluidInstance<?> key : List.copyOf(this.fluidLayers.keySet())) {
            if (!removePredicate.test(key)) continue;
            this.removeElement((VirtualElement)this.fluidLayers.remove(key));
        }
    }

    private void addElement(VirtualElement element) {
        this.holder.addElement(element);
    }

    private void removeElement(VirtualElement element) {
        this.holder.removeElement(element);
    }

    public void setRotation(float pitch, float yaw) {
        if (this.pitch != pitch || this.yaw != yaw) {
            this.pitch = pitch;
            this.yaw = yaw;
            for (ItemDisplayElement x : this.fluidLayers.values()) {
                x.setPitch(pitch);
                x.setYaw(yaw);
            }
        }
    }

    private record Layer(FluidInstance<?> fluid, float amount) {
    }
}

