/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.nodes;

import com.kneelawk.graphlib.api.graph.GraphUniverse;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.LinkKey;
import com.kneelawk.graphlib.api.util.EmptyLinkKey;
import com.kneelawk.graphlib.api.util.HalfLink;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.nodes.data.ChannelProviderDirectionNode;
import eu.pb4.polyfactory.nodes.data.ChannelProviderSelectiveSideNode;
import eu.pb4.polyfactory.nodes.data.ChannelReceiverDirectionNode;
import eu.pb4.polyfactory.nodes.data.ChannelReceiverSelectiveSideNode;
import eu.pb4.polyfactory.nodes.data.DataStorage;
import eu.pb4.polyfactory.nodes.electric.EnergyData;
import eu.pb4.polyfactory.nodes.generic.AllSideNode;
import eu.pb4.polyfactory.nodes.generic.FunctionalAxisNode;
import eu.pb4.polyfactory.nodes.generic.FunctionalDirectionNode;
import eu.pb4.polyfactory.nodes.generic.FunctionalNode;
import eu.pb4.polyfactory.nodes.generic.NotAxisNode;
import eu.pb4.polyfactory.nodes.generic.SelectiveSideNode;
import eu.pb4.polyfactory.nodes.generic.SimpleAxisNode;
import eu.pb4.polyfactory.nodes.generic.SimpleDirectionNode;
import eu.pb4.polyfactory.nodes.generic.UnconnectedNode;
import eu.pb4.polyfactory.nodes.mechanical.AxleWithGearMechanicalNode;
import eu.pb4.polyfactory.nodes.mechanical.ConveyorNode;
import eu.pb4.polyfactory.nodes.mechanical.GearMechanicalNode;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.nodes.mechanical.UnconnectedFunctionalGearMechanicalNode;
import eu.pb4.polyfactory.nodes.mechanical.UnconnectedGearMechanicalNode;
import eu.pb4.polyfactory.nodes.mechanical_connectors.LargeGearNode;
import eu.pb4.polyfactory.nodes.mechanical_connectors.SmallGearNode;
import eu.pb4.polyfactory.nodes.pipe.FlowData;
import eu.pb4.polyfactory.nodes.pipe.NozzleNode;
import eu.pb4.polyfactory.nodes.pipe.PumpNode;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class FactoryNodes {
    public static final GraphUniverse ROTATIONAL = FactoryNodes.registerRotational();
    public static final GraphUniverse ROTATIONAL_CONNECTOR = FactoryNodes.registerRotationalConnector();
    public static final GraphUniverse ENERGY = FactoryNodes.registerEnergy();
    public static final GraphUniverse DATA = FactoryNodes.registerData();
    public static final GraphUniverse PIPE = FactoryNodes.registerPipe();

    public static void register() {
    }

    private static GraphUniverse registerRotational() {
        GraphUniverse universe = GraphUniverse.builder().build(ModInit.id("rotations"));
        universe.addDiscoverer((world, pos) -> {
            class_2680 blockState = world.method_8320(pos);
            class_2248 patt0$temp = blockState.method_26204();
            if (patt0$temp instanceof NetworkComponent.Rotational) {
                NetworkComponent.Rotational rotational = (NetworkComponent.Rotational)patt0$temp;
                return rotational.createRotationalNodes(blockState, world, pos);
            }
            return List.of();
        });
        FactoryNodes.addSimpleNodes(universe);
        universe.addNodeType(ConveyorNode.TYPE);
        universe.addNodeType(AxleWithGearMechanicalNode.TYPE);
        universe.addNodeType(UnconnectedGearMechanicalNode.TYPE);
        universe.addNodeType(UnconnectedFunctionalGearMechanicalNode.TYPE);
        universe.addGraphEntityType(RotationData.TYPE);
        universe.addCacheCategory(GearMechanicalNode.CACHE);
        universe.register();
        return universe;
    }

    private static GraphUniverse registerData() {
        GraphUniverse universe = GraphUniverse.builder().build(ModInit.id("data"));
        universe.addDiscoverer((world, pos) -> {
            class_2680 blockState = world.method_8320(pos);
            class_2248 patt0$temp = blockState.method_26204();
            if (patt0$temp instanceof NetworkComponent.Data) {
                NetworkComponent.Data rotational = (NetworkComponent.Data)patt0$temp;
                return rotational.createDataNodes(blockState, world, pos);
            }
            return List.of();
        });
        FactoryNodes.addSimpleNodes(universe);
        universe.addNodeType(ChannelProviderDirectionNode.TYPE);
        universe.addNodeType(ChannelReceiverDirectionNode.TYPE);
        universe.addNodeType(ChannelReceiverSelectiveSideNode.TYPE);
        universe.addNodeType(ChannelProviderSelectiveSideNode.TYPE);
        universe.addGraphEntityType(DataStorage.TYPE);
        universe.register();
        return universe;
    }

    private static GraphUniverse registerPipe() {
        GraphUniverse universe = GraphUniverse.builder().build(ModInit.id("pipe"));
        universe.addDiscoverer((world, pos) -> {
            class_2680 blockState = world.method_8320(pos);
            class_2248 patt0$temp = blockState.method_26204();
            if (patt0$temp instanceof NetworkComponent.Pipe) {
                NetworkComponent.Pipe rotational = (NetworkComponent.Pipe)patt0$temp;
                return rotational.createPipeNodes(blockState, world, pos);
            }
            return List.of();
        });
        FactoryNodes.addSimpleNodes(universe);
        universe.addNodeType(PumpNode.TYPE);
        universe.addNodeType(NozzleNode.TYPE);
        universe.addCacheCategory(PumpNode.CACHE);
        universe.addGraphEntityType(FlowData.TYPE);
        universe.register();
        return universe;
    }

    private static GraphUniverse registerEnergy() {
        GraphUniverse universe = GraphUniverse.builder().build(ModInit.id("energy"));
        universe.addDiscoverer((world, pos) -> {
            class_2680 blockState = world.method_8320(pos);
            class_2248 patt0$temp = blockState.method_26204();
            if (patt0$temp instanceof NetworkComponent.Energy) {
                NetworkComponent.Energy rotational = (NetworkComponent.Energy)patt0$temp;
                return rotational.createEnergyNodes(blockState, world, pos);
            }
            return List.of();
        });
        FactoryNodes.addSimpleNodes(universe);
        universe.addGraphEntityType(EnergyData.TYPE);
        universe.register();
        return universe;
    }

    private static GraphUniverse registerRotationalConnector() {
        GraphUniverse universe = GraphUniverse.builder().build(ModInit.id("rotation_connector"));
        universe.addDiscoverer((world, pos) -> {
            class_2680 blockState = world.method_8320(pos);
            class_2248 patt0$temp = blockState.method_26204();
            if (patt0$temp instanceof NetworkComponent.RotationalConnector) {
                NetworkComponent.RotationalConnector rotational = (NetworkComponent.RotationalConnector)patt0$temp;
                return rotational.createRotationalConnectorNodes(blockState, world, pos);
            }
            return List.of();
        });
        FactoryNodes.addSimpleNodes(universe);
        universe.addNodeType(LargeGearNode.TYPE);
        universe.addNodeType(SmallGearNode.TYPE);
        universe.register();
        return universe;
    }

    private static void addSimpleNodes(GraphUniverse universe) {
        universe.addNodeType(FunctionalDirectionNode.TYPE);
        universe.addNodeType(FunctionalAxisNode.TYPE);
        universe.addNodeType(SimpleDirectionNode.TYPE);
        universe.addNodeType(SimpleAxisNode.TYPE);
        universe.addNodeType(AllSideNode.TYPE);
        universe.addNodeType(SelectiveSideNode.TYPE);
        universe.addNodeType(NotAxisNode.TYPE);
        universe.addNodeType(UnconnectedNode.TYPE);
        universe.addCacheCategory(FunctionalNode.CACHE);
    }

    public static boolean canBothConnect(@NotNull NodeHolder<BlockNode> alpha, @NotNull NodeHolder<BlockNode> beta) {
        return alpha.getNode().canConnect(alpha, new HalfLink((LinkKey)EmptyLinkKey.INSTANCE, beta)) && beta.getNode().canConnect(beta, new HalfLink((LinkKey)EmptyLinkKey.INSTANCE, alpha));
    }

    public static Stream<HalfLink> findNodes(@NotNull NodeHolder<BlockNode> self, class_2338 pos) {
        return self.getGraphWorld().getNodesAt(pos).filter(x -> FactoryNodes.canBothConnect(self, (NodeHolder<BlockNode>)x)).map(x -> new HalfLink((LinkKey)EmptyLinkKey.INSTANCE, x));
    }

    public static Stream<HalfLink> findNodes(@NotNull NodeHolder<BlockNode> self, class_2338 pos, BiPredicate<NodeHolder<BlockNode>, NodeHolder<BlockNode>> predicate) {
        return self.getGraphWorld().getNodesAt(pos).filter(x -> FactoryNodes.canBothConnect(self, (NodeHolder<BlockNode>)x) && predicate.test(self, (NodeHolder<BlockNode>)x)).map(x -> new HalfLink((LinkKey)EmptyLinkKey.INSTANCE, x));
    }
}

