/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.nodes.data;

import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphEntityContext;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.GraphEntity;
import com.kneelawk.graphlib.api.graph.user.GraphEntityType;
import com.kneelawk.graphlib.api.graph.user.LinkEntity;
import com.kneelawk.graphlib.api.graph.user.NodeEntity;
import com.kneelawk.graphlib.api.util.LinkPos;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.block.data.DataProvider;
import eu.pb4.polyfactory.block.data.DataReceiver;
import eu.pb4.polyfactory.data.DataContainer;
import eu.pb4.polyfactory.nodes.DirectionNode;
import eu.pb4.polyfactory.nodes.data.DataProviderNode;
import eu.pb4.polyfactory.nodes.data.DataReceiverNode;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataStorage
implements GraphEntity<DataStorage> {
    public static final int MAX_CHANNELS = 4;
    public static final Codec<DataStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DataEntry.CODEC.listOf().optionalFieldOf("current_data", List.of()).forGetter(e -> {
        ArrayList<DataEntry> list = new ArrayList<DataEntry>();
        for (Int2ObjectMap.Entry x : e.currentData.int2ObjectEntrySet()) {
            list.add(new DataEntry(x.getIntKey(), ((SentData)x.getValue()).pos, ((SentData)x.getValue()).container, Optional.ofNullable(((SentData)x.getValue()).direction)));
        }
        return list;
    })).apply((Applicative)instance, DataStorage::new));
    public static final GraphEntityType<DataStorage> TYPE = GraphEntityType.of((class_2960)ModInit.id("data_storage"), CODEC, DataStorage::new, DataStorage::split);
    public static DataStorage EMPTY = new DataStorage(){};
    private final Int2ObjectOpenHashMap<Set<class_3545<class_2338, DataReceiverNode>>> receivers = new Int2ObjectOpenHashMap();
    private final Int2ObjectOpenHashMap<Set<class_3545<class_2338, DataProviderNode>>> providers = new Int2ObjectOpenHashMap();
    private Int2ObjectOpenHashMap<SentData> currentData = new Int2ObjectOpenHashMap();
    private Int2ObjectOpenHashMap<SentData> swapData = new Int2ObjectOpenHashMap();
    private GraphEntityContext ctx;

    public DataStorage() {
    }

    private DataStorage(List<DataEntry> entries) {
        for (DataEntry entry : entries) {
            this.currentData.put(entry.key, (Object)new SentData(entry.dataContainer, entry.blockPos, entry.direction.orElse(null)));
        }
    }

    private static <T> void mergeMap(Int2ObjectOpenHashMap<Set<T>> into, Int2ObjectOpenHashMap<Set<T>> from) {
        for (Int2ObjectMap.Entry entry : from.int2ObjectEntrySet()) {
            Set self = (Set)into.get(entry.getIntKey());
            if (self == null) {
                into.put(entry.getIntKey(), new HashSet((Collection)entry.getValue()));
                continue;
            }
            self.addAll((Collection)entry.getValue());
        }
    }

    private static <T> void splitMap(Int2ObjectOpenHashMap<Set<class_3545<class_2338, T>>> into, Int2ObjectOpenHashMap<Set<class_3545<class_2338, T>>> from, BlockGraph targetGraph) {
        for (Int2ObjectMap.Entry entry : from.int2ObjectEntrySet()) {
            HashSet<class_3545> set = new HashSet<class_3545>();
            for (class_3545 pos : List.copyOf((Collection)entry.getValue())) {
                if (!targetGraph.getNodesAt((class_2338)pos.method_15442()).findAny().isPresent()) continue;
                set.add(pos);
                ((Set)entry.getValue()).remove(pos);
            }
            if (set.isEmpty()) continue;
            into.put(entry.getIntKey(), set);
        }
    }

    @Nullable
    public SentData getData(int channel) {
        class_1937 class_19372;
        if (this.ctx == null || !((class_19372 = this.ctx.getBlockWorld()) instanceof class_3218)) {
            return null;
        }
        class_3218 world = (class_3218)class_19372;
        SentData current = (SentData)this.currentData.get(channel);
        if (current != null) {
            return current;
        }
        Set providers = (Set)this.providers.get(channel);
        if (providers == null) {
            return null;
        }
        for (class_3545 x : providers) {
            class_2350 class_23502;
            DataProvider provider;
            DataContainer c;
            class_2680 state = world.method_8320((class_2338)x.method_15442());
            class_2248 class_22482 = state.method_26204();
            if (!(class_22482 instanceof DataProvider) || (c = (provider = (DataProvider)class_22482).provideData(world, (class_2338)x.method_15442(), state, channel, (DataProviderNode)x.method_15441())) == null) continue;
            class_2338 class_23382 = (class_2338)x.method_15442();
            Object object = x.method_15441();
            if (object instanceof DirectionNode) {
                DirectionNode d = (DirectionNode)object;
                class_23502 = d.direction();
            } else {
                class_23502 = null;
            }
            return new SentData(c, class_23382, class_23502);
        }
        return null;
    }

    public int pushDataUpdate(class_2338 pos, int channel, DataContainer data, @Nullable class_2350 direction) {
        this.currentData.put(channel, (Object)new SentData(data, pos, direction));
        Set receivers = (Set)this.receivers.get(channel);
        if (receivers == null) {
            return 0;
        }
        return receivers.size();
    }

    public void onTick() {
        class_1937 class_19372;
        if (this.ctx == null || !((class_19372 = this.ctx.getBlockWorld()) instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        if (this.currentData.isEmpty()) {
            return;
        }
        if (this.receivers.isEmpty()) {
            this.currentData.clear();
        } else {
            Int2ObjectOpenHashMap<SentData> current = this.currentData;
            this.currentData = this.swapData;
            for (Int2ObjectMap.Entry data : current.int2ObjectEntrySet()) {
                Set rec = (Set)this.receivers.get(data.getIntKey());
                if (rec == null) continue;
                for (class_3545 x : rec) {
                    class_2680 state = world.method_8320((class_2338)x.method_15442());
                    class_2248 class_22482 = state.method_26204();
                    if (!(class_22482 instanceof DataReceiver)) continue;
                    DataReceiver receiver = (DataReceiver)class_22482;
                    receiver.receiveData(world, (class_2338)x.method_15442(), state, data.getIntKey(), ((SentData)data.getValue()).container(), (DataReceiverNode)x.method_15441(), ((SentData)data.getValue()).pos, ((SentData)data.getValue()).direction);
                }
            }
            current.clear();
            this.swapData = current;
        }
    }

    public void onPostNodeCreated(@NotNull NodeHolder<BlockNode> node, @Nullable NodeEntity nodeEntity) {
        super.onPostNodeCreated(node, nodeEntity);
        this.storeReceiverOrProvider(node);
        class_1937 class_19372 = node.getBlockWorld();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            BlockNode blockNode = node.getNode();
            if (blockNode instanceof DataProviderNode) {
                DataProvider provider;
                DataContainer data;
                DataProviderNode providerNode = (DataProviderNode)blockNode;
                state = node.getBlockWorld().method_8320(node.getBlockPos());
                class_2248 class_22482 = state.method_26204();
                if (class_22482 instanceof DataProvider && (data = (provider = (DataProvider)class_22482).provideData(serverWorld, node.getBlockPos(), (class_2680)state, providerNode.channel(), providerNode)) != null) {
                    class_2350 class_23502;
                    class_2338 class_23382 = node.getBlockPos();
                    int n = providerNode.channel();
                    if (providerNode instanceof DirectionNode) {
                        DirectionNode d = (DirectionNode)((Object)providerNode);
                        class_23502 = d.direction();
                    } else {
                        class_23502 = null;
                    }
                    this.pushDataUpdate(class_23382, n, data, class_23502);
                }
            } else {
                state = node.getNode();
                if (state instanceof DataReceiverNode) {
                    DataReceiverNode receiverNode = (DataReceiverNode)state;
                    state = node.getBlockWorld().method_8320(node.getBlockPos());
                    Object data = state.method_26204();
                    if (data instanceof DataReceiver) {
                        DataReceiver receiver = (DataReceiver)data;
                        data = this.getData(receiverNode.channel());
                        if (data != null) {
                            receiver.receiveData(serverWorld, node.getBlockPos(), (class_2680)state, receiverNode.channel(), ((SentData)data).container(), receiverNode, ((SentData)data).pos(), ((SentData)data).direction);
                        }
                    }
                }
            }
        }
    }

    public void onPostNodeDestroyed(@NotNull NodeHolder<BlockNode> node, @Nullable NodeEntity nodeEntity, Map<LinkPos, LinkEntity> linkEntities) {
        super.onPostNodeDestroyed(node, nodeEntity, linkEntities);
        BlockNode blockNode = node.getNode();
        if (blockNode instanceof DataReceiverNode) {
            DataReceiverNode data = (DataReceiverNode)blockNode;
            this.removeMap(this.receivers, data.channel(), node.getBlockPos(), data);
        } else {
            blockNode = node.getNode();
            if (blockNode instanceof DataProviderNode) {
                DataProviderNode data = (DataProviderNode)blockNode;
                this.removeMap(this.providers, data.channel(), node.getBlockPos(), data);
            }
        }
    }

    private void storeReceiverOrProvider(NodeHolder<BlockNode> node) {
        BlockNode blockNode = node.getNode();
        if (blockNode instanceof DataReceiverNode) {
            DataReceiverNode data = (DataReceiverNode)blockNode;
            this.addMap(this.receivers, data.channel(), node.getBlockPos(), data);
        } else {
            blockNode = node.getNode();
            if (blockNode instanceof DataProviderNode) {
                DataProviderNode data = (DataProviderNode)blockNode;
                this.addMap(this.providers, data.channel(), node.getBlockPos(), data);
            }
        }
    }

    private <T> void addMap(Int2ObjectOpenHashMap<Set<class_3545<class_2338, T>>> map, int channel, class_2338 blockPos, T data) {
        HashSet<class_3545> set = (HashSet<class_3545>)map.get(channel);
        if (set == null) {
            set = new HashSet<class_3545>();
            map.put(channel, set);
        }
        set.add(new class_3545((Object)blockPos, data));
    }

    private <T> void removeMap(Int2ObjectOpenHashMap<Set<class_3545<class_2338, T>>> map, int channel, class_2338 blockPos, T data) {
        Set set = (Set)map.get(channel);
        if (set == null) {
            return;
        }
        set.removeIf(x -> ((class_2338)x.method_15442()).equals((Object)blockPos) && x.method_15441().equals(data));
        if (set.isEmpty()) {
            map.remove(channel);
        }
    }

    public void onInit(@NotNull GraphEntityContext ctx) {
        this.ctx = ctx;
        ctx.getGraph().getNodes().forEach(this::storeReceiverOrProvider);
    }

    @NotNull
    public GraphEntityContext getContext() {
        return this.ctx;
    }

    @NotNull
    public GraphEntityType<?> getType() {
        return TYPE;
    }

    public void merge(@NotNull DataStorage other) {
        DataStorage.mergeMap(this.providers, other.providers);
        DataStorage.mergeMap(this.receivers, other.receivers);
        for (Integer channel : this.receivers.keySet()) {
            SentData data = this.getData(channel);
            if (data == null) continue;
            for (class_3545 x : (Set)this.receivers.get(channel.intValue())) {
                class_2680 state = this.ctx.getBlockWorld().method_8320((class_2338)x.method_15442());
                class_2248 class_22482 = state.method_26204();
                if (!(class_22482 instanceof DataReceiver)) continue;
                DataReceiver receiver = (DataReceiver)class_22482;
                receiver.receiveData((class_3218)this.ctx.getBlockWorld(), (class_2338)x.method_15442(), state, channel, data.container, (DataReceiverNode)x.method_15441(), data.pos, data.direction);
            }
        }
    }

    @NotNull
    private DataStorage split(@NotNull BlockGraph originalGraph, @NotNull BlockGraph newGraph) {
        DataStorage data = new DataStorage();
        DataStorage.splitMap(data.receivers, this.receivers, newGraph);
        DataStorage.splitMap(data.providers, this.providers, newGraph);
        return data;
    }

    public boolean hasReceivers() {
        return !this.receivers.isEmpty();
    }

    public boolean hasProviders() {
        return !this.providers.isEmpty();
    }

    private record DataEntry(int key, class_2338 blockPos, DataContainer dataContainer, Optional<class_2350> direction) {
        private static final Codec<class_2338> BLOCK_POS_CODEC = Codec.withAlternative((Codec)class_2338.field_25064, (Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("X").forGetter(class_2382::method_10263), (App)Codec.INT.fieldOf("Y").forGetter(class_2382::method_10264), (App)Codec.INT.fieldOf("Z").forGetter(class_2382::method_10260)).apply((Applicative)instance, class_2338::new)));
        public static final Codec<DataEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("__key").forGetter(DataEntry::key), (App)BLOCK_POS_CODEC.fieldOf("__pos").forGetter(DataEntry::blockPos), (App)DataContainer.MAP_CODEC.forGetter(DataEntry::dataContainer), (App)class_2350.field_29502.optionalFieldOf("__dir").forGetter(DataEntry::direction)).apply((Applicative)instance, DataEntry::new));
    }

    public record SentData(DataContainer container, class_2338 pos, @Nullable class_2350 direction) {
    }
}

