/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.nodes.pipe;

import com.google.common.collect.Multimap;
import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphEntityContext;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.GraphEntity;
import com.kneelawk.graphlib.api.graph.user.GraphEntityType;
import com.kneelawk.graphlib.api.graph.user.LinkEntity;
import com.kneelawk.graphlib.api.graph.user.NodeEntity;
import com.kneelawk.graphlib.api.util.LinkPos;
import com.mojang.serialization.Codec;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.mixin.SimpleBlockGraphAccessor;
import eu.pb4.polyfactory.nodes.DirectionCheckingNode;
import eu.pb4.polyfactory.nodes.pipe.FlowNode;
import eu.pb4.polyfactory.nodes.pipe.PumpNode;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowData
implements GraphEntity<FlowData> {
    public static final class_2350[][] DIRECTIONS = (class_2350[][])class_156.method_654((Object)new class_2350[class_2350.values().length][], arr -> {
        for (class_2350 dir : class_2350.values()) {
            class_2350[] preference = new class_2350[class_2350.values().length];
            preference[0] = dir;
            preference[1] = dir.method_10153();
            class_2350.class_2351 startAxis = switch (dir.method_10166()) {
                default -> throw new MatchException(null, null);
                case class_2350.class_2351.field_11052, class_2350.class_2351.field_11051 -> class_2350.class_2351.field_11048;
                case class_2350.class_2351.field_11048 -> class_2350.class_2351.field_11051;
            };
            preference[2] = class_2350.method_10169((class_2350.class_2351)startAxis, (class_2350.class_2352)dir.method_10171());
            preference[3] = preference[2].method_10153();
            preference[4] = preference[2].method_35833(dir.method_10166());
            preference[5] = preference[2].method_35834(dir.method_10166());
            arr[dir.ordinal()] = preference;
        }
    });
    public static final Codec<FlowData> CODEC = Codec.unit(FlowData::new);
    public static final GraphEntityType<FlowData> TYPE = GraphEntityType.of((class_2960)ModInit.id("flow_data"), CODEC, FlowData::new, FlowData::split);
    public static FlowData EMPTY = new FlowData(){

        @Override
        public void runPushFlows(class_2338 pos, BooleanSupplier canContinue, FlowConsumer consumer) {
        }

        @Override
        public void setSourceStrength(class_2338 pos, double strength) {
        }
    };
    private GraphEntityContext ctx;
    private final Map<class_2338, CurrentFlow> currentFlow = new HashMap<class_2338, CurrentFlow>();
    private final Object2DoubleMap<class_2338> sourceStrength = new Object2DoubleOpenHashMap();
    private boolean isInvalid = true;

    public void runPushFlows(class_2338 pos, BooleanSupplier canContinue, FlowConsumer consumer) {
        this.runFlows(pos, true, canContinue, consumer);
    }

    public void runPullFlows(class_2338 pos, BooleanSupplier canContinue, FlowConsumer consumer) {
        this.runFlows(pos, false, canContinue, consumer);
    }

    public void runFlows(class_2338 pos, boolean push, BooleanSupplier canContinue, FlowConsumer consumer) {
        List<DirectionalFlow> flows;
        if (this.isInvalid && !this.rebuild()) {
            return;
        }
        CurrentFlow current = this.currentFlow.get(pos);
        if (current == null || !canContinue.getAsBoolean()) {
            return;
        }
        List<DirectionalFlow> list = flows = push ? current.push : current.pull;
        if (flows.isEmpty()) {
            return;
        }
        double total = 0.0;
        for (DirectionalFlow flow : flows) {
            total += flow.strength * this.sourceStrength.getDouble((Object)flow.source);
        }
        if (total == 0.0) {
            return;
        }
        for (DirectionalFlow flow : flows) {
            if (!canContinue.getAsBoolean()) {
                return;
            }
            double s = this.sourceStrength.getDouble((Object)flow.source);
            if (!(s > 0.0)) continue;
            double x = ((double)flow.range - flow.strength) / (double)flow.range;
            consumer.consume(flow.direction, s * (1.0 - x * x * x) * (s * flow.strength / total));
        }
    }

    public void setSourceStrength(class_2338 pos, double strength) {
        if (strength == 0.0) {
            this.sourceStrength.removeDouble((Object)pos);
        } else {
            this.sourceStrength.put((Object)pos, strength);
        }
    }

    private boolean rebuild() {
        if (!this.isInvalid || this.ctx == null) {
            return false;
        }
        long time = System.currentTimeMillis();
        this.isInvalid = false;
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(this.sourceStrength.size());
        ObjectArrayList states = new ObjectArrayList();
        class_2350[] dirs = new class_2350[6];
        int dirsI = 0;
        for (NodeHolder pump : this.ctx.getGraph().getCachedNodes(PumpNode.CACHE)) {
            states.clear();
            boolean isPulling = ((PumpNode)pump.getNode()).isPulling();
            class_2338.class_2339 mut = new class_2338.class_2339();
            states.add((Object)new LastState(((PumpNode)pump.getNode()).direction(), pump.getBlockPos(), ((PumpNode)pump.getNode()).range()));
            Multimap<class_2338, NodeHolder<BlockNode>> nodeMap = ((SimpleBlockGraphAccessor)this.ctx.getGraph()).getNodesInPos();
            block1: do {
                LastState state = (LastState)states.pop();
                class_2350 direction = state.direction;
                int distance = state.distance;
                mut.method_10101((class_2382)state.start);
                while (distance > 0) {
                    EnumSet<class_2350> multi;
                    NodeHolder node;
                    mut.method_10098(direction);
                    CurrentState flow2 = (CurrentState)map.get((Object)mut);
                    if (flow2 != null) {
                        node = flow2.node;
                        if (node == null) {
                            continue block1;
                        }
                    } else {
                        Iterator iter = nodeMap.get((Object)mut).iterator();
                        if (!iter.hasNext() || (node = (NodeHolder)iter.next()).getNode() instanceof PumpNode) continue block1;
                        flow2 = new CurrentState(new MutableInt(), EnumSet.noneOf(class_2350.class), EnumSet.noneOf(class_2350.class), (NodeHolder<BlockNode>)node);
                        map.put((Object)mut.method_10062(), (Object)flow2);
                    }
                    if (flow2.distance.getValue() >= distance) continue block1;
                    if (flow2.distance.getValue() < distance) {
                        flow2.push.clear();
                        flow2.pull.clear();
                    }
                    class_2350[] directions = DIRECTIONS[direction.ordinal()];
                    dirsI = 0;
                    BlockNode blockNode = node.getNode();
                    if (blockNode instanceof FlowNode) {
                        FlowNode check = (FlowNode)blockNode;
                        for (int i = 0; i < directions.length; ++i) {
                            class_2350 d = directions[i];
                            if (d == direction.method_10153() || !check.canFlowIn(d)) continue;
                            dirs[dirsI++] = d;
                        }
                    }
                    EnumSet<class_2350> main = isPulling ? flow2.push : flow2.pull;
                    EnumSet<class_2350> enumSet = multi = isPulling ? flow2.pull : flow2.push;
                    if (!main.add(direction.method_10153())) continue block1;
                    for (int i = 0; i < dirsI; ++i) {
                        multi.add(dirs[i]);
                    }
                    flow2.distance.setValue(distance--);
                    dirsI = 0;
                    BlockNode blockNode2 = node.getNode();
                    if (blockNode2 instanceof DirectionCheckingNode) {
                        DirectionCheckingNode check = (DirectionCheckingNode)blockNode2;
                        for (int i = 0; i < directions.length; ++i) {
                            class_2350 d = directions[i];
                            if (d == direction.method_10153() || !check.canConnectDir(d)) continue;
                            dirs[dirsI++] = d;
                        }
                    }
                    if (dirsI == 0) continue block1;
                    if (dirsI == 1) {
                        direction = dirs[0];
                        continue;
                    }
                    class_2338 cur = mut.method_10062();
                    boolean canContinue = false;
                    for (int i = 0; i < dirsI; ++i) {
                        class_2350 d = dirs[i];
                        if (d == direction) {
                            canContinue = true;
                            continue;
                        }
                        states.push((Object)new LastState(d, cur, distance));
                    }
                    if (canContinue) continue;
                    continue block1;
                }
            } while (!states.isEmpty());
            map.forEach((pos, flow) -> {
                CurrentFlow curr = this.currentFlow.computeIfAbsent((class_2338)pos, CurrentFlow::new);
                EnumSet<class_2350> push = flow.push;
                EnumSet<class_2350> pull = flow.pull;
                Integer distancex = flow.distance.getValue();
                for (class_2350 dir : push) {
                    curr.push.add(new DirectionalFlow(pump.getBlockPos(), dir, distancex.intValue(), ((PumpNode)pump.getNode()).range()));
                }
                for (class_2350 dir : pull) {
                    curr.pull.add(new DirectionalFlow(pump.getBlockPos(), dir, distancex.intValue(), ((PumpNode)pump.getNode()).range()));
                }
                push.clear();
                pull.clear();
                flow.distance.setValue(0);
            });
        }
        return true;
    }

    private void invalidate() {
        if (this.isInvalid) {
            return;
        }
        this.currentFlow.clear();
        this.isInvalid = true;
    }

    public void onPostNodeCreated(@NotNull NodeHolder<BlockNode> node, @Nullable NodeEntity nodeEntity) {
        super.onPostNodeCreated(node, nodeEntity);
        this.invalidate();
    }

    public void onPostNodeDestroyed(@NotNull NodeHolder<BlockNode> node, @Nullable NodeEntity nodeEntity, Map<LinkPos, LinkEntity> linkEntities) {
        super.onPostNodeDestroyed(node, nodeEntity, linkEntities);
        this.invalidate();
    }

    public void merge(@NotNull FlowData flowData) {
        this.invalidate();
    }

    public void onInit(@NotNull GraphEntityContext ctx) {
        this.ctx = ctx;
    }

    @NotNull
    public GraphEntityContext getContext() {
        return this.ctx;
    }

    @NotNull
    public GraphEntityType<?> getType() {
        return TYPE;
    }

    @NotNull
    private FlowData split(@NotNull BlockGraph originalGraph, @NotNull BlockGraph newGraph) {
        this.invalidate();
        return new FlowData();
    }

    public static interface FlowConsumer {
        public void consume(class_2350 var1, double var2);
    }

    private static class CurrentFlow {
        List<DirectionalFlow> push = new ArrayList<DirectionalFlow>();
        List<DirectionalFlow> pull = new ArrayList<DirectionalFlow>();

        public CurrentFlow(class_2338 pos) {
        }
    }

    private record DirectionalFlow(class_2338 source, class_2350 direction, double strength, int range) {
    }

    private record LastState(class_2350 direction, class_2338 start, int distance) {
    }

    private record CurrentState(MutableInt distance, EnumSet<class_2350> pull, EnumSet<class_2350> push, NodeHolder<BlockNode> node) {
    }
}

