/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.polydex.pages;

import eu.pb4.factorytools.api.recipe.CountedIngredient;
import eu.pb4.polydex.api.v1.recipe.PageBuilder;
import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexIngredient;
import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.polydex.PolydexCompatImpl;
import eu.pb4.polyfactory.polydex.PolydexTextures;
import eu.pb4.polyfactory.polydex.pages.PrioritizedRecipePage;
import eu.pb4.polyfactory.recipe.drain.DrainRecipe;
import eu.pb4.polyfactory.ui.FluidTextures;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.UiResourceCreator;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class DrainRecipePage<T extends DrainRecipe>
extends PrioritizedRecipePage<T> {
    private static final class_1799 ICON = FactoryItems.DRAIN.method_7854();
    private final List<PolydexIngredient<?>> ingredients;
    private final List<PolydexStack<?>> output = new ArrayList();
    private final PolydexStack<class_1799> displayResult;

    public DrainRecipePage(class_8786<T> recipe) {
        super(recipe);
        this.ingredients = PolydexCompatImpl.createIngredientsReg(this.getBaseIngredient(), this.getBaseFluids());
        this.displayResult = PolydexStack.of((class_1799)this.getResultStack());
        this.output.add(this.displayResult);
        this.output.addAll(PolydexCompatImpl.createFluids(this.getResultFluids()));
    }

    protected abstract class_1799 getResultStack();

    protected abstract List<FluidStack<?>> getBaseFluids();

    protected abstract List<FluidStack<?>> getResultFluids();

    protected abstract List<CountedIngredient> getBaseIngredient();

    @Nullable
    public class_2561 texture(class_3222 player) {
        return class_2561.method_43473().method_10852(PolydexTextures.DRAIN).method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.POLYDEX_OFFSET_N + GuiTextures.DRAIN_POLYDEX_FLUID_OFFSET)).method_10862(UiResourceCreator.STYLE)).method_10852(FluidTextures.MIXER_POLYDEX.render(a -> {
            for (FluidStack<?> x : this.getResultFluids()) {
                a.accept(x.instance(), Float.valueOf((float)((double)x.amount() / 81000.0)));
            }
        })).method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.DRAIN_POLYDEX_FLUID_OFFSET_N + GuiTextures.POLYDEX_OFFSET)).method_10862(UiResourceCreator.STYLE));
    }

    public boolean isOwner(MinecraftServer server, PolydexEntry entry) {
        for (PolydexStack<?> i : this.output) {
            if (!entry.isPartOf(i)) continue;
            return true;
        }
        return false;
    }

    public class_1799 entryIcon(@Nullable PolydexEntry entry, class_3222 player) {
        return ((PolydexStack)this.ingredients.getFirst().asStacks().getFirst()).toTypeDisplayItemStack(player);
    }

    public class_1799 typeIcon(class_3222 player) {
        return ICON;
    }

    public List<PolydexIngredient<?>> ingredients() {
        return this.ingredients;
    }

    public void createPage(@Nullable PolydexEntry entry, class_3222 player, PageBuilder layer) {
        layer.setIngredient(2, 1, this.ingredients.get(0));
        if (this.ingredients.size() > 1) {
            layer.setIngredient(2, 3, this.ingredients.get(1));
        }
        layer.setOutput(5, 2, new PolydexStack[]{this.displayResult});
        GuiElementBuilder fluid = GuiTextures.EMPTY_BUILDER.get();
        fluid.setName((class_2561)class_2561.method_43471((String)"text.polyfactory.polydex.created_fluids"));
        for (FluidStack<?> stack : this.getResultFluids()) {
            fluid.addLoreLine((class_2561)stack.toTextRequired().method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(false))));
        }
        layer.set(6, 1, fluid);
        layer.set(6, 2, fluid);
        layer.set(6, 3, fluid);
    }
}

