/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.util.ColoredItem;
import eu.pb4.polyfactory.recipe.FactoryRecipeSerializers;
import eu.pb4.polyfactory.util.DyeColorExtra;
import eu.pb4.polyfactory.util.FactoryUtil;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3955;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9694;

public record ColoringCraftingRecipe(String group, class_1792 input, int maxCount) implements class_3955
{
    public static final MapCodec<ColoringCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(x -> x.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ColoringCraftingRecipe::group), (App)class_7923.field_41178.method_39673().fieldOf("input").forGetter(ColoringCraftingRecipe::input), (App)Codec.INT.optionalFieldOf("max_count", (Object)8).forGetter(ColoringCraftingRecipe::maxCount)).apply((Applicative)x, ColoringCraftingRecipe::new));

    public static class_8786<ColoringCraftingRecipe> of(String id, class_1792 item) {
        return new class_8786(FactoryUtil.id("crafting/" + id), (class_1860)new ColoringCraftingRecipe("", item, 8));
    }

    public static class_8786<ColoringCraftingRecipe> of(String id, class_1792 item, int count) {
        return new class_8786(FactoryUtil.id("crafting/" + id), (class_1860)new ColoringCraftingRecipe("", item, count));
    }

    public class_7710 method_45441() {
        return class_7710.field_40251;
    }

    public boolean matches(class_9694 inventory, class_1937 world) {
        boolean hasDye = false;
        int count = 0;
        for (class_1799 stack : inventory.method_59989()) {
            if (stack.method_31573(ConventionalItemTags.DYES)) {
                if (hasDye) {
                    return false;
                }
                hasDye = true;
                continue;
            }
            if (stack.method_31574(this.input)) {
                ++count;
                continue;
            }
            if (stack.method_7960()) continue;
            return false;
        }
        return hasDye && count > 0 && count <= this.maxCount;
    }

    public class_1799 craft(class_9694 inventory, class_7225.class_7874 registryManager) {
        int color = -1;
        int count = 0;
        class_1799 og = class_1799.field_8037;
        for (class_1799 stack : inventory.method_59989()) {
            if (stack.method_31573(ConventionalItemTags.DYES)) {
                color = DyeColorExtra.getColor(stack);
                continue;
            }
            if (!stack.method_31574(this.input)) continue;
            ++count;
            og = stack;
        }
        class_1799 out = ColoredItem.stackCrafting(this.input, count, color);
        if (this.maxCount == 1) {
            Integer c = (Integer)out.method_57824(FactoryDataComponents.COLOR);
            out.method_59692(og.method_57380());
            out.method_57379(FactoryDataComponents.COLOR, (Object)c);
        }
        return out;
    }

    public boolean method_8113(int width, int height) {
        return width * height > 1;
    }

    public class_1799 method_8110(class_7225.class_7874 registryManager) {
        return this.input.method_7854();
    }

    public class_1865<?> method_8119() {
        return FactoryRecipeSerializers.CRAFTING_COLORING;
    }
}

