/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.recipe.mixing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polyfactory.block.mechanical.machines.crafting.MixerBlockEntity;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.recipe.FactoryRecipeSerializers;
import eu.pb4.polyfactory.recipe.input.MixingInput;
import eu.pb4.polyfactory.recipe.mixing.MixingRecipe;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public record BrewingMixingRecipe(String group, class_1856 ingredient, FluidInstance<?> from, FluidInstance<?> to, long minimumResult, long maxResult, double time, double minimumSpeed, double optimalSpeed, float minimumTemperature, float maxTemperature) implements MixingRecipe
{
    public static final MapCodec<BrewingMixingRecipe> CODEC = RecordCodecBuilder.mapCodec(x -> x.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(BrewingMixingRecipe::group), (App)class_1856.field_46096.fieldOf("ingredient").forGetter(BrewingMixingRecipe::ingredient), (App)FluidInstance.CODEC.fieldOf("from").forGetter(BrewingMixingRecipe::from), (App)FluidInstance.CODEC.fieldOf("to").forGetter(BrewingMixingRecipe::to), (App)Codec.LONG.fieldOf("min_amount").forGetter(BrewingMixingRecipe::minimumResult), (App)Codec.LONG.fieldOf("max_amount").forGetter(BrewingMixingRecipe::maxResult), (App)Codec.DOUBLE.fieldOf("time").forGetter(BrewingMixingRecipe::time), (App)Codec.DOUBLE.optionalFieldOf("minimum_speed", (Object)1.0).forGetter(BrewingMixingRecipe::minimumSpeed), (App)Codec.DOUBLE.optionalFieldOf("optimal_speed", (Object)1.0).forGetter(BrewingMixingRecipe::optimalSpeed), (App)Codec.FLOAT.optionalFieldOf("minimal_temperature", (Object)Float.valueOf(-1.0f)).forGetter(BrewingMixingRecipe::minimumTemperature), (App)Codec.FLOAT.optionalFieldOf("max_temperature", (Object)Float.valueOf(2.0f)).forGetter(BrewingMixingRecipe::maxTemperature)).apply((Applicative)x, BrewingMixingRecipe::new));

    @Override
    public Iterable<class_1799> remainders(MixingInput input) {
        return List.of();
    }

    public String method_8112() {
        return this.group;
    }

    public class_2371<class_1856> method_8117() {
        return class_2371.method_10213((int)1, (Object)this.ingredient);
    }

    public boolean matches(MixingInput inventory, class_1937 world) {
        if (inventory.getFluid(this.from) < this.minimumResult) {
            return false;
        }
        for (class_1799 x : inventory.stacks()) {
            if (!this.ingredient.method_8093(x)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void applyRecipeUse(MixerBlockEntity inventory, class_1937 world) {
        long amount = class_3532.method_53062((long)inventory.getFluidContainer().get(this.from), (long)this.minimumResult, (long)this.maxResult);
        inventory.getFluidContainer().extract(this.from, amount, false);
        inventory.getFluidContainer().insert(this.to, amount, false);
        for (int i = 0; i < 6; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!this.ingredient.method_8093(stack)) continue;
            stack.method_7934(1);
            if (!stack.method_7960()) break;
            inventory.method_5447(i, class_1799.field_8037);
            break;
        }
    }

    @Override
    public double optimalSpeed(MixingInput input) {
        return this.optimalSpeed;
    }

    @Override
    public double minimumSpeed(MixingInput input) {
        return this.minimumSpeed;
    }

    @Override
    public float minimumTemperature(MixingInput input) {
        return this.minimumTemperature;
    }

    @Override
    public float maxTemperature(MixingInput input) {
        return this.maxTemperature;
    }

    @Override
    public double time(MixingInput input) {
        return this.time;
    }

    public class_1799 craft(MixingInput inventory, class_7225.class_7874 registryManager) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 registryManager) {
        return class_1799.field_8037;
    }

    public class_1865<?> method_8119() {
        return FactoryRecipeSerializers.MIXING_BREWING;
    }
}

