/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.recipe.mixing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polyfactory.block.mechanical.machines.crafting.MixerBlockEntity;
import eu.pb4.polyfactory.item.util.ColoredItem;
import eu.pb4.polyfactory.recipe.FactoryRecipeSerializers;
import eu.pb4.polyfactory.recipe.input.MixingInput;
import eu.pb4.polyfactory.recipe.mixing.MixingRecipe;
import eu.pb4.polyfactory.util.DyeColorExtra;
import eu.pb4.polyfactory.util.FactoryUtil;
import java.util.List;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;

public record ColoringMixingRecipe(String group, class_1792 input, int maxCount, double time, double minimumSpeed, double optimalSpeed, float minimumTemperature, float maxTemperature) implements MixingRecipe
{
    public static final MapCodec<ColoringMixingRecipe> CODEC = RecordCodecBuilder.mapCodec(x -> x.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ColoringMixingRecipe::group), (App)class_7923.field_41178.method_39673().fieldOf("input").forGetter(ColoringMixingRecipe::input), (App)Codec.INT.optionalFieldOf("max_count", (Object)12).forGetter(ColoringMixingRecipe::maxCount), (App)Codec.DOUBLE.fieldOf("time").forGetter(ColoringMixingRecipe::time), (App)Codec.DOUBLE.optionalFieldOf("minimum_speed", (Object)1.0).forGetter(ColoringMixingRecipe::minimumSpeed), (App)Codec.DOUBLE.optionalFieldOf("optimal_speed", (Object)1.0).forGetter(ColoringMixingRecipe::optimalSpeed), (App)Codec.FLOAT.optionalFieldOf("minimal_temperature", (Object)Float.valueOf(-1.0f)).forGetter(ColoringMixingRecipe::minimumTemperature), (App)Codec.FLOAT.optionalFieldOf("max_temperature", (Object)Float.valueOf(2.0f)).forGetter(ColoringMixingRecipe::maxTemperature)).apply((Applicative)x, ColoringMixingRecipe::new));

    public static class_8786<ColoringMixingRecipe> of(String id, class_1792 item, double mixingTime, double minimumSpeed, double optimalSpeed) {
        return new class_8786(FactoryUtil.id("mixing/" + id), (class_1860)new ColoringMixingRecipe("", item, 12, mixingTime, minimumSpeed, optimalSpeed, -1.0f, 2.0f));
    }

    public static class_8786<ColoringMixingRecipe> of(String id, class_1792 item, int count, double mixingTime, double minimumSpeed, double optimalSpeed) {
        return new class_8786(FactoryUtil.id("mixing/" + id), (class_1860)new ColoringMixingRecipe("", item, count, mixingTime, minimumSpeed, optimalSpeed, -1.0f, 2.0f));
    }

    public boolean matches(MixingInput inventory, class_1937 world) {
        if (!inventory.fluids().isEmpty()) {
            return false;
        }
        boolean hasDye = false;
        int count = 0;
        for (int i = 0; i < 6; ++i) {
            class_1799 stack = inventory.method_59984(i);
            if (stack.method_31573(ConventionalItemTags.DYES)) {
                if (hasDye) {
                    return false;
                }
                hasDye = true;
                continue;
            }
            if (stack.method_31574(this.input)) {
                ++count;
                continue;
            }
            if (stack.method_7960()) continue;
            return false;
        }
        return hasDye && count > 0 && count <= this.maxCount;
    }

    public class_1799 craft(MixingInput inventory, class_7225.class_7874 registryManager) {
        int color = -1;
        int count = 0;
        for (int i = 0; i < 6; ++i) {
            class_1799 stack = inventory.method_59984(i);
            if (stack.method_31573(ConventionalItemTags.DYES)) {
                color = DyeColorExtra.getColor(stack);
                continue;
            }
            if (!stack.method_31574(this.input)) continue;
            ++count;
        }
        return ColoredItem.stackCrafting(this.input, count, color);
    }

    public boolean method_8113(int width, int height) {
        return width * height > 1;
    }

    public class_1799 method_8110(class_7225.class_7874 registryManager) {
        return this.input.method_7854();
    }

    public class_1865<?> method_8119() {
        return FactoryRecipeSerializers.MIXING_COLORING;
    }

    @Override
    public Iterable<class_1799> remainders(MixingInput input) {
        return List.of();
    }

    @Override
    public void applyRecipeUse(MixerBlockEntity inventory, class_1937 world) {
        boolean hasDye = false;
        int count = this.maxCount;
        for (int i = 0; i < 6; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_31573(ConventionalItemTags.DYES) && !hasDye) {
                hasDye = true;
                stack.method_7934(1);
            } else if (stack.method_31574(this.input) && count != 0) {
                int removable = Math.min(count, stack.method_7947());
                stack.method_7934(count -= removable);
            }
            if (!stack.method_7960() || stack == class_1799.field_8037) continue;
            inventory.method_5447(i, class_1799.field_8037);
        }
    }

    @Override
    public double optimalSpeed(MixingInput input) {
        return this.optimalSpeed;
    }

    @Override
    public double minimumSpeed(MixingInput input) {
        return this.minimumSpeed;
    }

    @Override
    public float minimumTemperature(MixingInput input) {
        return this.minimumTemperature;
    }

    @Override
    public float maxTemperature(MixingInput input) {
        return this.maxTemperature;
    }

    @Override
    public double time(MixingInput input) {
        return this.time;
    }
}

