/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.recipe.spout;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.factorytools.api.recipe.CountedIngredient;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.recipe.FactoryRecipeSerializers;
import eu.pb4.polyfactory.recipe.drain.DrainRecipe;
import eu.pb4.polyfactory.recipe.input.DrainInput;
import eu.pb4.polyfactory.recipe.spout.SpoutRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public record SimpleDrainRecipe(CountedIngredient item, Optional<class_1856> catalyst, List<FluidStack<?>> fluidInput, List<FluidStack<?>> fluidOutput, class_1799 output, class_6880<class_3414> soundEvent, boolean requirePlayer, double time) implements DrainRecipe
{
    public static final MapCodec<SimpleDrainRecipe> CODEC = RecordCodecBuilder.mapCodec(x -> x.group((App)CountedIngredient.CODEC.fieldOf("item").forGetter(SimpleDrainRecipe::item), (App)class_1856.field_46095.optionalFieldOf("catalyst").forGetter(SimpleDrainRecipe::catalyst), (App)FluidStack.CODEC.listOf().optionalFieldOf("fluid_input", List.of()).forGetter(SimpleDrainRecipe::fluidInput), (App)FluidStack.CODEC.listOf().optionalFieldOf("fluid_output", List.of()).forGetter(SimpleDrainRecipe::fluidOutput), (App)class_1799.field_49747.fieldOf("result").forGetter(SimpleDrainRecipe::output), (App)class_3414.field_41699.fieldOf("sound").forGetter(SimpleDrainRecipe::soundEvent), (App)Codec.BOOL.optionalFieldOf("require_player", (Object)false).forGetter(SimpleDrainRecipe::requirePlayer), (App)Codec.DOUBLE.fieldOf("time").forGetter(SimpleDrainRecipe::time)).apply((Applicative)x, SimpleDrainRecipe::new));

    public static SimpleDrainRecipe fromItem(class_1792 item, FluidStack<?> stack, class_1792 out, class_3414 sound) {
        return new SimpleDrainRecipe(CountedIngredient.ofItems((int)1, (class_1935[])new class_1935[]{item}), Optional.empty(), List.of(), List.of(stack), out.method_7854(), (class_6880<class_3414>)class_7923.field_41172.method_47983((Object)sound), false, SpoutRecipe.getTime(stack.instance(), stack.amount()));
    }

    public static SimpleDrainRecipe toItem(class_1792 item, FluidStack<?> stack, class_1792 out, class_3414 sound) {
        return new SimpleDrainRecipe(CountedIngredient.ofItems((int)1, (class_1935[])new class_1935[]{item}), Optional.empty(), List.of(stack), List.of(), out.method_7854(), (class_6880<class_3414>)class_7923.field_41172.method_47983((Object)sound), true, SpoutRecipe.getTime(stack.instance(), stack.amount()));
    }

    @Override
    public int decreasedInputItemAmount(DrainInput input) {
        return this.item.count();
    }

    public boolean matches(DrainInput input, class_1937 world) {
        if (this.requirePlayer && !input.isPlayer() || !this.item.test(input.stack()) || this.catalyst.isPresent() && !this.catalyst.get().method_8093(input.catalyst())) {
            return false;
        }
        for (FluidStack<?> fluid : this.fluidInput) {
            if (input.getFluid(fluid.instance()) >= fluid.amount()) continue;
            return false;
        }
        long stored = input.fluidContainer().stored();
        for (FluidStack<?> fluid : this.fluidOutput) {
            stored += fluid.amount();
        }
        return input.fluidContainer().capacity() >= stored;
    }

    public class_1799 craft(DrainInput input, class_7225.class_7874 lookup) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return this.output;
    }

    public class_1865<?> method_8119() {
        return FactoryRecipeSerializers.DRAIN_SIMPLE;
    }

    @Override
    public List<FluidStack<?>> fluidOutput(DrainInput input) {
        return this.fluidOutput;
    }

    @Override
    public List<FluidStack<?>> fluidInput(DrainInput input) {
        return this.fluidInput;
    }

    @Override
    public double time(DrainInput input) {
        return this.time;
    }
}

