/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.recipe.spout;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.factorytools.api.recipe.CountedIngredient;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.recipe.FactoryRecipeSerializers;
import eu.pb4.polyfactory.recipe.input.SpoutInput;
import eu.pb4.polyfactory.recipe.spout.SpoutRecipe;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3902;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public record SimpleSpoutRecipe(CountedIngredient item, List<FluidStack<?>> fluidInput, class_1799 output, boolean copyComponents, class_6880<class_3414> soundEvent, double time) implements SpoutRecipe
{
    public static final MapCodec<SimpleSpoutRecipe> CODEC = RecordCodecBuilder.mapCodec(x -> x.group((App)CountedIngredient.CODEC.fieldOf("item").forGetter(SimpleSpoutRecipe::item), (App)FluidStack.CODEC.listOf().optionalFieldOf("fluid_input", List.of()).forGetter(SimpleSpoutRecipe::fluidInput), (App)class_1799.field_49747.fieldOf("result").forGetter(SimpleSpoutRecipe::output), (App)Codec.BOOL.optionalFieldOf("copy_components", (Object)false).forGetter(SimpleSpoutRecipe::copyComponents), (App)class_3414.field_41699.fieldOf("sound").forGetter(SimpleSpoutRecipe::soundEvent), (App)Codec.DOUBLE.fieldOf("time").forGetter(SimpleSpoutRecipe::time)).apply((Applicative)x, SimpleSpoutRecipe::new));

    public static SimpleSpoutRecipe toItem(class_1792 item, FluidStack<?> stack, class_1792 out, class_3414 sound) {
        return new SimpleSpoutRecipe(CountedIngredient.ofItems((int)1, (class_1935[])new class_1935[]{item}), List.of(stack), out.method_7854(), false, (class_6880<class_3414>)class_7923.field_41172.method_47983((Object)sound), SpoutRecipe.getTime(stack.instance(), stack.amount()));
    }

    public static SimpleSpoutRecipe toItemCopy(class_1792 item, FluidStack<?> stack, class_1792 out, class_3414 sound) {
        return new SimpleSpoutRecipe(CountedIngredient.ofItems((int)1, (class_1935[])new class_1935[]{item}), List.of(stack), out.method_7854(), true, (class_6880<class_3414>)class_7923.field_41172.method_47983((Object)sound), SpoutRecipe.getTime(stack.instance(), stack.amount()));
    }

    public static SimpleSpoutRecipe template(class_1792 template, FluidStack<class_3902> stack, class_1792 out, class_3414 sound) {
        return new SimpleSpoutRecipe(CountedIngredient.ofItems((int)0, (class_1935[])new class_1935[]{template}), List.of(stack), out.method_7854(), false, (class_6880<class_3414>)class_7923.field_41172.method_47983((Object)sound), SpoutRecipe.getTime(stack.instance(), stack.amount()));
    }

    @Override
    public int decreasedInputItemAmount(SpoutInput input) {
        return this.item.count();
    }

    public boolean matches(SpoutInput input, class_1937 world) {
        if (!this.item.test(input.stack())) {
            return false;
        }
        for (FluidStack<?> fluid : this.fluidInput) {
            if (input.getFluid(fluid.instance()) >= fluid.amount()) continue;
            return false;
        }
        return true;
    }

    public class_1799 craft(SpoutInput input, class_7225.class_7874 lookup) {
        class_1799 out = this.output.method_7972();
        if (this.copyComponents) {
            out.method_59692(input.stack().method_57380());
        }
        return out;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return this.output;
    }

    public class_1865<?> method_8119() {
        return FactoryRecipeSerializers.SPOUT_SIMPLE;
    }

    @Override
    public List<FluidStack<?>> fluidInput(SpoutInput input) {
        return this.fluidInput;
    }

    @Override
    public double time(SpoutInput input) {
        return this.time;
    }
}

