/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.ui;

import eu.pb4.polyfactory.polydex.PolydexTextures;
import eu.pb4.polyfactory.ui.UiResourceCreator;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9334;

public class GuiTextures {
    public static final Function<class_2561, class_2561> CRAFTER = UiResourceCreator.background("crafter");
    public static final Function<class_2561, class_2561> GRINDER = UiResourceCreator.background("grinder");
    public static final Function<class_2561, class_2561> PRESS = UiResourceCreator.background("press");
    public static final Function<class_2561, class_2561> MIXER = UiResourceCreator.background("mixer");
    public static final Function<class_2561, class_2561> MECHANICAL_DRAIN = UiResourceCreator.background("mechanical_drain");
    public static final Function<class_2561, class_2561> MECHANICAL_SPOUT = UiResourceCreator.background("mechanical_spout");
    public static final Function<class_2561, class_2561> MECHANICAL_SPOUT_NO_CONN = UiResourceCreator.background("mechanical_spout_noconn");
    public static final Function<class_2561, class_2561> STEAM_ENGINE = UiResourceCreator.background("steam_engine");
    public static final Function<class_2561, class_2561> CENTER_SLOT_GENERIC = UiResourceCreator.background("center_slot");
    public static final Function<class_2561, class_2561> FILL3 = UiResourceCreator.background("fill3");
    public static final Supplier<GuiElementBuilder> EMPTY_BUILDER = UiResourceCreator.icon16("empty");
    public static final GuiElement EMPTY = EMPTY_BUILDER.get().hideTooltip().build();
    public static final Supplier<GuiElementBuilder> POLYDEX_BUTTON = UiResourceCreator.icon32("polydex");
    public static final Supplier<GuiElementBuilder> PLUS_BUTTON = UiResourceCreator.icon32("button/plus");
    public static final Supplier<GuiElementBuilder> MINUS_BUTTON = UiResourceCreator.icon32("button/minus");
    public static final Supplier<GuiElementBuilder> LOCKED_SLOT = UiResourceCreator.icon32("locked_slot");
    public static final Progress FLAME = Progress.createVertical("flame", 1, 14, true);
    public static final Progress ICE = Progress.createVertical("ice", 1, 14, true);
    public static final Progress FLAME_OFFSET_RIGHT = Progress.createVertical32Right("flame_offset_right", 9, 22, true);
    public static final Progress ICE_OFFSET_RIGHT = Progress.createVertical32Right("ice_offset_right", 9, 22, true);
    public static final Progress PROGRESS_VERTICAL = Progress.createVertical("progress_vertical", 0, 15, false);
    public static final Progress PROGRESS_HORIZONTAL = Progress.createHorizontal("progress_horizontal", 0, 15, false);
    public static final Progress PROGRESS_HORIZONTAL_OFFSET_RIGHT = Progress.createHorizontal32Right("progress_horizontal_offset_right", 6, 26, false);
    public static final Temperature TEMPERATURE = new Temperature(FLAME, ICE);
    public static final Temperature TEMPERATURE_OFFSET_RIGHT = new Temperature(FLAME_OFFSET_RIGHT, ICE_OFFSET_RIGHT);
    public static final IntFunction<GuiElementBuilder>[] NUMBERS_FLAT = UiResourceCreator.createNumbers("flat/");
    public static final IntFunction<GuiElementBuilder>[] NUMBERS_SHADOW = UiResourceCreator.createNumbers("shadow/");
    public static final char SPACE_1 = UiResourceCreator.space(1);
    public static final char POLYDEX_OFFSET = UiResourceCreator.space(168);
    public static final char POLYDEX_OFFSET_N = UiResourceCreator.space(-168);
    public static final char MIXER_FLUID_OFFSET = UiResourceCreator.space(20);
    public static final char MIXER_FLUID_OFFSET_N = UiResourceCreator.space(-20);
    public static final char MECHANICAL_DRAIN_FLUID_OFFSET = UiResourceCreator.space(110);
    public static final char MECHANICAL_DRAIN_FLUID_OFFSET_N = UiResourceCreator.space(-110);
    public static final char MECHANICAL_SPOUT_FLUID_OFFSET = UiResourceCreator.space(38);
    public static final char MECHANICAL_SPOUT_FLUID_OFFSET_N = UiResourceCreator.space(-38);
    public static final char DRAIN_POLYDEX_FLUID_OFFSET = UiResourceCreator.space(117);
    public static final char DRAIN_POLYDEX_FLUID_OFFSET_N = UiResourceCreator.space(-117);
    public static final char SPOUT_POLYDEX_FLUID_OFFSET = UiResourceCreator.space(45);
    public static final char SPOUT_POLYDEX_FLUID_OFFSET_N = UiResourceCreator.space(-45);
    public static final char MIXER_POLYDEX_FLUID_OFFSET_1 = UiResourceCreator.space(27);
    public static final char MIXER_POLYDEX_FLUID_OFFSET_2 = UiResourceCreator.space(108);
    public static final char MIXER_POLYDEX_FLUID_OFFSET_N = UiResourceCreator.space(-135);

    public static void register() {
        PolydexTextures.register();
    }

    public record Progress(GuiElement[] elements, class_1799[] withTooltip) {
        public GuiElement get(float progress) {
            return this.elements[Math.min((int)(progress * (float)this.elements.length), this.elements.length - 1)];
        }

        public class_1799 getNamed(float progress, class_2561 text) {
            class_1799 base = this.withTooltip[Math.min((int)(progress * (float)this.withTooltip.length), this.withTooltip.length - 1)].method_7972();
            base.method_57379(class_9334.field_50239, (Object)text);
            return base;
        }

        private static Progress create(int size, IntFunction<GuiElementBuilder> function) {
            GuiElement[] elements = new GuiElement[size + 1];
            class_1799[] withTooltip = new class_1799[size + 1];
            elements[0] = EMPTY;
            withTooltip[0] = EMPTY.getItemStack().method_7972();
            for (int i = 1; i <= size; ++i) {
                elements[i] = function.apply(i - 1).hideTooltip().build();
                withTooltip[i] = function.apply(i - 1).asStack();
            }
            return new Progress(elements, withTooltip);
        }

        public static Progress createVertical(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            IntFunction<GuiElementBuilder> function = UiResourceCreator.verticalProgress16(path, start, stop, reverse);
            return Progress.create(size, function);
        }

        public static Progress createHorizontal(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            IntFunction<GuiElementBuilder> function = UiResourceCreator.horizontalProgress16(path, start, stop, reverse);
            return Progress.create(size, function);
        }

        public static Progress createHorizontal32(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            IntFunction<GuiElementBuilder> function = UiResourceCreator.horizontalProgress32(path, start, stop, reverse);
            return Progress.create(size, function);
        }

        public static Progress createHorizontal32Right(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            IntFunction<GuiElementBuilder> function = UiResourceCreator.horizontalProgress32Right(path, start, stop, reverse);
            return Progress.create(size, function);
        }

        public static Progress createVertical32Right(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            IntFunction<GuiElementBuilder> function = UiResourceCreator.verticalProgress32Right(path, start, stop, reverse);
            return Progress.create(size, function);
        }
    }

    public record Temperature(Progress fire, Progress ice) {
        public GuiElement get(float progress) {
            if (progress < 0.0f) {
                return this.ice.get(-progress);
            }
            return this.fire.get(progress);
        }

        public class_1799 getNamed(float progress, class_2561 text) {
            if (progress < 0.0f) {
                return this.ice.getNamed(-progress, text);
            }
            return this.fire.getNamed(progress, text);
        }
    }
}

